import { NextFunction, Response } from 'express';
import { DatabaseBackupDeleteDto, DatabaseBackupListResponseDto } from 'src/dtos/database-backup.dto';
import { LoggingRepository } from 'src/repositories/logging.repository';
import { LoginDetails } from 'src/services/auth.service';
import { DatabaseBackupService } from 'src/services/database-backup.service';
import { MaintenanceService } from 'src/services/maintenance.service';
import { FilenameParamDto } from 'src/validation';
export declare class DatabaseBackupController {
    private logger;
    private service;
    private maintenanceService;
    constructor(logger: LoggingRepository, service: DatabaseBackupService, maintenanceService: MaintenanceService);
    listDatabaseBackups(): Promise<DatabaseBackupListResponseDto>;
    downloadDatabaseBackup({ filename }: FilenameParamDto, res: Response, next: NextFunction): Promise<void>;
    deleteDatabaseBackup(dto: DatabaseBackupDeleteDto): Promise<void>;
    startDatabaseRestoreFlow(loginDetails: LoginDetails, res: Response): Promise<void>;
    uploadDatabaseBackup(file: Express.Multer.File): Promise<void>;
}
