import { AuthDto } from 'src/dtos/auth.dto';
import { AssetFaceCreateDto, AssetFaceDeleteDto, AssetFaceResponseDto, FaceDto, PersonResponseDto } from 'src/dtos/person.dto';
import { PersonService } from 'src/services/person.service';
import { UUIDParamDto } from 'src/validation';
export declare class FaceController {
    private service;
    constructor(service: PersonService);
    createFace(auth: AuthDto, dto: AssetFaceCreateDto): Promise<void>;
    getFaces(auth: AuthDto, dto: FaceDto): Promise<AssetFaceResponseDto[]>;
    reassignFacesById(auth: AuthDto, { id }: UUIDParamDto, dto: FaceDto): Promise<PersonResponseDto>;
    deleteFace(auth: AuthDto, { id }: UUIDParamDto, dto: AssetFaceDeleteDto): Promise<void>;
}
