"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SearchController = void 0;
const openapi = require("@nestjs/swagger");
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const decorators_1 = require("../decorators");
const auth_dto_1 = require("../dtos/auth.dto");
const search_dto_1 = require("../dtos/search.dto");
const enum_1 = require("../enum");
const auth_guard_1 = require("../middleware/auth.guard");
const search_service_1 = require("../services/search.service");
let SearchController = class SearchController {
    service;
    constructor(service) {
        this.service = service;
    }
    searchAssets(auth, dto) {
        return this.service.searchMetadata(auth, dto);
    }
    searchAssetStatistics(auth, dto) {
        return this.service.searchStatistics(auth, dto);
    }
    searchRandom(auth, dto) {
        return this.service.searchRandom(auth, dto);
    }
    searchLargeAssets(auth, dto) {
        return this.service.searchLargeAssets(auth, dto);
    }
    searchSmart(auth, dto) {
        return this.service.searchSmart(auth, dto);
    }
    getExploreData(auth) {
        return this.service.getExploreData(auth);
    }
    searchPerson(auth, dto) {
        return this.service.searchPerson(auth, dto);
    }
    searchPlaces(dto) {
        return this.service.searchPlaces(dto);
    }
    getAssetsByCity(auth) {
        return this.service.getAssetsByCity(auth);
    }
    getSearchSuggestions(auth, dto) {
        return this.service.getSearchSuggestions(auth, dto);
    }
};
exports.SearchController = SearchController;
__decorate([
    (0, common_1.Post)('metadata'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.AssetRead }),
    (0, common_1.HttpCode)(common_1.HttpStatus.OK),
    (0, decorators_1.Endpoint)({
        summary: 'Search assets by metadata',
        description: 'Search for assets based on various metadata criteria.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: common_1.HttpStatus.OK, type: require("../dtos/search.dto").SearchResponseDto }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, search_dto_1.MetadataSearchDto]),
    __metadata("design:returntype", Promise)
], SearchController.prototype, "searchAssets", null);
__decorate([
    (0, common_1.Post)('statistics'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.AssetStatistics }),
    (0, common_1.HttpCode)(common_1.HttpStatus.OK),
    (0, decorators_1.Endpoint)({
        summary: 'Search asset statistics',
        description: 'Retrieve statistical data about assets based on search criteria, such as the total matching count.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: common_1.HttpStatus.OK, type: require("../dtos/search.dto").SearchStatisticsResponseDto }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, search_dto_1.StatisticsSearchDto]),
    __metadata("design:returntype", Promise)
], SearchController.prototype, "searchAssetStatistics", null);
__decorate([
    (0, common_1.Post)('random'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.AssetRead }),
    (0, common_1.HttpCode)(common_1.HttpStatus.OK),
    (0, decorators_1.Endpoint)({
        summary: 'Search random assets',
        description: 'Retrieve a random selection of assets based on the provided criteria.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: common_1.HttpStatus.OK, type: [require("../dtos/asset-response.dto").AssetResponseDto] }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, search_dto_1.RandomSearchDto]),
    __metadata("design:returntype", Promise)
], SearchController.prototype, "searchRandom", null);
__decorate([
    (0, common_1.Post)('large-assets'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.AssetRead }),
    (0, common_1.HttpCode)(common_1.HttpStatus.OK),
    (0, decorators_1.Endpoint)({
        summary: 'Search large assets',
        description: 'Search for assets that are considered large based on specified criteria.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: common_1.HttpStatus.OK, type: [require("../dtos/asset-response.dto").AssetResponseDto] }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Query)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, search_dto_1.LargeAssetSearchDto]),
    __metadata("design:returntype", Promise)
], SearchController.prototype, "searchLargeAssets", null);
__decorate([
    (0, common_1.Post)('smart'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.AssetRead }),
    (0, common_1.HttpCode)(common_1.HttpStatus.OK),
    (0, decorators_1.Endpoint)({
        summary: 'Smart asset search',
        description: 'Perform a smart search for assets by using machine learning vectors to determine relevance.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: common_1.HttpStatus.OK, type: require("../dtos/search.dto").SearchResponseDto }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, search_dto_1.SmartSearchDto]),
    __metadata("design:returntype", Promise)
], SearchController.prototype, "searchSmart", null);
__decorate([
    (0, common_1.Get)('explore'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.AssetRead }),
    (0, decorators_1.Endpoint)({
        summary: 'Retrieve explore data',
        description: 'Retrieve data for the explore section, such as popular people and places.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: 200, type: [require("../dtos/search.dto").SearchExploreResponseDto] }),
    __param(0, (0, auth_guard_1.Auth)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto]),
    __metadata("design:returntype", Promise)
], SearchController.prototype, "getExploreData", null);
__decorate([
    (0, common_1.Get)('person'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.PersonRead }),
    (0, decorators_1.Endpoint)({
        summary: 'Search people',
        description: 'Search for people by name.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: 200, type: [require("../dtos/person.dto").PersonResponseDto] }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Query)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, search_dto_1.SearchPeopleDto]),
    __metadata("design:returntype", Promise)
], SearchController.prototype, "searchPerson", null);
__decorate([
    (0, common_1.Get)('places'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.AssetRead }),
    (0, decorators_1.Endpoint)({
        summary: 'Search places',
        description: 'Search for places by name.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: 200, type: [require("../dtos/search.dto").PlacesResponseDto] }),
    __param(0, (0, common_1.Query)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [search_dto_1.SearchPlacesDto]),
    __metadata("design:returntype", Promise)
], SearchController.prototype, "searchPlaces", null);
__decorate([
    (0, common_1.Get)('cities'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.AssetRead }),
    (0, decorators_1.Endpoint)({
        summary: 'Retrieve assets by city',
        description: 'Retrieve a list of assets with each asset belonging to a different city. This endpoint is used on the places pages to show a single thumbnail for each city the user has assets in.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: 200, type: [require("../dtos/asset-response.dto").AssetResponseDto] }),
    __param(0, (0, auth_guard_1.Auth)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto]),
    __metadata("design:returntype", Promise)
], SearchController.prototype, "getAssetsByCity", null);
__decorate([
    (0, common_1.Get)('suggestions'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.AssetRead }),
    (0, decorators_1.Endpoint)({
        summary: 'Retrieve search suggestions',
        description: 'Retrieve search suggestions based on partial input. This endpoint is used for typeahead search features.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: 200, type: [String] }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Query)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, search_dto_1.SearchSuggestionRequestDto]),
    __metadata("design:returntype", Promise)
], SearchController.prototype, "getSearchSuggestions", null);
exports.SearchController = SearchController = __decorate([
    (0, swagger_1.ApiTags)(enum_1.ApiTag.Search),
    (0, common_1.Controller)('search'),
    __metadata("design:paramtypes", [search_service_1.SearchService])
], SearchController);
//# sourceMappingURL=search.controller.js.map