import { NextFunction, Response } from 'express';
import { AuthDto } from 'src/dtos/auth.dto';
import { LicenseKeyDto, LicenseResponseDto } from 'src/dtos/license.dto';
import { OnboardingDto, OnboardingResponseDto } from 'src/dtos/onboarding.dto';
import { UserPreferencesResponseDto, UserPreferencesUpdateDto } from 'src/dtos/user-preferences.dto';
import { CreateProfileImageResponseDto } from 'src/dtos/user-profile.dto';
import { UserAdminResponseDto, UserResponseDto, UserUpdateMeDto } from 'src/dtos/user.dto';
import { LoggingRepository } from 'src/repositories/logging.repository';
import { UserService } from 'src/services/user.service';
import { UUIDParamDto } from 'src/validation';
export declare class UserController {
    private service;
    private logger;
    constructor(service: UserService, logger: LoggingRepository);
    searchUsers(auth: AuthDto): Promise<UserResponseDto[]>;
    getMyUser(auth: AuthDto): Promise<UserAdminResponseDto>;
    updateMyUser(auth: AuthDto, dto: UserUpdateMeDto): Promise<UserAdminResponseDto>;
    getMyPreferences(auth: AuthDto): Promise<UserPreferencesResponseDto>;
    updateMyPreferences(auth: AuthDto, dto: UserPreferencesUpdateDto): Promise<UserPreferencesResponseDto>;
    getUserLicense(auth: AuthDto): Promise<LicenseResponseDto>;
    setUserLicense(auth: AuthDto, license: LicenseKeyDto): Promise<LicenseResponseDto>;
    deleteUserLicense(auth: AuthDto): Promise<void>;
    getUserOnboarding(auth: AuthDto): Promise<OnboardingResponseDto>;
    setUserOnboarding(auth: AuthDto, Onboarding: OnboardingDto): Promise<OnboardingResponseDto>;
    deleteUserOnboarding(auth: AuthDto): Promise<void>;
    getUser({ id }: UUIDParamDto): Promise<UserResponseDto>;
    createProfileImage(auth: AuthDto, fileInfo: Express.Multer.File): Promise<CreateProfileImageResponseDto>;
    deleteProfileImage(auth: AuthDto): Promise<void>;
    getProfileImage(res: Response, next: NextFunction, { id }: UUIDParamDto): Promise<void>;
}
