"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AssetEditsDto = exports.AssetEditActionListDto = exports.AssetEditActionMirror = exports.AssetEditActionRotate = exports.AssetEditActionCrop = exports.MirrorParameters = exports.RotateParameters = exports.CropParameters = exports.MirrorAxis = exports.AssetEditAction = void 0;
const openapi = require("@nestjs/swagger");
const swagger_1 = require("@nestjs/swagger");
const class_transformer_1 = require("class-transformer");
const class_validator_1 = require("class-validator");
const validation_1 = require("../validation");
var AssetEditAction;
(function (AssetEditAction) {
    AssetEditAction["Crop"] = "crop";
    AssetEditAction["Rotate"] = "rotate";
    AssetEditAction["Mirror"] = "mirror";
})(AssetEditAction || (exports.AssetEditAction = AssetEditAction = {}));
var MirrorAxis;
(function (MirrorAxis) {
    MirrorAxis["Horizontal"] = "horizontal";
    MirrorAxis["Vertical"] = "vertical";
})(MirrorAxis || (exports.MirrorAxis = MirrorAxis = {}));
class CropParameters {
    x;
    y;
    width;
    height;
    static _OPENAPI_METADATA_FACTORY() {
        return { x: { required: true, type: () => Number, minimum: 0 }, y: { required: true, type: () => Number, minimum: 0 }, width: { required: true, type: () => Number, minimum: 1 }, height: { required: true, type: () => Number, minimum: 1 } };
    }
}
exports.CropParameters = CropParameters;
__decorate([
    (0, class_validator_1.IsInt)(),
    (0, class_validator_1.Min)(0),
    (0, swagger_1.ApiProperty)({ description: 'Top-Left X coordinate of crop' }),
    __metadata("design:type", Number)
], CropParameters.prototype, "x", void 0);
__decorate([
    (0, class_validator_1.IsInt)(),
    (0, class_validator_1.Min)(0),
    (0, swagger_1.ApiProperty)({ description: 'Top-Left Y coordinate of crop' }),
    __metadata("design:type", Number)
], CropParameters.prototype, "y", void 0);
__decorate([
    (0, class_validator_1.IsInt)(),
    (0, class_validator_1.Min)(1),
    (0, swagger_1.ApiProperty)({ description: 'Width of the crop' }),
    __metadata("design:type", Number)
], CropParameters.prototype, "width", void 0);
__decorate([
    (0, class_validator_1.IsInt)(),
    (0, class_validator_1.Min)(1),
    (0, swagger_1.ApiProperty)({ description: 'Height of the crop' }),
    __metadata("design:type", Number)
], CropParameters.prototype, "height", void 0);
class RotateParameters {
    angle;
    static _OPENAPI_METADATA_FACTORY() {
        return { angle: { required: true, type: () => Number } };
    }
}
exports.RotateParameters = RotateParameters;
__decorate([
    (0, validation_1.IsAxisAlignedRotation)(),
    (0, swagger_1.ApiProperty)({ description: 'Rotation angle in degrees' }),
    __metadata("design:type", Number)
], RotateParameters.prototype, "angle", void 0);
class MirrorParameters {
    axis;
    static _OPENAPI_METADATA_FACTORY() {
        return { axis: { required: true, enum: require("./editing.dto").MirrorAxis } };
    }
}
exports.MirrorParameters = MirrorParameters;
__decorate([
    (0, class_validator_1.IsEnum)(MirrorAxis),
    (0, swagger_1.ApiProperty)({ enum: MirrorAxis, enumName: 'MirrorAxis', description: 'Axis to mirror along' }),
    __metadata("design:type", String)
], MirrorParameters.prototype, "axis", void 0);
class AssetEditActionBase {
    action;
    static _OPENAPI_METADATA_FACTORY() {
        return { action: { required: true, enum: require("./editing.dto").AssetEditAction } };
    }
}
__decorate([
    (0, class_validator_1.IsEnum)(AssetEditAction),
    (0, swagger_1.ApiProperty)({ enum: AssetEditAction, enumName: 'AssetEditAction' }),
    __metadata("design:type", String)
], AssetEditActionBase.prototype, "action", void 0);
class AssetEditActionCrop extends AssetEditActionBase {
    parameters;
    static _OPENAPI_METADATA_FACTORY() {
        return { parameters: { required: true, type: () => require("./editing.dto").CropParameters } };
    }
}
exports.AssetEditActionCrop = AssetEditActionCrop;
__decorate([
    (0, class_validator_1.ValidateNested)(),
    (0, class_transformer_1.Type)(() => CropParameters),
    (0, swagger_1.ApiProperty)({ type: CropParameters }),
    __metadata("design:type", CropParameters)
], AssetEditActionCrop.prototype, "parameters", void 0);
class AssetEditActionRotate extends AssetEditActionBase {
    parameters;
    static _OPENAPI_METADATA_FACTORY() {
        return { parameters: { required: true, type: () => require("./editing.dto").RotateParameters } };
    }
}
exports.AssetEditActionRotate = AssetEditActionRotate;
__decorate([
    (0, class_validator_1.ValidateNested)(),
    (0, class_transformer_1.Type)(() => RotateParameters),
    (0, swagger_1.ApiProperty)({ type: RotateParameters }),
    __metadata("design:type", RotateParameters)
], AssetEditActionRotate.prototype, "parameters", void 0);
class AssetEditActionMirror extends AssetEditActionBase {
    parameters;
    static _OPENAPI_METADATA_FACTORY() {
        return { parameters: { required: true, type: () => require("./editing.dto").MirrorParameters } };
    }
}
exports.AssetEditActionMirror = AssetEditActionMirror;
__decorate([
    (0, class_validator_1.ValidateNested)(),
    (0, class_transformer_1.Type)(() => MirrorParameters),
    (0, swagger_1.ApiProperty)({ type: MirrorParameters }),
    __metadata("design:type", MirrorParameters)
], AssetEditActionMirror.prototype, "parameters", void 0);
const actionToClass = {
    [AssetEditAction.Crop]: AssetEditActionCrop,
    [AssetEditAction.Rotate]: AssetEditActionRotate,
    [AssetEditAction.Mirror]: AssetEditActionMirror,
};
const getActionClass = (item) => actionToClass[item.action];
let AssetEditActionListDto = class AssetEditActionListDto {
    edits;
    static _OPENAPI_METADATA_FACTORY() {
        return { edits: { required: true, type: () => [Object], description: "list of edits", minItems: 1 } };
    }
};
exports.AssetEditActionListDto = AssetEditActionListDto;
__decorate([
    (0, class_validator_1.ArrayMinSize)(1),
    (0, validation_1.IsUniqueEditActions)(),
    (0, class_validator_1.ValidateNested)({ each: true }),
    (0, class_transformer_1.Transform)(({ value: edits }) => Array.isArray(edits) ? edits.map((item) => (0, class_transformer_1.plainToInstance)(getActionClass(item), item)) : edits),
    (0, swagger_1.ApiProperty)({ anyOf: Object.values(actionToClass).map((target) => ({ $ref: (0, swagger_1.getSchemaPath)(target) })) }),
    __metadata("design:type", Array)
], AssetEditActionListDto.prototype, "edits", void 0);
exports.AssetEditActionListDto = AssetEditActionListDto = __decorate([
    (0, swagger_1.ApiExtraModels)(AssetEditActionRotate, AssetEditActionMirror, AssetEditActionCrop)
], AssetEditActionListDto);
class AssetEditsDto extends AssetEditActionListDto {
    assetId;
    static _OPENAPI_METADATA_FACTORY() {
        return { assetId: { required: true, type: () => String } };
    }
}
exports.AssetEditsDto = AssetEditsDto;
__decorate([
    (0, validation_1.ValidateUUID)(),
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", String)
], AssetEditsDto.prototype, "assetId", void 0);
//# sourceMappingURL=editing.dto.js.map