import { QueueResponseDto, QueueStatisticsDto } from 'src/dtos/queue.dto';
import { QueueName } from 'src/enum';
export declare class QueueStatusLegacyDto {
    isActive: boolean;
    isPaused: boolean;
}
export declare class QueueResponseLegacyDto {
    queueStatus: QueueStatusLegacyDto;
    jobCounts: QueueStatisticsDto;
}
export declare class QueuesResponseLegacyDto implements Record<QueueName, QueueResponseLegacyDto> {
    [QueueName.ThumbnailGeneration]: QueueResponseLegacyDto;
    [QueueName.MetadataExtraction]: QueueResponseLegacyDto;
    [QueueName.VideoConversion]: QueueResponseLegacyDto;
    [QueueName.SmartSearch]: QueueResponseLegacyDto;
    [QueueName.StorageTemplateMigration]: QueueResponseLegacyDto;
    [QueueName.Migration]: QueueResponseLegacyDto;
    [QueueName.BackgroundTask]: QueueResponseLegacyDto;
    [QueueName.Search]: QueueResponseLegacyDto;
    [QueueName.DuplicateDetection]: QueueResponseLegacyDto;
    [QueueName.FaceDetection]: QueueResponseLegacyDto;
    [QueueName.FacialRecognition]: QueueResponseLegacyDto;
    [QueueName.Sidecar]: QueueResponseLegacyDto;
    [QueueName.Library]: QueueResponseLegacyDto;
    [QueueName.Notification]: QueueResponseLegacyDto;
    [QueueName.BackupDatabase]: QueueResponseLegacyDto;
    [QueueName.Ocr]: QueueResponseLegacyDto;
    [QueueName.Workflow]: QueueResponseLegacyDto;
    [QueueName.Editor]: QueueResponseLegacyDto;
}
export declare const mapQueueLegacy: (response: QueueResponseDto) => QueueResponseLegacyDto;
export declare const mapQueuesLegacy: (responses: QueueResponseDto[]) => QueuesResponseLegacyDto;
