"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SyncAckDeleteDto = exports.SyncAckSetDto = exports.SyncAckDto = exports.SyncStreamDto = exports.SyncCompleteV1 = exports.SyncResetV1 = exports.SyncAckV1 = exports.SyncUserMetadataDeleteV1 = exports.SyncUserMetadataV1 = exports.SyncAssetFaceDeleteV1 = exports.SyncAssetFaceV1 = exports.SyncPersonDeleteV1 = exports.SyncPersonV1 = exports.SyncStackDeleteV1 = exports.SyncStackV1 = exports.SyncMemoryAssetDeleteV1 = exports.SyncMemoryAssetV1 = exports.SyncMemoryDeleteV1 = exports.SyncMemoryV1 = exports.SyncAlbumToAssetDeleteV1 = exports.SyncAlbumToAssetV1 = exports.SyncAlbumV1 = exports.SyncAlbumUserV1 = exports.SyncAlbumUserDeleteV1 = exports.SyncAlbumDeleteV1 = exports.SyncAssetMetadataDeleteV1 = exports.SyncAssetMetadataV1 = exports.SyncAssetExifV1 = exports.SyncAssetDeleteV1 = exports.SyncAssetV1 = exports.SyncPartnerDeleteV1 = exports.SyncPartnerV1 = exports.SyncUserDeleteV1 = exports.SyncAuthUserV1 = exports.SyncUserV1 = exports.ExtraModel = exports.extraSyncModels = exports.AssetDeltaSyncResponseDto = exports.AssetDeltaSyncDto = exports.AssetFullSyncDto = void 0;
const openapi = require("@nestjs/swagger");
const swagger_1 = require("@nestjs/swagger");
const class_validator_1 = require("class-validator");
const enum_1 = require("../enum");
const validation_1 = require("../validation");
class AssetFullSyncDto {
    lastId;
    updatedUntil;
    limit;
    userId;
    static _OPENAPI_METADATA_FACTORY() {
        return { lastId: { required: false, type: () => String }, updatedUntil: { required: true, type: () => Date }, limit: { required: true, type: () => Number, minimum: 1 }, userId: { required: false, type: () => String } };
    }
}
exports.AssetFullSyncDto = AssetFullSyncDto;
__decorate([
    (0, validation_1.ValidateUUID)({ optional: true }),
    __metadata("design:type", String)
], AssetFullSyncDto.prototype, "lastId", void 0);
__decorate([
    (0, validation_1.ValidateDate)(),
    __metadata("design:type", Date)
], AssetFullSyncDto.prototype, "updatedUntil", void 0);
__decorate([
    (0, class_validator_1.IsInt)(),
    (0, class_validator_1.IsPositive)(),
    (0, swagger_1.ApiProperty)({ type: 'integer' }),
    __metadata("design:type", Number)
], AssetFullSyncDto.prototype, "limit", void 0);
__decorate([
    (0, validation_1.ValidateUUID)({ optional: true }),
    __metadata("design:type", String)
], AssetFullSyncDto.prototype, "userId", void 0);
class AssetDeltaSyncDto {
    updatedAfter;
    userIds;
    static _OPENAPI_METADATA_FACTORY() {
        return { updatedAfter: { required: true, type: () => Date }, userIds: { required: true, type: () => [String] } };
    }
}
exports.AssetDeltaSyncDto = AssetDeltaSyncDto;
__decorate([
    (0, validation_1.ValidateDate)(),
    __metadata("design:type", Date)
], AssetDeltaSyncDto.prototype, "updatedAfter", void 0);
__decorate([
    (0, validation_1.ValidateUUID)({ each: true }),
    __metadata("design:type", Array)
], AssetDeltaSyncDto.prototype, "userIds", void 0);
class AssetDeltaSyncResponseDto {
    needsFullSync;
    upserted;
    deleted;
    static _OPENAPI_METADATA_FACTORY() {
        return { needsFullSync: { required: true, type: () => Boolean }, upserted: { required: true, type: () => [require("./asset-response.dto").AssetResponseDto] }, deleted: { required: true, type: () => [String] } };
    }
}
exports.AssetDeltaSyncResponseDto = AssetDeltaSyncResponseDto;
exports.extraSyncModels = [];
const ExtraModel = () => {
    return (object) => {
        exports.extraSyncModels.push(object);
    };
};
exports.ExtraModel = ExtraModel;
let SyncUserV1 = class SyncUserV1 {
    id;
    name;
    email;
    avatarColor;
    deletedAt;
    hasProfileImage;
    profileChangedAt;
    static _OPENAPI_METADATA_FACTORY() {
        return { id: { required: true, type: () => String }, name: { required: true, type: () => String }, email: { required: true, type: () => String }, avatarColor: { required: true, nullable: true, enum: require("../enum").UserAvatarColor }, deletedAt: { required: true, type: () => Date, nullable: true }, hasProfileImage: { required: true, type: () => Boolean }, profileChangedAt: { required: true, type: () => Date } };
    }
};
exports.SyncUserV1 = SyncUserV1;
__decorate([
    (0, validation_1.ValidateEnum)({ enum: enum_1.UserAvatarColor, name: 'UserAvatarColor', nullable: true }),
    __metadata("design:type", Object)
], SyncUserV1.prototype, "avatarColor", void 0);
exports.SyncUserV1 = SyncUserV1 = __decorate([
    (0, exports.ExtraModel)()
], SyncUserV1);
let SyncAuthUserV1 = class SyncAuthUserV1 extends SyncUserV1 {
    isAdmin;
    pinCode;
    oauthId;
    storageLabel;
    quotaSizeInBytes;
    quotaUsageInBytes;
    static _OPENAPI_METADATA_FACTORY() {
        return { isAdmin: { required: true, type: () => Boolean }, pinCode: { required: true, type: () => String, nullable: true }, oauthId: { required: true, type: () => String }, storageLabel: { required: true, type: () => String, nullable: true }, quotaSizeInBytes: { required: true, type: () => Number, nullable: true }, quotaUsageInBytes: { required: true, type: () => Number } };
    }
};
exports.SyncAuthUserV1 = SyncAuthUserV1;
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer' }),
    __metadata("design:type", Object)
], SyncAuthUserV1.prototype, "quotaSizeInBytes", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer' }),
    __metadata("design:type", Number)
], SyncAuthUserV1.prototype, "quotaUsageInBytes", void 0);
exports.SyncAuthUserV1 = SyncAuthUserV1 = __decorate([
    (0, exports.ExtraModel)()
], SyncAuthUserV1);
let SyncUserDeleteV1 = class SyncUserDeleteV1 {
    userId;
    static _OPENAPI_METADATA_FACTORY() {
        return { userId: { required: true, type: () => String } };
    }
};
exports.SyncUserDeleteV1 = SyncUserDeleteV1;
exports.SyncUserDeleteV1 = SyncUserDeleteV1 = __decorate([
    (0, exports.ExtraModel)()
], SyncUserDeleteV1);
let SyncPartnerV1 = class SyncPartnerV1 {
    sharedById;
    sharedWithId;
    inTimeline;
    static _OPENAPI_METADATA_FACTORY() {
        return { sharedById: { required: true, type: () => String }, sharedWithId: { required: true, type: () => String }, inTimeline: { required: true, type: () => Boolean } };
    }
};
exports.SyncPartnerV1 = SyncPartnerV1;
exports.SyncPartnerV1 = SyncPartnerV1 = __decorate([
    (0, exports.ExtraModel)()
], SyncPartnerV1);
let SyncPartnerDeleteV1 = class SyncPartnerDeleteV1 {
    sharedById;
    sharedWithId;
    static _OPENAPI_METADATA_FACTORY() {
        return { sharedById: { required: true, type: () => String }, sharedWithId: { required: true, type: () => String } };
    }
};
exports.SyncPartnerDeleteV1 = SyncPartnerDeleteV1;
exports.SyncPartnerDeleteV1 = SyncPartnerDeleteV1 = __decorate([
    (0, exports.ExtraModel)()
], SyncPartnerDeleteV1);
let SyncAssetV1 = class SyncAssetV1 {
    id;
    ownerId;
    originalFileName;
    thumbhash;
    checksum;
    fileCreatedAt;
    fileModifiedAt;
    localDateTime;
    duration;
    type;
    deletedAt;
    isFavorite;
    visibility;
    livePhotoVideoId;
    stackId;
    libraryId;
    width;
    height;
    isEdited;
    static _OPENAPI_METADATA_FACTORY() {
        return { id: { required: true, type: () => String }, ownerId: { required: true, type: () => String }, originalFileName: { required: true, type: () => String }, thumbhash: { required: true, type: () => String, nullable: true }, checksum: { required: true, type: () => String }, fileCreatedAt: { required: true, type: () => Date, nullable: true }, fileModifiedAt: { required: true, type: () => Date, nullable: true }, localDateTime: { required: true, type: () => Date, nullable: true }, duration: { required: true, type: () => String, nullable: true }, type: { required: true, enum: require("../enum").AssetType }, deletedAt: { required: true, type: () => Date, nullable: true }, isFavorite: { required: true, type: () => Boolean }, visibility: { required: true, enum: require("../enum").AssetVisibility }, livePhotoVideoId: { required: true, type: () => String, nullable: true }, stackId: { required: true, type: () => String, nullable: true }, libraryId: { required: true, type: () => String, nullable: true }, width: { required: true, type: () => Number, nullable: true }, height: { required: true, type: () => Number, nullable: true }, isEdited: { required: true, type: () => Boolean } };
    }
};
exports.SyncAssetV1 = SyncAssetV1;
__decorate([
    (0, validation_1.ValidateEnum)({ enum: enum_1.AssetType, name: 'AssetTypeEnum' }),
    __metadata("design:type", String)
], SyncAssetV1.prototype, "type", void 0);
__decorate([
    (0, validation_1.ValidateEnum)({ enum: enum_1.AssetVisibility, name: 'AssetVisibility' }),
    __metadata("design:type", String)
], SyncAssetV1.prototype, "visibility", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer' }),
    __metadata("design:type", Object)
], SyncAssetV1.prototype, "width", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer' }),
    __metadata("design:type", Object)
], SyncAssetV1.prototype, "height", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'boolean' }),
    __metadata("design:type", Boolean)
], SyncAssetV1.prototype, "isEdited", void 0);
exports.SyncAssetV1 = SyncAssetV1 = __decorate([
    (0, exports.ExtraModel)()
], SyncAssetV1);
let SyncAssetDeleteV1 = class SyncAssetDeleteV1 {
    assetId;
    static _OPENAPI_METADATA_FACTORY() {
        return { assetId: { required: true, type: () => String } };
    }
};
exports.SyncAssetDeleteV1 = SyncAssetDeleteV1;
exports.SyncAssetDeleteV1 = SyncAssetDeleteV1 = __decorate([
    (0, exports.ExtraModel)()
], SyncAssetDeleteV1);
let SyncAssetExifV1 = class SyncAssetExifV1 {
    assetId;
    description;
    exifImageWidth;
    exifImageHeight;
    fileSizeInByte;
    orientation;
    dateTimeOriginal;
    modifyDate;
    timeZone;
    latitude;
    longitude;
    projectionType;
    city;
    state;
    country;
    make;
    model;
    lensModel;
    fNumber;
    focalLength;
    iso;
    exposureTime;
    profileDescription;
    rating;
    fps;
    static _OPENAPI_METADATA_FACTORY() {
        return { assetId: { required: true, type: () => String }, description: { required: true, type: () => String, nullable: true }, exifImageWidth: { required: true, type: () => Number, nullable: true }, exifImageHeight: { required: true, type: () => Number, nullable: true }, fileSizeInByte: { required: true, type: () => Number, nullable: true }, orientation: { required: true, type: () => String, nullable: true }, dateTimeOriginal: { required: true, type: () => Date, nullable: true }, modifyDate: { required: true, type: () => Date, nullable: true }, timeZone: { required: true, type: () => String, nullable: true }, latitude: { required: true, type: () => Number, nullable: true }, longitude: { required: true, type: () => Number, nullable: true }, projectionType: { required: true, type: () => String, nullable: true }, city: { required: true, type: () => String, nullable: true }, state: { required: true, type: () => String, nullable: true }, country: { required: true, type: () => String, nullable: true }, make: { required: true, type: () => String, nullable: true }, model: { required: true, type: () => String, nullable: true }, lensModel: { required: true, type: () => String, nullable: true }, fNumber: { required: true, type: () => Number, nullable: true }, focalLength: { required: true, type: () => Number, nullable: true }, iso: { required: true, type: () => Number, nullable: true }, exposureTime: { required: true, type: () => String, nullable: true }, profileDescription: { required: true, type: () => String, nullable: true }, rating: { required: true, type: () => Number, nullable: true }, fps: { required: true, type: () => Number, nullable: true } };
    }
};
exports.SyncAssetExifV1 = SyncAssetExifV1;
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer' }),
    __metadata("design:type", Object)
], SyncAssetExifV1.prototype, "exifImageWidth", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer' }),
    __metadata("design:type", Object)
], SyncAssetExifV1.prototype, "exifImageHeight", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer' }),
    __metadata("design:type", Object)
], SyncAssetExifV1.prototype, "fileSizeInByte", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'number', format: 'double' }),
    __metadata("design:type", Object)
], SyncAssetExifV1.prototype, "latitude", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'number', format: 'double' }),
    __metadata("design:type", Object)
], SyncAssetExifV1.prototype, "longitude", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'number', format: 'double' }),
    __metadata("design:type", Object)
], SyncAssetExifV1.prototype, "fNumber", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'number', format: 'double' }),
    __metadata("design:type", Object)
], SyncAssetExifV1.prototype, "focalLength", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer' }),
    __metadata("design:type", Object)
], SyncAssetExifV1.prototype, "iso", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer' }),
    __metadata("design:type", Object)
], SyncAssetExifV1.prototype, "rating", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'number', format: 'double' }),
    __metadata("design:type", Object)
], SyncAssetExifV1.prototype, "fps", void 0);
exports.SyncAssetExifV1 = SyncAssetExifV1 = __decorate([
    (0, exports.ExtraModel)()
], SyncAssetExifV1);
let SyncAssetMetadataV1 = class SyncAssetMetadataV1 {
    assetId;
    key;
    value;
    static _OPENAPI_METADATA_FACTORY() {
        return { assetId: { required: true, type: () => String }, key: { required: true, type: () => String }, value: { required: true, type: () => Object } };
    }
};
exports.SyncAssetMetadataV1 = SyncAssetMetadataV1;
exports.SyncAssetMetadataV1 = SyncAssetMetadataV1 = __decorate([
    (0, exports.ExtraModel)()
], SyncAssetMetadataV1);
let SyncAssetMetadataDeleteV1 = class SyncAssetMetadataDeleteV1 {
    assetId;
    key;
    static _OPENAPI_METADATA_FACTORY() {
        return { assetId: { required: true, type: () => String }, key: { required: true, type: () => String } };
    }
};
exports.SyncAssetMetadataDeleteV1 = SyncAssetMetadataDeleteV1;
exports.SyncAssetMetadataDeleteV1 = SyncAssetMetadataDeleteV1 = __decorate([
    (0, exports.ExtraModel)()
], SyncAssetMetadataDeleteV1);
let SyncAlbumDeleteV1 = class SyncAlbumDeleteV1 {
    albumId;
    static _OPENAPI_METADATA_FACTORY() {
        return { albumId: { required: true, type: () => String } };
    }
};
exports.SyncAlbumDeleteV1 = SyncAlbumDeleteV1;
exports.SyncAlbumDeleteV1 = SyncAlbumDeleteV1 = __decorate([
    (0, exports.ExtraModel)()
], SyncAlbumDeleteV1);
let SyncAlbumUserDeleteV1 = class SyncAlbumUserDeleteV1 {
    albumId;
    userId;
    static _OPENAPI_METADATA_FACTORY() {
        return { albumId: { required: true, type: () => String }, userId: { required: true, type: () => String } };
    }
};
exports.SyncAlbumUserDeleteV1 = SyncAlbumUserDeleteV1;
exports.SyncAlbumUserDeleteV1 = SyncAlbumUserDeleteV1 = __decorate([
    (0, exports.ExtraModel)()
], SyncAlbumUserDeleteV1);
let SyncAlbumUserV1 = class SyncAlbumUserV1 {
    albumId;
    userId;
    role;
    static _OPENAPI_METADATA_FACTORY() {
        return { albumId: { required: true, type: () => String }, userId: { required: true, type: () => String }, role: { required: true, enum: require("../enum").AlbumUserRole } };
    }
};
exports.SyncAlbumUserV1 = SyncAlbumUserV1;
__decorate([
    (0, validation_1.ValidateEnum)({ enum: enum_1.AlbumUserRole, name: 'AlbumUserRole' }),
    __metadata("design:type", String)
], SyncAlbumUserV1.prototype, "role", void 0);
exports.SyncAlbumUserV1 = SyncAlbumUserV1 = __decorate([
    (0, exports.ExtraModel)()
], SyncAlbumUserV1);
let SyncAlbumV1 = class SyncAlbumV1 {
    id;
    ownerId;
    name;
    description;
    createdAt;
    updatedAt;
    thumbnailAssetId;
    isActivityEnabled;
    order;
    static _OPENAPI_METADATA_FACTORY() {
        return { id: { required: true, type: () => String }, ownerId: { required: true, type: () => String }, name: { required: true, type: () => String }, description: { required: true, type: () => String }, createdAt: { required: true, type: () => Date }, updatedAt: { required: true, type: () => Date }, thumbnailAssetId: { required: true, type: () => String, nullable: true }, isActivityEnabled: { required: true, type: () => Boolean }, order: { required: true, enum: require("../enum").AssetOrder } };
    }
};
exports.SyncAlbumV1 = SyncAlbumV1;
__decorate([
    (0, validation_1.ValidateEnum)({ enum: enum_1.AssetOrder, name: 'AssetOrder' }),
    __metadata("design:type", String)
], SyncAlbumV1.prototype, "order", void 0);
exports.SyncAlbumV1 = SyncAlbumV1 = __decorate([
    (0, exports.ExtraModel)()
], SyncAlbumV1);
let SyncAlbumToAssetV1 = class SyncAlbumToAssetV1 {
    albumId;
    assetId;
    static _OPENAPI_METADATA_FACTORY() {
        return { albumId: { required: true, type: () => String }, assetId: { required: true, type: () => String } };
    }
};
exports.SyncAlbumToAssetV1 = SyncAlbumToAssetV1;
exports.SyncAlbumToAssetV1 = SyncAlbumToAssetV1 = __decorate([
    (0, exports.ExtraModel)()
], SyncAlbumToAssetV1);
let SyncAlbumToAssetDeleteV1 = class SyncAlbumToAssetDeleteV1 {
    albumId;
    assetId;
    static _OPENAPI_METADATA_FACTORY() {
        return { albumId: { required: true, type: () => String }, assetId: { required: true, type: () => String } };
    }
};
exports.SyncAlbumToAssetDeleteV1 = SyncAlbumToAssetDeleteV1;
exports.SyncAlbumToAssetDeleteV1 = SyncAlbumToAssetDeleteV1 = __decorate([
    (0, exports.ExtraModel)()
], SyncAlbumToAssetDeleteV1);
let SyncMemoryV1 = class SyncMemoryV1 {
    id;
    createdAt;
    updatedAt;
    deletedAt;
    ownerId;
    type;
    data;
    isSaved;
    memoryAt;
    seenAt;
    showAt;
    hideAt;
    static _OPENAPI_METADATA_FACTORY() {
        return { id: { required: true, type: () => String }, createdAt: { required: true, type: () => Date }, updatedAt: { required: true, type: () => Date }, deletedAt: { required: true, type: () => Date, nullable: true }, ownerId: { required: true, type: () => String }, type: { required: true, type: () => String, enum: require("../enum").MemoryType }, data: { required: true, type: () => Object }, isSaved: { required: true, type: () => Boolean }, memoryAt: { required: true, type: () => Date }, seenAt: { required: true, type: () => Date, nullable: true }, showAt: { required: true, type: () => Date, nullable: true }, hideAt: { required: true, type: () => Date, nullable: true } };
    }
};
exports.SyncMemoryV1 = SyncMemoryV1;
__decorate([
    (0, validation_1.ValidateEnum)({ enum: enum_1.MemoryType, name: 'MemoryType' }),
    __metadata("design:type", String)
], SyncMemoryV1.prototype, "type", void 0);
exports.SyncMemoryV1 = SyncMemoryV1 = __decorate([
    (0, exports.ExtraModel)()
], SyncMemoryV1);
let SyncMemoryDeleteV1 = class SyncMemoryDeleteV1 {
    memoryId;
    static _OPENAPI_METADATA_FACTORY() {
        return { memoryId: { required: true, type: () => String } };
    }
};
exports.SyncMemoryDeleteV1 = SyncMemoryDeleteV1;
exports.SyncMemoryDeleteV1 = SyncMemoryDeleteV1 = __decorate([
    (0, exports.ExtraModel)()
], SyncMemoryDeleteV1);
let SyncMemoryAssetV1 = class SyncMemoryAssetV1 {
    memoryId;
    assetId;
    static _OPENAPI_METADATA_FACTORY() {
        return { memoryId: { required: true, type: () => String }, assetId: { required: true, type: () => String } };
    }
};
exports.SyncMemoryAssetV1 = SyncMemoryAssetV1;
exports.SyncMemoryAssetV1 = SyncMemoryAssetV1 = __decorate([
    (0, exports.ExtraModel)()
], SyncMemoryAssetV1);
let SyncMemoryAssetDeleteV1 = class SyncMemoryAssetDeleteV1 {
    memoryId;
    assetId;
    static _OPENAPI_METADATA_FACTORY() {
        return { memoryId: { required: true, type: () => String }, assetId: { required: true, type: () => String } };
    }
};
exports.SyncMemoryAssetDeleteV1 = SyncMemoryAssetDeleteV1;
exports.SyncMemoryAssetDeleteV1 = SyncMemoryAssetDeleteV1 = __decorate([
    (0, exports.ExtraModel)()
], SyncMemoryAssetDeleteV1);
let SyncStackV1 = class SyncStackV1 {
    id;
    createdAt;
    updatedAt;
    primaryAssetId;
    ownerId;
    static _OPENAPI_METADATA_FACTORY() {
        return { id: { required: true, type: () => String }, createdAt: { required: true, type: () => Date }, updatedAt: { required: true, type: () => Date }, primaryAssetId: { required: true, type: () => String }, ownerId: { required: true, type: () => String } };
    }
};
exports.SyncStackV1 = SyncStackV1;
exports.SyncStackV1 = SyncStackV1 = __decorate([
    (0, exports.ExtraModel)()
], SyncStackV1);
let SyncStackDeleteV1 = class SyncStackDeleteV1 {
    stackId;
    static _OPENAPI_METADATA_FACTORY() {
        return { stackId: { required: true, type: () => String } };
    }
};
exports.SyncStackDeleteV1 = SyncStackDeleteV1;
exports.SyncStackDeleteV1 = SyncStackDeleteV1 = __decorate([
    (0, exports.ExtraModel)()
], SyncStackDeleteV1);
let SyncPersonV1 = class SyncPersonV1 {
    id;
    createdAt;
    updatedAt;
    ownerId;
    name;
    birthDate;
    isHidden;
    isFavorite;
    color;
    faceAssetId;
    static _OPENAPI_METADATA_FACTORY() {
        return { id: { required: true, type: () => String }, createdAt: { required: true, type: () => Date }, updatedAt: { required: true, type: () => Date }, ownerId: { required: true, type: () => String }, name: { required: true, type: () => String }, birthDate: { required: true, type: () => Date, nullable: true }, isHidden: { required: true, type: () => Boolean }, isFavorite: { required: true, type: () => Boolean }, color: { required: true, type: () => String, nullable: true }, faceAssetId: { required: true, type: () => String, nullable: true } };
    }
};
exports.SyncPersonV1 = SyncPersonV1;
exports.SyncPersonV1 = SyncPersonV1 = __decorate([
    (0, exports.ExtraModel)()
], SyncPersonV1);
let SyncPersonDeleteV1 = class SyncPersonDeleteV1 {
    personId;
    static _OPENAPI_METADATA_FACTORY() {
        return { personId: { required: true, type: () => String } };
    }
};
exports.SyncPersonDeleteV1 = SyncPersonDeleteV1;
exports.SyncPersonDeleteV1 = SyncPersonDeleteV1 = __decorate([
    (0, exports.ExtraModel)()
], SyncPersonDeleteV1);
let SyncAssetFaceV1 = class SyncAssetFaceV1 {
    id;
    assetId;
    personId;
    imageWidth;
    imageHeight;
    boundingBoxX1;
    boundingBoxY1;
    boundingBoxX2;
    boundingBoxY2;
    sourceType;
    static _OPENAPI_METADATA_FACTORY() {
        return { id: { required: true, type: () => String }, assetId: { required: true, type: () => String }, personId: { required: true, type: () => String, nullable: true }, imageWidth: { required: true, type: () => Number }, imageHeight: { required: true, type: () => Number }, boundingBoxX1: { required: true, type: () => Number }, boundingBoxY1: { required: true, type: () => Number }, boundingBoxX2: { required: true, type: () => Number }, boundingBoxY2: { required: true, type: () => Number }, sourceType: { required: true, type: () => String } };
    }
};
exports.SyncAssetFaceV1 = SyncAssetFaceV1;
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer' }),
    __metadata("design:type", Number)
], SyncAssetFaceV1.prototype, "imageWidth", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer' }),
    __metadata("design:type", Number)
], SyncAssetFaceV1.prototype, "imageHeight", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer' }),
    __metadata("design:type", Number)
], SyncAssetFaceV1.prototype, "boundingBoxX1", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer' }),
    __metadata("design:type", Number)
], SyncAssetFaceV1.prototype, "boundingBoxY1", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer' }),
    __metadata("design:type", Number)
], SyncAssetFaceV1.prototype, "boundingBoxX2", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer' }),
    __metadata("design:type", Number)
], SyncAssetFaceV1.prototype, "boundingBoxY2", void 0);
exports.SyncAssetFaceV1 = SyncAssetFaceV1 = __decorate([
    (0, exports.ExtraModel)()
], SyncAssetFaceV1);
let SyncAssetFaceDeleteV1 = class SyncAssetFaceDeleteV1 {
    assetFaceId;
    static _OPENAPI_METADATA_FACTORY() {
        return { assetFaceId: { required: true, type: () => String } };
    }
};
exports.SyncAssetFaceDeleteV1 = SyncAssetFaceDeleteV1;
exports.SyncAssetFaceDeleteV1 = SyncAssetFaceDeleteV1 = __decorate([
    (0, exports.ExtraModel)()
], SyncAssetFaceDeleteV1);
let SyncUserMetadataV1 = class SyncUserMetadataV1 {
    userId;
    key;
    value;
    static _OPENAPI_METADATA_FACTORY() {
        return { userId: { required: true, type: () => String }, key: { required: true, enum: require("../enum").UserMetadataKey }, value: { required: true, type: () => Object } };
    }
};
exports.SyncUserMetadataV1 = SyncUserMetadataV1;
__decorate([
    (0, validation_1.ValidateEnum)({ enum: enum_1.UserMetadataKey, name: 'UserMetadataKey' }),
    __metadata("design:type", String)
], SyncUserMetadataV1.prototype, "key", void 0);
exports.SyncUserMetadataV1 = SyncUserMetadataV1 = __decorate([
    (0, exports.ExtraModel)()
], SyncUserMetadataV1);
let SyncUserMetadataDeleteV1 = class SyncUserMetadataDeleteV1 {
    userId;
    key;
    static _OPENAPI_METADATA_FACTORY() {
        return { userId: { required: true, type: () => String }, key: { required: true, enum: require("../enum").UserMetadataKey } };
    }
};
exports.SyncUserMetadataDeleteV1 = SyncUserMetadataDeleteV1;
__decorate([
    (0, validation_1.ValidateEnum)({ enum: enum_1.UserMetadataKey, name: 'UserMetadataKey' }),
    __metadata("design:type", String)
], SyncUserMetadataDeleteV1.prototype, "key", void 0);
exports.SyncUserMetadataDeleteV1 = SyncUserMetadataDeleteV1 = __decorate([
    (0, exports.ExtraModel)()
], SyncUserMetadataDeleteV1);
let SyncAckV1 = class SyncAckV1 {
    static _OPENAPI_METADATA_FACTORY() {
        return {};
    }
};
exports.SyncAckV1 = SyncAckV1;
exports.SyncAckV1 = SyncAckV1 = __decorate([
    (0, exports.ExtraModel)()
], SyncAckV1);
let SyncResetV1 = class SyncResetV1 {
    static _OPENAPI_METADATA_FACTORY() {
        return {};
    }
};
exports.SyncResetV1 = SyncResetV1;
exports.SyncResetV1 = SyncResetV1 = __decorate([
    (0, exports.ExtraModel)()
], SyncResetV1);
let SyncCompleteV1 = class SyncCompleteV1 {
    static _OPENAPI_METADATA_FACTORY() {
        return {};
    }
};
exports.SyncCompleteV1 = SyncCompleteV1;
exports.SyncCompleteV1 = SyncCompleteV1 = __decorate([
    (0, exports.ExtraModel)()
], SyncCompleteV1);
class SyncStreamDto {
    types;
    reset;
    static _OPENAPI_METADATA_FACTORY() {
        return { types: { required: true, enum: require("../enum").SyncRequestType, isArray: true }, reset: { required: false, type: () => Boolean } };
    }
}
exports.SyncStreamDto = SyncStreamDto;
__decorate([
    (0, validation_1.ValidateEnum)({ enum: enum_1.SyncRequestType, name: 'SyncRequestType', each: true }),
    __metadata("design:type", Array)
], SyncStreamDto.prototype, "types", void 0);
__decorate([
    (0, validation_1.ValidateBoolean)({ optional: true }),
    __metadata("design:type", Boolean)
], SyncStreamDto.prototype, "reset", void 0);
class SyncAckDto {
    type;
    ack;
    static _OPENAPI_METADATA_FACTORY() {
        return { type: { required: true, enum: require("../enum").SyncEntityType }, ack: { required: true, type: () => String } };
    }
}
exports.SyncAckDto = SyncAckDto;
__decorate([
    (0, validation_1.ValidateEnum)({ enum: enum_1.SyncEntityType, name: 'SyncEntityType' }),
    __metadata("design:type", String)
], SyncAckDto.prototype, "type", void 0);
class SyncAckSetDto {
    acks;
    static _OPENAPI_METADATA_FACTORY() {
        return { acks: { required: true, type: () => [String], maxItems: 1000 } };
    }
}
exports.SyncAckSetDto = SyncAckSetDto;
__decorate([
    (0, class_validator_1.ArrayMaxSize)(1000),
    (0, class_validator_1.IsString)({ each: true }),
    __metadata("design:type", Array)
], SyncAckSetDto.prototype, "acks", void 0);
class SyncAckDeleteDto {
    types;
    static _OPENAPI_METADATA_FACTORY() {
        return { types: { required: false, enum: require("../enum").SyncEntityType, isArray: true } };
    }
}
exports.SyncAckDeleteDto = SyncAckDeleteDto;
__decorate([
    (0, validation_1.ValidateEnum)({ enum: enum_1.SyncEntityType, name: 'SyncEntityType', optional: true, each: true }),
    __metadata("design:type", Array)
], SyncAckDeleteDto.prototype, "types", void 0);
//# sourceMappingURL=sync.dto.js.map