export declare enum AuthType {
    Password = "password",
    OAuth = "oauth"
}
export declare enum ImmichCookie {
    AccessToken = "immich_access_token",
    MaintenanceToken = "immich_maintenance_token",
    AuthType = "immich_auth_type",
    IsAuthenticated = "immich_is_authenticated",
    SharedLinkToken = "immich_shared_link_token",
    OAuthState = "immich_oauth_state",
    OAuthCodeVerifier = "immich_oauth_code_verifier"
}
export declare enum ImmichHeader {
    ApiKey = "x-api-key",
    UserToken = "x-immich-user-token",
    SessionToken = "x-immich-session-token",
    SharedLinkKey = "x-immich-share-key",
    SharedLinkSlug = "x-immich-share-slug",
    Checksum = "x-immich-checksum",
    Cid = "x-immich-cid"
}
export declare enum ImmichQuery {
    SharedLinkKey = "key",
    SharedLinkSlug = "slug",
    ApiKey = "apiKey",
    SessionKey = "sessionKey"
}
export declare enum AssetType {
    Image = "IMAGE",
    Video = "VIDEO",
    Audio = "AUDIO",
    Other = "OTHER"
}
export declare enum AssetFileType {
    FullSize = "fullsize",
    Preview = "preview",
    Thumbnail = "thumbnail",
    Sidecar = "sidecar"
}
export declare enum AlbumUserRole {
    Editor = "editor",
    Viewer = "viewer"
}
export declare enum AssetOrder {
    Asc = "asc",
    Desc = "desc"
}
export declare enum DatabaseAction {
    Create = "CREATE",
    Update = "UPDATE",
    Delete = "DELETE"
}
export declare enum EntityType {
    Asset = "ASSET",
    Album = "ALBUM"
}
export declare enum MemoryType {
    OnThisDay = "on_this_day"
}
export declare enum AssetOrderWithRandom {
    Asc = "asc",
    Desc = "desc",
    Random = "random"
}
export declare enum Permission {
    All = "all",
    ActivityCreate = "activity.create",
    ActivityRead = "activity.read",
    ActivityUpdate = "activity.update",
    ActivityDelete = "activity.delete",
    ActivityStatistics = "activity.statistics",
    ApiKeyCreate = "apiKey.create",
    ApiKeyRead = "apiKey.read",
    ApiKeyUpdate = "apiKey.update",
    ApiKeyDelete = "apiKey.delete",
    AssetRead = "asset.read",
    AssetUpdate = "asset.update",
    AssetDelete = "asset.delete",
    AssetStatistics = "asset.statistics",
    AssetShare = "asset.share",
    AssetView = "asset.view",
    AssetDownload = "asset.download",
    AssetUpload = "asset.upload",
    AssetReplace = "asset.replace",
    AssetCopy = "asset.copy",
    AssetDerive = "asset.derive",
    AssetEditGet = "asset.edit.get",
    AssetEditCreate = "asset.edit.create",
    AssetEditDelete = "asset.edit.delete",
    AlbumCreate = "album.create",
    AlbumRead = "album.read",
    AlbumUpdate = "album.update",
    AlbumDelete = "album.delete",
    AlbumStatistics = "album.statistics",
    AlbumShare = "album.share",
    AlbumDownload = "album.download",
    AlbumAssetCreate = "albumAsset.create",
    AlbumAssetDelete = "albumAsset.delete",
    AlbumUserCreate = "albumUser.create",
    AlbumUserUpdate = "albumUser.update",
    AlbumUserDelete = "albumUser.delete",
    AuthChangePassword = "auth.changePassword",
    AuthDeviceDelete = "authDevice.delete",
    ArchiveRead = "archive.read",
    BackupList = "backup.list",
    BackupDownload = "backup.download",
    BackupUpload = "backup.upload",
    BackupDelete = "backup.delete",
    DuplicateRead = "duplicate.read",
    DuplicateDelete = "duplicate.delete",
    FaceCreate = "face.create",
    FaceRead = "face.read",
    FaceUpdate = "face.update",
    FaceDelete = "face.delete",
    FolderRead = "folder.read",
    JobCreate = "job.create",
    JobRead = "job.read",
    LibraryCreate = "library.create",
    LibraryRead = "library.read",
    LibraryUpdate = "library.update",
    LibraryDelete = "library.delete",
    LibraryStatistics = "library.statistics",
    TimelineRead = "timeline.read",
    TimelineDownload = "timeline.download",
    Maintenance = "maintenance",
    MapRead = "map.read",
    MapSearch = "map.search",
    MemoryCreate = "memory.create",
    MemoryRead = "memory.read",
    MemoryUpdate = "memory.update",
    MemoryDelete = "memory.delete",
    MemoryStatistics = "memory.statistics",
    MemoryAssetCreate = "memoryAsset.create",
    MemoryAssetDelete = "memoryAsset.delete",
    NotificationCreate = "notification.create",
    NotificationRead = "notification.read",
    NotificationUpdate = "notification.update",
    NotificationDelete = "notification.delete",
    PartnerCreate = "partner.create",
    PartnerRead = "partner.read",
    PartnerUpdate = "partner.update",
    PartnerDelete = "partner.delete",
    PersonCreate = "person.create",
    PersonRead = "person.read",
    PersonUpdate = "person.update",
    PersonDelete = "person.delete",
    PersonStatistics = "person.statistics",
    PersonMerge = "person.merge",
    PersonReassign = "person.reassign",
    PinCodeCreate = "pinCode.create",
    PinCodeUpdate = "pinCode.update",
    PinCodeDelete = "pinCode.delete",
    PluginCreate = "plugin.create",
    PluginRead = "plugin.read",
    PluginUpdate = "plugin.update",
    PluginDelete = "plugin.delete",
    ServerAbout = "server.about",
    ServerApkLinks = "server.apkLinks",
    ServerStorage = "server.storage",
    ServerStatistics = "server.statistics",
    ServerVersionCheck = "server.versionCheck",
    ServerLicenseRead = "serverLicense.read",
    ServerLicenseUpdate = "serverLicense.update",
    ServerLicenseDelete = "serverLicense.delete",
    SessionCreate = "session.create",
    SessionRead = "session.read",
    SessionUpdate = "session.update",
    SessionDelete = "session.delete",
    SessionLock = "session.lock",
    SharedLinkCreate = "sharedLink.create",
    SharedLinkRead = "sharedLink.read",
    SharedLinkUpdate = "sharedLink.update",
    SharedLinkDelete = "sharedLink.delete",
    StackCreate = "stack.create",
    StackRead = "stack.read",
    StackUpdate = "stack.update",
    StackDelete = "stack.delete",
    SyncStream = "sync.stream",
    SyncCheckpointRead = "syncCheckpoint.read",
    SyncCheckpointUpdate = "syncCheckpoint.update",
    SyncCheckpointDelete = "syncCheckpoint.delete",
    SystemConfigRead = "systemConfig.read",
    SystemConfigUpdate = "systemConfig.update",
    SystemMetadataRead = "systemMetadata.read",
    SystemMetadataUpdate = "systemMetadata.update",
    TagCreate = "tag.create",
    TagRead = "tag.read",
    TagUpdate = "tag.update",
    TagDelete = "tag.delete",
    TagAsset = "tag.asset",
    UserRead = "user.read",
    UserUpdate = "user.update",
    UserLicenseCreate = "userLicense.create",
    UserLicenseRead = "userLicense.read",
    UserLicenseUpdate = "userLicense.update",
    UserLicenseDelete = "userLicense.delete",
    UserOnboardingRead = "userOnboarding.read",
    UserOnboardingUpdate = "userOnboarding.update",
    UserOnboardingDelete = "userOnboarding.delete",
    UserPreferenceRead = "userPreference.read",
    UserPreferenceUpdate = "userPreference.update",
    UserProfileImageCreate = "userProfileImage.create",
    UserProfileImageRead = "userProfileImage.read",
    UserProfileImageUpdate = "userProfileImage.update",
    UserProfileImageDelete = "userProfileImage.delete",
    QueueRead = "queue.read",
    QueueUpdate = "queue.update",
    QueueJobCreate = "queueJob.create",
    QueueJobRead = "queueJob.read",
    QueueJobUpdate = "queueJob.update",
    QueueJobDelete = "queueJob.delete",
    WorkflowCreate = "workflow.create",
    WorkflowRead = "workflow.read",
    WorkflowUpdate = "workflow.update",
    WorkflowDelete = "workflow.delete",
    AdminUserCreate = "adminUser.create",
    AdminUserRead = "adminUser.read",
    AdminUserUpdate = "adminUser.update",
    AdminUserDelete = "adminUser.delete",
    AdminSessionRead = "adminSession.read",
    AdminAuthUnlinkAll = "adminAuth.unlinkAll"
}
export declare enum SharedLinkType {
    Album = "ALBUM",
    Individual = "INDIVIDUAL"
}
export declare enum StorageFolder {
    EncodedVideo = "encoded-video",
    Library = "library",
    Upload = "upload",
    Profile = "profile",
    Thumbnails = "thumbs",
    Backups = "backups"
}
export declare enum SystemMetadataKey {
    MediaLocation = "MediaLocation",
    ReverseGeocodingState = "reverse-geocoding-state",
    FacialRecognitionState = "facial-recognition-state",
    MemoriesState = "memories-state",
    AdminOnboarding = "admin-onboarding",
    MaintenanceMode = "maintenance-mode",
    SystemConfig = "system-config",
    SystemFlags = "system-flags",
    VersionCheckState = "version-check-state",
    License = "license"
}
export declare enum UserMetadataKey {
    Preferences = "preferences",
    License = "license",
    Onboarding = "onboarding"
}
export declare enum AssetMetadataKey {
    MobileApp = "mobile-app"
}
export declare enum UserAvatarColor {
    Primary = "primary",
    Pink = "pink",
    Red = "red",
    Yellow = "yellow",
    Blue = "blue",
    Green = "green",
    Purple = "purple",
    Orange = "orange",
    Gray = "gray",
    Amber = "amber"
}
export declare enum UserStatus {
    Active = "active",
    Removing = "removing",
    Deleted = "deleted"
}
export declare enum AssetStatus {
    Active = "active",
    Trashed = "trashed",
    Deleted = "deleted"
}
export declare enum SourceType {
    MachineLearning = "machine-learning",
    Exif = "exif",
    Manual = "manual"
}
export declare enum ManualJobName {
    PersonCleanup = "person-cleanup",
    TagCleanup = "tag-cleanup",
    UserCleanup = "user-cleanup",
    MemoryCleanup = "memory-cleanup",
    MemoryCreate = "memory-create",
    BackupDatabase = "backup-database"
}
export declare enum AssetPathType {
    Original = "original",
    EncodedVideo = "encoded_video"
}
export declare enum PersonPathType {
    Face = "face"
}
export declare enum UserPathType {
    Profile = "profile"
}
export type PathType = AssetFileType | AssetPathType | PersonPathType | UserPathType;
export declare enum TranscodePolicy {
    All = "all",
    Optimal = "optimal",
    Bitrate = "bitrate",
    Required = "required",
    Disabled = "disabled"
}
export declare enum TranscodeTarget {
    None = "NONE",
    Audio = "AUDIO",
    Video = "VIDEO",
    All = "ALL"
}
export declare enum VideoCodec {
    H264 = "h264",
    Hevc = "hevc",
    Vp9 = "vp9",
    Av1 = "av1"
}
export declare enum AudioCodec {
    Mp3 = "mp3",
    Aac = "aac",
    LibOpus = "libopus",
    PcmS16le = "pcm_s16le"
}
export declare enum VideoContainer {
    Mov = "mov",
    Mp4 = "mp4",
    Ogg = "ogg",
    Webm = "webm"
}
export declare enum TranscodeHardwareAcceleration {
    Nvenc = "nvenc",
    Qsv = "qsv",
    Vaapi = "vaapi",
    Rkmpp = "rkmpp",
    Disabled = "disabled"
}
export declare enum ToneMapping {
    Hable = "hable",
    Mobius = "mobius",
    Reinhard = "reinhard",
    Disabled = "disabled"
}
export declare enum CQMode {
    Auto = "auto",
    Cqp = "cqp",
    Icq = "icq"
}
export declare enum Colorspace {
    Srgb = "srgb",
    P3 = "p3"
}
export declare enum ImageFormat {
    Jpeg = "jpeg",
    Webp = "webp"
}
export declare enum RawExtractedFormat {
    Jpeg = "jpeg",
    Jxl = "jxl"
}
export declare enum LogLevel {
    Verbose = "verbose",
    Debug = "debug",
    Log = "log",
    Warn = "warn",
    Error = "error",
    Fatal = "fatal"
}
export declare enum LogFormat {
    Console = "console",
    Json = "json"
}
export declare enum ApiCustomExtension {
    Permission = "x-immich-permission",
    AdminOnly = "x-immich-admin-only",
    History = "x-immich-history",
    State = "x-immich-state"
}
export declare enum MetadataKey {
    AuthRoute = "auth_route",
    AdminRoute = "admin_route",
    SharedRoute = "shared_route",
    ApiKeySecurity = "api_key",
    EventConfig = "event_config",
    JobConfig = "job_config",
    TelemetryEnabled = "telemetry_enabled"
}
export declare enum RouteKey {
    Asset = "assets",
    User = "users"
}
export declare enum CacheControl {
    PrivateWithCache = "private_with_cache",
    PrivateWithoutCache = "private_without_cache",
    None = "none"
}
export declare enum ImmichEnvironment {
    Development = "development",
    Testing = "testing",
    Production = "production"
}
export declare enum ImmichWorker {
    Api = "api",
    Maintenance = "maintenance",
    Microservices = "microservices"
}
export declare enum ImmichTelemetry {
    Host = "host",
    Api = "api",
    Io = "io",
    Repo = "repo",
    Job = "job"
}
export declare enum ExifOrientation {
    Horizontal = 1,
    MirrorHorizontal = 2,
    Rotate180 = 3,
    MirrorVertical = 4,
    MirrorHorizontalRotate270CW = 5,
    Rotate90CW = 6,
    MirrorHorizontalRotate90CW = 7,
    Rotate270CW = 8
}
export declare enum DatabaseExtension {
    Cube = "cube",
    EarthDistance = "earthdistance",
    Vector = "vector",
    Vectors = "vectors",
    VectorChord = "vchord"
}
export declare enum BootstrapEventPriority {
    DatabaseService = -200,
    StorageService = -195,
    JobService = -190,
    SystemConfig = 100
}
export declare enum QueueName {
    ThumbnailGeneration = "thumbnailGeneration",
    MetadataExtraction = "metadataExtraction",
    VideoConversion = "videoConversion",
    FaceDetection = "faceDetection",
    FacialRecognition = "facialRecognition",
    SmartSearch = "smartSearch",
    DuplicateDetection = "duplicateDetection",
    BackgroundTask = "backgroundTask",
    StorageTemplateMigration = "storageTemplateMigration",
    Migration = "migration",
    Search = "search",
    Sidecar = "sidecar",
    Library = "library",
    Notification = "notifications",
    BackupDatabase = "backupDatabase",
    Ocr = "ocr",
    Workflow = "workflow",
    Editor = "editor"
}
export declare enum QueueJobStatus {
    Active = "active",
    Failed = "failed",
    Complete = "completed",
    Delayed = "delayed",
    Waiting = "waiting",
    Paused = "paused"
}
export declare enum JobName {
    AssetDelete = "AssetDelete",
    AssetDeleteCheck = "AssetDeleteCheck",
    AssetDetectFacesQueueAll = "AssetDetectFacesQueueAll",
    AssetDetectFaces = "AssetDetectFaces",
    AssetDetectDuplicatesQueueAll = "AssetDetectDuplicatesQueueAll",
    AssetDetectDuplicates = "AssetDetectDuplicates",
    AssetEditThumbnailGeneration = "AssetEditThumbnailGeneration",
    AssetEncodeVideoQueueAll = "AssetEncodeVideoQueueAll",
    AssetEncodeVideo = "AssetEncodeVideo",
    AssetEmptyTrash = "AssetEmptyTrash",
    AssetExtractMetadataQueueAll = "AssetExtractMetadataQueueAll",
    AssetExtractMetadata = "AssetExtractMetadata",
    AssetFileMigration = "AssetFileMigration",
    AssetGenerateThumbnailsQueueAll = "AssetGenerateThumbnailsQueueAll",
    AssetGenerateThumbnails = "AssetGenerateThumbnails",
    AuditLogCleanup = "AuditLogCleanup",
    AuditTableCleanup = "AuditTableCleanup",
    DatabaseBackup = "DatabaseBackup",
    FacialRecognitionQueueAll = "FacialRecognitionQueueAll",
    FacialRecognition = "FacialRecognition",
    FileDelete = "FileDelete",
    FileMigrationQueueAll = "FileMigrationQueueAll",
    LibraryDeleteCheck = "LibraryDeleteCheck",
    LibraryDelete = "LibraryDelete",
    LibraryRemoveAsset = "LibraryRemoveAsset",
    LibrarySyncAssetsQueueAll = "LibraryScanAssetsQueueAll",
    LibrarySyncAssets = "LibrarySyncAssets",
    LibrarySyncFilesQueueAll = "LibrarySyncFilesQueueAll",
    LibrarySyncFiles = "LibrarySyncFiles",
    LibraryScanQueueAll = "LibraryScanQueueAll",
    MemoryCleanup = "MemoryCleanup",
    MemoryGenerate = "MemoryGenerate",
    NotificationsCleanup = "NotificationsCleanup",
    NotifyUserSignup = "NotifyUserSignup",
    NotifyAlbumInvite = "NotifyAlbumInvite",
    NotifyAlbumUpdate = "NotifyAlbumUpdate",
    UserDelete = "UserDelete",
    UserDeleteCheck = "UserDeleteCheck",
    UserSyncUsage = "UserSyncUsage",
    PersonCleanup = "PersonCleanup",
    PersonFileMigration = "PersonFileMigration",
    PersonGenerateThumbnail = "PersonGenerateThumbnail",
    SessionCleanup = "SessionCleanup",
    SendMail = "SendMail",
    SidecarQueueAll = "SidecarQueueAll",
    SidecarCheck = "SidecarCheck",
    SidecarWrite = "SidecarWrite",
    SmartSearchQueueAll = "SmartSearchQueueAll",
    SmartSearch = "SmartSearch",
    StorageTemplateMigration = "StorageTemplateMigration",
    StorageTemplateMigrationSingle = "StorageTemplateMigrationSingle",
    TagCleanup = "TagCleanup",
    VersionCheck = "VersionCheck",
    OcrQueueAll = "OcrQueueAll",
    Ocr = "Ocr",
    WorkflowRun = "WorkflowRun"
}
export declare enum QueueCommand {
    Start = "start",
    Pause = "pause",
    Resume = "resume",
    Empty = "empty",
    ClearFailed = "clear-failed"
}
export declare enum JobStatus {
    Success = "success",
    Failed = "failed",
    Skipped = "skipped"
}
export declare enum QueueCleanType {
    Failed = "failed"
}
export declare enum VectorIndex {
    Clip = "clip_index",
    Face = "face_index"
}
export declare enum DatabaseLock {
    GeodataImport = 100,
    Migrations = 200,
    SystemFileMounts = 300,
    StorageTemplateMigration = 420,
    VersionHistory = 500,
    CLIPDimSize = 512,
    Library = 1337,
    NightlyJobs = 600,
    MediaLocation = 700,
    GetSystemConfig = 69,
    BackupDatabase = 42,
    MaintenanceOperation = 621,
    MemoryCreation = 777
}
export declare enum MaintenanceAction {
    Start = "start",
    End = "end",
    SelectDatabaseRestore = "select_database_restore",
    RestoreDatabase = "restore_database"
}
export declare enum ExitCode {
    AppRestart = 7
}
export declare enum SyncRequestType {
    AlbumsV1 = "AlbumsV1",
    AlbumUsersV1 = "AlbumUsersV1",
    AlbumToAssetsV1 = "AlbumToAssetsV1",
    AlbumAssetsV1 = "AlbumAssetsV1",
    AlbumAssetExifsV1 = "AlbumAssetExifsV1",
    AssetsV1 = "AssetsV1",
    AssetExifsV1 = "AssetExifsV1",
    AssetMetadataV1 = "AssetMetadataV1",
    AuthUsersV1 = "AuthUsersV1",
    MemoriesV1 = "MemoriesV1",
    MemoryToAssetsV1 = "MemoryToAssetsV1",
    PartnersV1 = "PartnersV1",
    PartnerAssetsV1 = "PartnerAssetsV1",
    PartnerAssetExifsV1 = "PartnerAssetExifsV1",
    PartnerStacksV1 = "PartnerStacksV1",
    StacksV1 = "StacksV1",
    UsersV1 = "UsersV1",
    PeopleV1 = "PeopleV1",
    AssetFacesV1 = "AssetFacesV1",
    UserMetadataV1 = "UserMetadataV1"
}
export declare enum SyncEntityType {
    AuthUserV1 = "AuthUserV1",
    UserV1 = "UserV1",
    UserDeleteV1 = "UserDeleteV1",
    AssetV1 = "AssetV1",
    AssetDeleteV1 = "AssetDeleteV1",
    AssetExifV1 = "AssetExifV1",
    AssetMetadataV1 = "AssetMetadataV1",
    AssetMetadataDeleteV1 = "AssetMetadataDeleteV1",
    PartnerV1 = "PartnerV1",
    PartnerDeleteV1 = "PartnerDeleteV1",
    PartnerAssetV1 = "PartnerAssetV1",
    PartnerAssetBackfillV1 = "PartnerAssetBackfillV1",
    PartnerAssetDeleteV1 = "PartnerAssetDeleteV1",
    PartnerAssetExifV1 = "PartnerAssetExifV1",
    PartnerAssetExifBackfillV1 = "PartnerAssetExifBackfillV1",
    PartnerStackBackfillV1 = "PartnerStackBackfillV1",
    PartnerStackDeleteV1 = "PartnerStackDeleteV1",
    PartnerStackV1 = "PartnerStackV1",
    AlbumV1 = "AlbumV1",
    AlbumDeleteV1 = "AlbumDeleteV1",
    AlbumUserV1 = "AlbumUserV1",
    AlbumUserBackfillV1 = "AlbumUserBackfillV1",
    AlbumUserDeleteV1 = "AlbumUserDeleteV1",
    AlbumAssetCreateV1 = "AlbumAssetCreateV1",
    AlbumAssetUpdateV1 = "AlbumAssetUpdateV1",
    AlbumAssetBackfillV1 = "AlbumAssetBackfillV1",
    AlbumAssetExifCreateV1 = "AlbumAssetExifCreateV1",
    AlbumAssetExifUpdateV1 = "AlbumAssetExifUpdateV1",
    AlbumAssetExifBackfillV1 = "AlbumAssetExifBackfillV1",
    AlbumToAssetV1 = "AlbumToAssetV1",
    AlbumToAssetDeleteV1 = "AlbumToAssetDeleteV1",
    AlbumToAssetBackfillV1 = "AlbumToAssetBackfillV1",
    MemoryV1 = "MemoryV1",
    MemoryDeleteV1 = "MemoryDeleteV1",
    MemoryToAssetV1 = "MemoryToAssetV1",
    MemoryToAssetDeleteV1 = "MemoryToAssetDeleteV1",
    StackV1 = "StackV1",
    StackDeleteV1 = "StackDeleteV1",
    PersonV1 = "PersonV1",
    PersonDeleteV1 = "PersonDeleteV1",
    AssetFaceV1 = "AssetFaceV1",
    AssetFaceDeleteV1 = "AssetFaceDeleteV1",
    UserMetadataV1 = "UserMetadataV1",
    UserMetadataDeleteV1 = "UserMetadataDeleteV1",
    SyncAckV1 = "SyncAckV1",
    SyncResetV1 = "SyncResetV1",
    SyncCompleteV1 = "SyncCompleteV1"
}
export declare enum NotificationLevel {
    Success = "success",
    Error = "error",
    Warning = "warning",
    Info = "info"
}
export declare enum NotificationType {
    JobFailed = "JobFailed",
    BackupFailed = "BackupFailed",
    SystemMessage = "SystemMessage",
    AlbumInvite = "AlbumInvite",
    AlbumUpdate = "AlbumUpdate",
    Custom = "Custom"
}
export declare enum OAuthTokenEndpointAuthMethod {
    ClientSecretPost = "client_secret_post",
    ClientSecretBasic = "client_secret_basic"
}
export declare enum DatabaseSslMode {
    Disable = "disable",
    Allow = "allow",
    Prefer = "prefer",
    Require = "require",
    VerifyFull = "verify-full"
}
export declare enum AssetVisibility {
    Archive = "archive",
    Timeline = "timeline",
    Hidden = "hidden",
    Locked = "locked"
}
export declare enum CronJob {
    LibraryScan = "LibraryScan",
    NightlyJobs = "NightlyJobs"
}
export declare enum ApiTag {
    Activities = "Activities",
    Albums = "Albums",
    ApiKeys = "API keys",
    Authentication = "Authentication",
    AuthenticationAdmin = "Authentication (admin)",
    Assets = "Assets",
    DatabaseBackups = "Database Backups (admin)",
    Deprecated = "Deprecated",
    Download = "Download",
    Duplicates = "Duplicates",
    Faces = "Faces",
    Jobs = "Jobs",
    Libraries = "Libraries",
    Maintenance = "Maintenance (admin)",
    Map = "Map",
    Memories = "Memories",
    Notifications = "Notifications",
    NotificationsAdmin = "Notifications (admin)",
    Partners = "Partners",
    People = "People",
    Plugins = "Plugins",
    Queues = "Queues",
    Search = "Search",
    Server = "Server",
    Sessions = "Sessions",
    SharedLinks = "Shared links",
    Stacks = "Stacks",
    Sync = "Sync",
    SystemConfig = "System config",
    SystemMetadata = "System metadata",
    Tags = "Tags",
    Timeline = "Timeline",
    Trash = "Trash",
    UsersAdmin = "Users (admin)",
    Users = "Users",
    Views = "Views",
    Workflows = "Workflows"
}
export declare enum PluginContext {
    Asset = "asset",
    Album = "album",
    Person = "person"
}
export declare enum PluginTriggerType {
    AssetCreate = "AssetCreate",
    PersonRecognized = "PersonRecognized"
}
