"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MaintenanceWorkerController = void 0;
const openapi = require("@nestjs/swagger");
const common_1 = require("@nestjs/common");
const platform_express_1 = require("@nestjs/platform-express");
const maintenance_dto_1 = require("../dtos/maintenance.dto");
const server_dto_1 = require("../dtos/server.dto");
const enum_1 = require("../enum");
const maintenance_auth_guard_1 = require("./maintenance-auth.guard");
const maintenance_worker_service_1 = require("./maintenance-worker.service");
const auth_guard_1 = require("../middleware/auth.guard");
const logging_repository_1 = require("../repositories/logging.repository");
const file_1 = require("../utils/file");
const response_1 = require("../utils/response");
const validation_1 = require("../validation");
const database_backup_dto_1 = require("../dtos/database-backup.dto");
let MaintenanceWorkerController = class MaintenanceWorkerController {
    logger;
    service;
    constructor(logger, service) {
        this.logger = logger;
        this.service = service;
    }
    getServerConfig() {
        return this.service.getSystemConfig();
    }
    getServerVersion() {
        return this.service.getVersion();
    }
    listDatabaseBackups() {
        return this.service.listBackups();
    }
    async downloadDatabaseBackup({ filename }, res, next) {
        await (0, file_1.sendFile)(res, next, () => this.service.downloadBackup(filename), this.logger);
    }
    async deleteDatabaseBackup(dto) {
        return this.service.deleteBackup(dto.backups);
    }
    uploadDatabaseBackup(file) {
        return this.service.uploadBackup(file);
    }
    maintenanceStatus(request) {
        return this.service.status(request.cookies[enum_1.ImmichCookie.MaintenanceToken]);
    }
    detectPriorInstall() {
        return this.service.detectPriorInstall();
    }
    async maintenanceLogin(request, dto, loginDetails, res) {
        const token = dto.token ?? request.cookies[enum_1.ImmichCookie.MaintenanceToken];
        const auth = await this.service.login(token);
        return (0, response_1.respondWithCookie)(res, auth, {
            isSecure: loginDetails.isSecure,
            values: [{ key: enum_1.ImmichCookie.MaintenanceToken, value: token }],
        });
    }
    setMaintenanceMode(dto) {
        void this.service.setAction(dto);
    }
};
exports.MaintenanceWorkerController = MaintenanceWorkerController;
__decorate([
    openapi.ApiOperation({ summary: "{@link _ServerController.getServerConfig }" }),
    (0, common_1.Get)('server/config'),
    openapi.ApiResponse({ status: 200, type: require("../dtos/server.dto").ServerConfigDto }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", server_dto_1.ServerConfigDto)
], MaintenanceWorkerController.prototype, "getServerConfig", null);
__decorate([
    (0, common_1.Get)('server/version'),
    openapi.ApiResponse({ status: 200, type: require("../dtos/server.dto").ServerVersionResponseDto }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", server_dto_1.ServerVersionResponseDto)
], MaintenanceWorkerController.prototype, "getServerVersion", null);
__decorate([
    openapi.ApiOperation({ summary: "{@link _DatabaseBackupController.listDatabaseBackups}" }),
    (0, common_1.Get)('admin/database-backups'),
    (0, maintenance_auth_guard_1.MaintenanceRoute)(),
    openapi.ApiResponse({ status: 200, type: require("../dtos/database-backup.dto").DatabaseBackupListResponseDto }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], MaintenanceWorkerController.prototype, "listDatabaseBackups", null);
__decorate([
    openapi.ApiOperation({ summary: "{@link _DatabaseBackupController.downloadDatabaseBackup}" }),
    (0, common_1.Get)('admin/database-backups/:filename'),
    (0, maintenance_auth_guard_1.MaintenanceRoute)(),
    openapi.ApiResponse({ status: 200 }),
    __param(0, (0, common_1.Param)()),
    __param(1, (0, common_1.Res)()),
    __param(2, (0, common_1.Next)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [validation_1.FilenameParamDto, Object, Function]),
    __metadata("design:returntype", Promise)
], MaintenanceWorkerController.prototype, "downloadDatabaseBackup", null);
__decorate([
    openapi.ApiOperation({ summary: "{@link _DatabaseBackupController.deleteDatabaseBackup}" }),
    (0, common_1.Delete)('admin/database-backups'),
    (0, maintenance_auth_guard_1.MaintenanceRoute)(),
    openapi.ApiResponse({ status: 200 }),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [database_backup_dto_1.DatabaseBackupDeleteDto]),
    __metadata("design:returntype", Promise)
], MaintenanceWorkerController.prototype, "deleteDatabaseBackup", null);
__decorate([
    openapi.ApiOperation({ summary: "{@link _DatabaseBackupController.uploadDatabaseBackup}" }),
    (0, common_1.Post)('admin/database-backups/upload'),
    (0, maintenance_auth_guard_1.MaintenanceRoute)(),
    (0, common_1.UseInterceptors)((0, platform_express_1.FileInterceptor)('file')),
    openapi.ApiResponse({ status: 201 }),
    __param(0, (0, common_1.UploadedFile)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], MaintenanceWorkerController.prototype, "uploadDatabaseBackup", null);
__decorate([
    (0, common_1.Get)('admin/maintenance/status'),
    openapi.ApiResponse({ status: 200, type: require("../dtos/maintenance.dto").MaintenanceStatusResponseDto }),
    __param(0, (0, common_1.Req)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], MaintenanceWorkerController.prototype, "maintenanceStatus", null);
__decorate([
    (0, common_1.Get)('admin/maintenance/detect-install'),
    openapi.ApiResponse({ status: 200, type: require("../dtos/maintenance.dto").MaintenanceDetectInstallResponseDto }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], MaintenanceWorkerController.prototype, "detectPriorInstall", null);
__decorate([
    (0, common_1.Post)('admin/maintenance/login'),
    openapi.ApiResponse({ status: 201, type: require("../dtos/maintenance.dto").MaintenanceAuthDto }),
    __param(0, (0, common_1.Req)()),
    __param(1, (0, common_1.Body)()),
    __param(2, (0, auth_guard_1.GetLoginDetails)()),
    __param(3, (0, common_1.Res)({ passthrough: true })),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, maintenance_dto_1.MaintenanceLoginDto, Object, Object]),
    __metadata("design:returntype", Promise)
], MaintenanceWorkerController.prototype, "maintenanceLogin", null);
__decorate([
    (0, common_1.Post)('admin/maintenance'),
    (0, maintenance_auth_guard_1.MaintenanceRoute)(),
    openapi.ApiResponse({ status: 201 }),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [maintenance_dto_1.SetMaintenanceModeDto]),
    __metadata("design:returntype", void 0)
], MaintenanceWorkerController.prototype, "setMaintenanceMode", null);
exports.MaintenanceWorkerController = MaintenanceWorkerController = __decorate([
    (0, common_1.Controller)(),
    __metadata("design:paramtypes", [logging_repository_1.LoggingRepository,
        maintenance_worker_service_1.MaintenanceWorkerService])
], MaintenanceWorkerController);
//# sourceMappingURL=maintenance-worker.controller.js.map