import { Insertable, Kysely, Updateable } from 'kysely';
import { AlbumUserRole } from 'src/enum';
import { DB } from 'src/schema';
import { AlbumUserTable } from 'src/schema/tables/album-user.table';
export type AlbumPermissionId = {
    albumId: string;
    userId: string;
};
export declare class AlbumUserRepository {
    private db;
    constructor(db: Kysely<DB>);
    create(albumUser: Insertable<AlbumUserTable>): Promise<{
        role: AlbumUserRole;
        userId: string;
        albumId: string;
    }>;
    update({ userId, albumId }: AlbumPermissionId, dto: Updateable<AlbumUserTable>): Promise<{
        updatedAt: Date;
        createdAt: Date;
        updateId: string;
        role: AlbumUserRole;
        userId: string;
        albumId: string;
        createId: string;
    }>;
    delete({ userId, albumId }: AlbumPermissionId): Promise<void>;
}
