import { RegisterQueueOptions } from '@nestjs/bullmq';
import { QueueOptions } from 'bullmq';
import { RedisOptions } from 'ioredis';
import { ClsModuleOptions } from 'nestjs-cls';
import { OpenTelemetryModuleOptions } from 'nestjs-otel/lib/interfaces';
import { ImmichEnvironment, ImmichTelemetry, ImmichWorker, LogFormat, LogLevel } from 'src/enum';
import { DatabaseConnectionParams, VectorExtension } from 'src/types';
export interface EnvData {
    host?: string;
    port: number;
    environment: ImmichEnvironment;
    configFile?: string;
    logLevel?: LogLevel;
    logFormat?: LogFormat;
    buildMetadata: {
        build?: string;
        buildUrl?: string;
        buildImage?: string;
        buildImageUrl?: string;
        repository?: string;
        repositoryUrl?: string;
        sourceRef?: string;
        sourceCommit?: string;
        sourceUrl?: string;
        thirdPartySourceUrl?: string;
        thirdPartyBugFeatureUrl?: string;
        thirdPartyDocumentationUrl?: string;
        thirdPartySupportUrl?: string;
    };
    bull: {
        config: QueueOptions;
        queues: RegisterQueueOptions[];
    };
    cls: {
        config: ClsModuleOptions;
    };
    database: {
        config: DatabaseConnectionParams;
        skipMigrations: boolean;
        vectorExtension?: VectorExtension;
    };
    licensePublicKey: {
        client: string;
        server: string;
    };
    network: {
        trustedProxies: string[];
    };
    otel: OpenTelemetryModuleOptions;
    resourcePaths: {
        lockFile: string;
        geodata: {
            dateFile: string;
            admin1: string;
            admin2: string;
            cities500: string;
            naturalEarthCountriesPath: string;
        };
        web: {
            root: string;
            indexHtml: string;
        };
        corePlugin: string;
    };
    redis: RedisOptions;
    setup: {
        allow: boolean;
    };
    telemetry: {
        apiPort: number;
        microservicesPort: number;
        metrics: Set<ImmichTelemetry>;
    };
    storage: {
        ignoreMountCheckErrors: boolean;
        mediaLocation?: string;
    };
    workers: ImmichWorker[];
    plugins: {
        external: {
            allow: boolean;
            installFolder?: string;
        };
    };
    noColor: boolean;
    nodeVersion?: string;
}
export declare class ConfigRepository {
    private worker?;
    constructor(worker?: ImmichWorker | undefined);
    getEnv(): EnvData;
    isDev(): boolean;
    getWorker(): ImmichWorker | undefined;
}
export declare const clearEnvCache: () => undefined;
