import { Kysely } from 'kysely';
import { DB } from 'src/schema';
export declare class DownloadRepository {
    private db;
    constructor(db: Kysely<DB>);
    downloadAssetIds(ids: string[]): AsyncIterableIterator<{
        id: string;
        livePhotoVideoId: string | null;
        size: number | null;
    }>;
    downloadMotionAssetIds(ids: string[]): AsyncIterableIterator<{
        id: string;
        livePhotoVideoId: string | null;
        size: number | null;
    } & {
        originalPath: string;
    }>;
    downloadAlbumId(albumId: string): AsyncIterableIterator<{
        id: string;
        livePhotoVideoId: string | null;
        size: number | null;
    }>;
    downloadUserId(userId: string): AsyncIterableIterator<{
        id: string;
        livePhotoVideoId: string | null;
        size: number | null;
    }>;
}
