import { ModuleRef } from '@nestjs/core';
import { ClassConstructor } from 'class-transformer';
import { QueueJobResponseDto, QueueJobSearchDto } from 'src/dtos/queue.dto';
import { JobName, JobStatus, QueueCleanType, QueueName } from 'src/enum';
import { ConfigRepository } from 'src/repositories/config.repository';
import { EventRepository } from 'src/repositories/event.repository';
import { LoggingRepository } from 'src/repositories/logging.repository';
import { JobCounts, JobItem } from 'src/types';
export declare class JobRepository {
    private moduleRef;
    private configRepository;
    private eventRepository;
    private logger;
    private workers;
    private handlers;
    constructor(moduleRef: ModuleRef, configRepository: ConfigRepository, eventRepository: EventRepository, logger: LoggingRepository);
    setup(services: ClassConstructor<unknown>[]): void;
    startWorkers(): void;
    run({ name, data }: JobItem): Promise<JobStatus>;
    setConcurrency(queueName: QueueName, concurrency: number): void;
    isActive(name: QueueName): Promise<boolean>;
    isPaused(name: QueueName): Promise<boolean>;
    pause(name: QueueName): Promise<void>;
    resume(name: QueueName): Promise<void>;
    empty(name: QueueName): Promise<void>;
    clear(name: QueueName, type: QueueCleanType): Promise<string[]>;
    getJobCounts(name: QueueName): Promise<JobCounts>;
    private getQueueName;
    queueAll(items: JobItem[]): Promise<void>;
    queue(item: JobItem): Promise<void>;
    waitForQueueCompletion(...queues: QueueName[]): Promise<void>;
    searchJobs(name: QueueName, dto: QueueJobSearchDto): Promise<QueueJobResponseDto[]>;
    private getJobOptions;
    private getQueue;
    removeJob(name: JobName, jobID: string): Promise<void>;
}
