"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PartnerRepository = exports.PartnerDirection = void 0;
const common_1 = require("@nestjs/common");
const kysely_1 = require("kysely");
const postgres_1 = require("kysely/helpers/postgres");
const nestjs_kysely_1 = require("nestjs-kysely");
const database_1 = require("../database");
const decorators_1 = require("../decorators");
var PartnerDirection;
(function (PartnerDirection) {
    PartnerDirection["SharedBy"] = "shared-by";
    PartnerDirection["SharedWith"] = "shared-with";
})(PartnerDirection || (exports.PartnerDirection = PartnerDirection = {}));
const withSharedBy = (eb) => {
    return (0, postgres_1.jsonObjectFrom)(eb.selectFrom('user as sharedBy').select(database_1.columns.user).whereRef('sharedBy.id', '=', 'partner.sharedById')).as('sharedBy');
};
const withSharedWith = (eb) => {
    return (0, postgres_1.jsonObjectFrom)(eb.selectFrom('user as sharedWith').select(database_1.columns.user).whereRef('sharedWith.id', '=', 'partner.sharedWithId')).as('sharedWith');
};
let PartnerRepository = class PartnerRepository {
    db;
    constructor(db) {
        this.db = db;
    }
    getAll(userId) {
        return this.builder()
            .where((eb) => eb.or([eb('sharedWithId', '=', userId), eb('sharedById', '=', userId)]))
            .execute();
    }
    get({ sharedWithId, sharedById }) {
        return this.builder()
            .where('sharedWithId', '=', sharedWithId)
            .where('sharedById', '=', sharedById)
            .executeTakeFirst();
    }
    create(values) {
        return this.db
            .insertInto('partner')
            .values(values)
            .returningAll()
            .returning(withSharedBy)
            .returning(withSharedWith)
            .$narrowType()
            .executeTakeFirstOrThrow();
    }
    update({ sharedWithId, sharedById }, values) {
        return this.db
            .updateTable('partner')
            .set(values)
            .where('sharedWithId', '=', sharedWithId)
            .where('sharedById', '=', sharedById)
            .returningAll()
            .returning(withSharedBy)
            .returning(withSharedWith)
            .$narrowType()
            .executeTakeFirstOrThrow();
    }
    async remove({ sharedWithId, sharedById }) {
        await this.db
            .deleteFrom('partner')
            .where('sharedWithId', '=', sharedWithId)
            .where('sharedById', '=', sharedById)
            .execute();
    }
    builder() {
        return this.db
            .selectFrom('partner')
            .innerJoin('user as sharedBy', (join) => join.onRef('partner.sharedById', '=', 'sharedBy.id').on('sharedBy.deletedAt', 'is', null))
            .innerJoin('user as sharedWith', (join) => join.onRef('partner.sharedWithId', '=', 'sharedWith.id').on('sharedWith.deletedAt', 'is', null))
            .selectAll('partner')
            .select(withSharedBy)
            .select(withSharedWith);
    }
};
exports.PartnerRepository = PartnerRepository;
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], PartnerRepository.prototype, "getAll", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [{ sharedWithId: decorators_1.DummyValue.UUID, sharedById: decorators_1.DummyValue.UUID }] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], PartnerRepository.prototype, "get", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [{ sharedWithId: decorators_1.DummyValue.UUID, sharedById: decorators_1.DummyValue.UUID }, { inTimeline: true }] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object]),
    __metadata("design:returntype", void 0)
], PartnerRepository.prototype, "update", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [{ sharedWithId: decorators_1.DummyValue.UUID, sharedById: decorators_1.DummyValue.UUID }] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], PartnerRepository.prototype, "remove", null);
exports.PartnerRepository = PartnerRepository = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, nestjs_kysely_1.InjectKysely)()),
    __metadata("design:paramtypes", [kysely_1.Kysely])
], PartnerRepository);
//# sourceMappingURL=partner.repository.js.map