import { Insertable, Kysely, Updateable } from 'kysely';
import { Album } from 'src/database';
import { MapAsset } from 'src/dtos/asset-response.dto';
import { SharedLinkType } from 'src/enum';
import { DB } from 'src/schema';
import { SharedLinkTable } from 'src/schema/tables/shared-link.table';
export type SharedLinkSearchOptions = {
    userId: string;
    id?: string;
    albumId?: string;
};
export declare class SharedLinkRepository {
    private db;
    constructor(db: Kysely<DB>);
    get(userId: string, id: string): Promise<{
        password: string | null;
        key: Buffer<ArrayBufferLike>;
        slug: string | null;
        id: string;
        type: SharedLinkType;
        description: string | null;
        createdAt: Date;
        userId: string;
        albumId: string | null;
        expiresAt: Date | null;
        allowUpload: boolean;
        allowDownload: boolean;
        showExif: boolean;
        assets: MapAsset[];
        album: Album | null;
    } | undefined>;
    getAll({ userId, id, albumId }: SharedLinkSearchOptions): Promise<{
        password: string | null;
        key: Buffer<ArrayBufferLike>;
        slug: string | null;
        assets: {
            id: string;
            type: import("src/enum").AssetType;
            updatedAt: Date;
            createdAt: Date;
            deletedAt: Date | null;
            status: import("src/enum").AssetStatus;
            updateId: string;
            ownerId: string;
            width: number | null;
            height: number | null;
            deviceAssetId: string;
            deviceId: string;
            originalPath: string;
            fileCreatedAt: Date;
            fileModifiedAt: Date;
            isFavorite: boolean;
            duration: string | null;
            encodedVideoPath: string | null;
            checksum: Buffer<ArrayBufferLike>;
            livePhotoVideoId: string | null;
            originalFileName: string;
            thumbhash: Buffer<ArrayBufferLike> | null;
            isOffline: boolean;
            libraryId: string | null;
            isExternal: boolean;
            localDateTime: Date;
            stackId: string | null;
            duplicateId: string | null;
            visibility: import("src/enum").AssetVisibility;
            isEdited: boolean;
        }[];
        id: string;
        type: SharedLinkType;
        description: string | null;
        createdAt: Date;
        userId: string;
        albumId: string | null;
        expiresAt: Date | null;
        allowUpload: boolean;
        allowDownload: boolean;
        showExif: boolean;
        album: Album | null;
    }[]>;
    getByKey(key: Buffer): Promise<{
        id: string;
        userId: string;
        expiresAt: Date | null;
        showExif: boolean;
        allowUpload: boolean;
        allowDownload: boolean;
        password: string | null;
        user: {
            name: string;
            id: string;
            email: string;
            isAdmin: boolean;
            quotaSizeInBytes: number | null;
            quotaUsageInBytes: number;
        } | null;
    } | undefined>;
    getBySlug(slug: string): Promise<{
        id: string;
        userId: string;
        expiresAt: Date | null;
        showExif: boolean;
        allowUpload: boolean;
        allowDownload: boolean;
        password: string | null;
        user: {
            name: string;
            id: string;
            email: string;
            isAdmin: boolean;
            quotaSizeInBytes: number | null;
            quotaUsageInBytes: number;
        } | null;
    } | undefined>;
    private authBuilder;
    create(entity: Insertable<SharedLinkTable> & {
        assetIds?: string[];
    }): Promise<{
        password: string | null;
        key: Buffer<ArrayBufferLike>;
        slug: string | null;
        id: string;
        type: SharedLinkType;
        description: string | null;
        createdAt: Date;
        userId: string;
        albumId: string | null;
        expiresAt: Date | null;
        allowUpload: boolean;
        allowDownload: boolean;
        showExif: boolean;
        assets: MapAsset[];
    }>;
    update(entity: Updateable<SharedLinkTable> & {
        id: string;
        assetIds?: string[];
    }): Promise<{
        password: string | null;
        key: Buffer<ArrayBufferLike>;
        slug: string | null;
        id: string;
        type: SharedLinkType;
        description: string | null;
        createdAt: Date;
        userId: string;
        albumId: string | null;
        expiresAt: Date | null;
        allowUpload: boolean;
        allowDownload: boolean;
        showExif: boolean;
        assets: MapAsset[];
    }>;
    remove(id: string): Promise<void>;
    private getSharedLinks;
}
