import { Insertable, Kysely, Updateable } from 'kysely';
import { DB } from 'src/schema';
import { StackTable } from 'src/schema/tables/stack.table';
export interface StackSearch {
    ownerId: string;
    primaryAssetId?: string;
}
export declare class StackRepository {
    private db;
    constructor(db: Kysely<DB>);
    search(query: StackSearch): Promise<{
        id: string;
        updatedAt: Date;
        createdAt: Date;
        updateId: string;
        ownerId: string;
        primaryAssetId: string;
        assets: {
            id: string;
            type: import("../enum").AssetType;
            updatedAt: Date;
            createdAt: Date;
            deletedAt: Date | null;
            status: import("../enum").AssetStatus;
            updateId: string;
            ownerId: string;
            width: number | null;
            height: number | null;
            deviceAssetId: string;
            deviceId: string;
            originalPath: string;
            fileCreatedAt: Date;
            fileModifiedAt: Date;
            isFavorite: boolean;
            duration: string | null;
            encodedVideoPath: string | null;
            checksum: Buffer<ArrayBufferLike>;
            livePhotoVideoId: string | null;
            originalFileName: string;
            thumbhash: Buffer<ArrayBufferLike> | null;
            isOffline: boolean;
            libraryId: string | null;
            isExternal: boolean;
            localDateTime: Date;
            stackId: string | null;
            duplicateId: string | null;
            visibility: import("../enum").AssetVisibility;
            isEdited: boolean;
            tags?: {
                id: string;
                value: string;
                createdAt: Date;
                updatedAt: Date;
                color: string | null;
                parentId: string | null;
            }[] | undefined;
            exifInfo: {
                description: string;
                assetId: string;
                state: string | null;
                make: string | null;
                model: string | null;
                exifImageWidth: number | null;
                exifImageHeight: number | null;
                fileSizeInByte: number | null;
                orientation: string | null;
                dateTimeOriginal: Date | null;
                modifyDate: Date | null;
                lensModel: string | null;
                fNumber: number | null;
                focalLength: number | null;
                iso: number | null;
                latitude: number | null;
                longitude: number | null;
                city: string | null;
                country: string | null;
                fps: number | null;
                exposureTime: string | null;
                livePhotoCID: string | null;
                timeZone: string | null;
                projectionType: string | null;
                profileDescription: string | null;
                colorspace: string | null;
                bitsPerSample: number | null;
                autoStackId: string | null;
                rating: number | null;
                tags: string[] | null;
            };
        }[];
    }[]>;
    create(entity: Omit<Insertable<StackTable>, 'primaryAssetId'>, assetIds: string[]): Promise<{
        id: string;
        updatedAt: Date;
        createdAt: Date;
        updateId: string;
        ownerId: string;
        primaryAssetId: string;
        assets: {
            id: string;
            type: import("../enum").AssetType;
            updatedAt: Date;
            createdAt: Date;
            deletedAt: Date | null;
            status: import("../enum").AssetStatus;
            updateId: string;
            ownerId: string;
            width: number | null;
            height: number | null;
            deviceAssetId: string;
            deviceId: string;
            originalPath: string;
            fileCreatedAt: Date;
            fileModifiedAt: Date;
            isFavorite: boolean;
            duration: string | null;
            encodedVideoPath: string | null;
            checksum: Buffer<ArrayBufferLike>;
            livePhotoVideoId: string | null;
            originalFileName: string;
            thumbhash: Buffer<ArrayBufferLike> | null;
            isOffline: boolean;
            libraryId: string | null;
            isExternal: boolean;
            localDateTime: Date;
            stackId: string | null;
            duplicateId: string | null;
            visibility: import("../enum").AssetVisibility;
            isEdited: boolean;
            tags?: {
                id: string;
                value: string;
                createdAt: Date;
                updatedAt: Date;
                color: string | null;
                parentId: string | null;
            }[] | undefined;
            exifInfo: {
                description: string;
                assetId: string;
                state: string | null;
                make: string | null;
                model: string | null;
                exifImageWidth: number | null;
                exifImageHeight: number | null;
                fileSizeInByte: number | null;
                orientation: string | null;
                dateTimeOriginal: Date | null;
                modifyDate: Date | null;
                lensModel: string | null;
                fNumber: number | null;
                focalLength: number | null;
                iso: number | null;
                latitude: number | null;
                longitude: number | null;
                city: string | null;
                country: string | null;
                fps: number | null;
                exposureTime: string | null;
                livePhotoCID: string | null;
                timeZone: string | null;
                projectionType: string | null;
                profileDescription: string | null;
                colorspace: string | null;
                bitsPerSample: number | null;
                autoStackId: string | null;
                rating: number | null;
                tags: string[] | null;
            };
        }[];
    }>;
    delete(id: string): Promise<void>;
    deleteAll(ids: string[]): Promise<void>;
    update(id: string, entity: Updateable<StackTable>): Promise<{
        id: string;
        updatedAt: Date;
        createdAt: Date;
        updateId: string;
        ownerId: string;
        primaryAssetId: string;
        assets: {
            id: string;
            type: import("../enum").AssetType;
            updatedAt: Date;
            createdAt: Date;
            deletedAt: Date | null;
            status: import("../enum").AssetStatus;
            updateId: string;
            ownerId: string;
            width: number | null;
            height: number | null;
            deviceAssetId: string;
            deviceId: string;
            originalPath: string;
            fileCreatedAt: Date;
            fileModifiedAt: Date;
            isFavorite: boolean;
            duration: string | null;
            encodedVideoPath: string | null;
            checksum: Buffer<ArrayBufferLike>;
            livePhotoVideoId: string | null;
            originalFileName: string;
            thumbhash: Buffer<ArrayBufferLike> | null;
            isOffline: boolean;
            libraryId: string | null;
            isExternal: boolean;
            localDateTime: Date;
            stackId: string | null;
            duplicateId: string | null;
            visibility: import("../enum").AssetVisibility;
            isEdited: boolean;
            tags?: {
                id: string;
                value: string;
                createdAt: Date;
                updatedAt: Date;
                color: string | null;
                parentId: string | null;
            }[] | undefined;
            exifInfo: {
                description: string;
                assetId: string;
                state: string | null;
                make: string | null;
                model: string | null;
                exifImageWidth: number | null;
                exifImageHeight: number | null;
                fileSizeInByte: number | null;
                orientation: string | null;
                dateTimeOriginal: Date | null;
                modifyDate: Date | null;
                lensModel: string | null;
                fNumber: number | null;
                focalLength: number | null;
                iso: number | null;
                latitude: number | null;
                longitude: number | null;
                city: string | null;
                country: string | null;
                fps: number | null;
                exposureTime: string | null;
                livePhotoCID: string | null;
                timeZone: string | null;
                projectionType: string | null;
                profileDescription: string | null;
                colorspace: string | null;
                bitsPerSample: number | null;
                autoStackId: string | null;
                rating: number | null;
                tags: string[] | null;
            };
        }[];
    }>;
    getById(id: string): Promise<{
        id: string;
        updatedAt: Date;
        createdAt: Date;
        updateId: string;
        ownerId: string;
        primaryAssetId: string;
        assets: {
            id: string;
            type: import("../enum").AssetType;
            updatedAt: Date;
            createdAt: Date;
            deletedAt: Date | null;
            status: import("../enum").AssetStatus;
            updateId: string;
            ownerId: string;
            width: number | null;
            height: number | null;
            deviceAssetId: string;
            deviceId: string;
            originalPath: string;
            fileCreatedAt: Date;
            fileModifiedAt: Date;
            isFavorite: boolean;
            duration: string | null;
            encodedVideoPath: string | null;
            checksum: Buffer<ArrayBufferLike>;
            livePhotoVideoId: string | null;
            originalFileName: string;
            thumbhash: Buffer<ArrayBufferLike> | null;
            isOffline: boolean;
            libraryId: string | null;
            isExternal: boolean;
            localDateTime: Date;
            stackId: string | null;
            duplicateId: string | null;
            visibility: import("../enum").AssetVisibility;
            isEdited: boolean;
            tags?: {
                id: string;
                value: string;
                createdAt: Date;
                updatedAt: Date;
                color: string | null;
                parentId: string | null;
            }[] | undefined;
            exifInfo: {
                description: string;
                assetId: string;
                state: string | null;
                make: string | null;
                model: string | null;
                exifImageWidth: number | null;
                exifImageHeight: number | null;
                fileSizeInByte: number | null;
                orientation: string | null;
                dateTimeOriginal: Date | null;
                modifyDate: Date | null;
                lensModel: string | null;
                fNumber: number | null;
                focalLength: number | null;
                iso: number | null;
                latitude: number | null;
                longitude: number | null;
                city: string | null;
                country: string | null;
                fps: number | null;
                exposureTime: string | null;
                livePhotoCID: string | null;
                timeZone: string | null;
                projectionType: string | null;
                profileDescription: string | null;
                colorspace: string | null;
                bitsPerSample: number | null;
                autoStackId: string | null;
                rating: number | null;
                tags: string[] | null;
            };
        }[];
    } | undefined>;
    getForAssetRemoval(assetId: string): Promise<{
        primaryAssetId: string | null;
        id: import("node_modules/kysely/dist/cjs/util/type-utils").ExtractColumnType<{
            library: import("../schema/tables/library.table").LibraryTable;
            api_key: import("../schema/tables/api-key.table").ApiKeyTable;
            workflow: import("../schema/tables/workflow.table").WorkflowTable;
            asset: import("../schema/tables/asset.table").AssetTable;
            album: import("../schema/tables/album.table").AlbumTable;
            person: import("../schema/tables/person.table").PersonTable;
            smart_search: import("../schema/tables/smart-search.table").SmartSearchTable;
            face_search: import("../schema/tables/face-search.table").FaceSearchTable;
            user: import("../schema/tables/user.table").UserTable;
            user_metadata_audit: import("../schema/tables/user-metadata-audit.table").UserMetadataAuditTable;
            asset_metadata_audit: import("../schema/tables/asset-metadata-audit.table").AssetMetadataAuditTable;
            asset_face_audit: import("../schema/tables/asset-face-audit.table").AssetFaceAuditTable;
            stack: import("kysely").Nullable<StackTable>;
            activity: import("../schema/tables/activity.table").ActivityTable;
            album_audit: import("../schema/tables/album-audit.table").AlbumAuditTable;
            album_asset: import("../schema/tables/album-asset.table").AlbumAssetTable;
            album_asset_audit: import("../schema/tables/album-asset-audit.table").AlbumAssetAuditTable;
            album_user: import("../schema/tables/album-user.table").AlbumUserTable;
            album_user_audit: import("../schema/tables/album-user-audit.table").AlbumUserAuditTable;
            asset_audit: import("../schema/tables/asset-audit.table").AssetAuditTable;
            asset_edit: import("../schema/tables/asset-edit.table").AssetEditTable<import("../dtos/editing.dto").AssetEditAction>;
            asset_exif: import("../schema/tables/asset-exif.table").AssetExifTable;
            asset_face: import("../schema/tables/asset-face.table").AssetFaceTable;
            asset_file: import("../schema/tables/asset-file.table").AssetFileTable;
            asset_metadata: import("../schema/tables/asset-metadata.table").AssetMetadataTable;
            asset_job_status: import("../schema/tables/asset-job-status.table").AssetJobStatusTable;
            asset_ocr: import("../schema/tables/asset-ocr.table").AssetOcrTable;
            ocr_search: import("../schema/tables/ocr-search.table").OcrSearchTable;
            audit: import("../schema/tables/audit.table").AuditTable;
            geodata_places: import("../schema/tables/geodata-places.table").GeodataPlacesTable;
            memory: import("../schema/tables/memory.table").MemoryTable;
            memory_audit: import("../schema/tables/memory-audit.table").MemoryAuditTable;
            memory_asset: import("../schema/tables/memory-asset.table").MemoryAssetTable;
            memory_asset_audit: import("../schema/tables/memory-asset-audit.table").MemoryAssetAuditTable;
            migrations: import("src/schema").Migrations;
            notification: import("../schema/tables/notification.table").NotificationTable;
            move_history: import("../schema/tables/move.table").MoveTable;
            naturalearth_countries: import("../schema/tables/natural-earth-countries.table").NaturalEarthCountriesTable;
            partner: import("../schema/tables/partner.table").PartnerTable;
            partner_audit: import("../schema/tables/partner-audit.table").PartnerAuditTable;
            person_audit: import("../schema/tables/person-audit.table").PersonAuditTable;
            session: import("../schema/tables/session.table").SessionTable;
            session_sync_checkpoint: import("../schema/tables/sync-checkpoint.table").SessionSyncCheckpointTable;
            shared_link: import("../schema/tables/shared-link.table").SharedLinkTable;
            shared_link_asset: import("../schema/tables/shared-link-asset.table").SharedLinkAssetTable;
            stack_audit: import("../schema/tables/stack-audit.table").StackAuditTable;
            system_metadata: import("../schema/tables/system-metadata.table").SystemMetadataTable<import("../enum").SystemMetadataKey>;
            tag: import("../schema/tables/tag.table").TagTable;
            tag_asset: import("../schema/tables/tag-asset.table").TagAssetTable;
            tag_closure: import("../schema/tables/tag-closure.table").TagClosureTable;
            user_audit: import("../schema/tables/user-audit.table").UserAuditTable;
            user_metadata: import("../schema/tables/user-metadata.table").UserMetadataTable<import("../enum").UserMetadataKey>;
            version_history: import("../schema/tables/version-history.table").VersionHistoryTable;
            plugin: import("../schema/tables/plugin.table").PluginTable;
            plugin_filter: import("../schema/tables/plugin.table").PluginFilterTable;
            plugin_action: import("../schema/tables/plugin.table").PluginActionTable;
            workflow_filter: import("../schema/tables/workflow.table").WorkflowFilterTable;
            workflow_action: import("../schema/tables/workflow.table").WorkflowActionTable;
        }, "asset" | "stack", "stackId">;
    } | undefined>;
    merge({ sourceId, targetId }: {
        sourceId: string;
        targetId: string;
    }): Promise<import("kysely").UpdateResult[]>;
}
