import { Insertable, Kysely } from 'kysely';
import { DB } from 'src/schema';
import { VersionHistoryTable } from 'src/schema/tables/version-history.table';
export declare class VersionHistoryRepository {
    private db;
    constructor(db: Kysely<DB>);
    getAll(): Promise<{
        version: string;
        id: string;
        createdAt: Date;
    }[]>;
    getLatest(): Promise<{
        version: string;
        id: string;
        createdAt: Date;
    } | undefined>;
    create(version: Insertable<VersionHistoryTable>): Promise<{
        version: string;
        id: string;
        createdAt: Date;
    }>;
}
