"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ImmichDatabase = void 0;
const enums_1 = require("./enums");
const functions_1 = require("./functions");
const activity_table_1 = require("./tables/activity.table");
const album_asset_audit_table_1 = require("./tables/album-asset-audit.table");
const album_asset_table_1 = require("./tables/album-asset.table");
const album_audit_table_1 = require("./tables/album-audit.table");
const album_user_audit_table_1 = require("./tables/album-user-audit.table");
const album_user_table_1 = require("./tables/album-user.table");
const album_table_1 = require("./tables/album.table");
const api_key_table_1 = require("./tables/api-key.table");
const asset_audit_table_1 = require("./tables/asset-audit.table");
const asset_edit_table_1 = require("./tables/asset-edit.table");
const asset_exif_table_1 = require("./tables/asset-exif.table");
const asset_face_audit_table_1 = require("./tables/asset-face-audit.table");
const asset_face_table_1 = require("./tables/asset-face.table");
const asset_file_table_1 = require("./tables/asset-file.table");
const asset_job_status_table_1 = require("./tables/asset-job-status.table");
const asset_metadata_audit_table_1 = require("./tables/asset-metadata-audit.table");
const asset_metadata_table_1 = require("./tables/asset-metadata.table");
const asset_ocr_table_1 = require("./tables/asset-ocr.table");
const asset_table_1 = require("./tables/asset.table");
const audit_table_1 = require("./tables/audit.table");
const face_search_table_1 = require("./tables/face-search.table");
const geodata_places_table_1 = require("./tables/geodata-places.table");
const library_table_1 = require("./tables/library.table");
const memory_asset_audit_table_1 = require("./tables/memory-asset-audit.table");
const memory_asset_table_1 = require("./tables/memory-asset.table");
const memory_audit_table_1 = require("./tables/memory-audit.table");
const memory_table_1 = require("./tables/memory.table");
const move_table_1 = require("./tables/move.table");
const natural_earth_countries_table_1 = require("./tables/natural-earth-countries.table");
const notification_table_1 = require("./tables/notification.table");
const ocr_search_table_1 = require("./tables/ocr-search.table");
const partner_audit_table_1 = require("./tables/partner-audit.table");
const partner_table_1 = require("./tables/partner.table");
const person_audit_table_1 = require("./tables/person-audit.table");
const person_table_1 = require("./tables/person.table");
const plugin_table_1 = require("./tables/plugin.table");
const session_table_1 = require("./tables/session.table");
const shared_link_asset_table_1 = require("./tables/shared-link-asset.table");
const shared_link_table_1 = require("./tables/shared-link.table");
const smart_search_table_1 = require("./tables/smart-search.table");
const stack_audit_table_1 = require("./tables/stack-audit.table");
const stack_table_1 = require("./tables/stack.table");
const sync_checkpoint_table_1 = require("./tables/sync-checkpoint.table");
const system_metadata_table_1 = require("./tables/system-metadata.table");
const tag_asset_table_1 = require("./tables/tag-asset.table");
const tag_closure_table_1 = require("./tables/tag-closure.table");
const tag_table_1 = require("./tables/tag.table");
const user_audit_table_1 = require("./tables/user-audit.table");
const user_metadata_audit_table_1 = require("./tables/user-metadata-audit.table");
const user_metadata_table_1 = require("./tables/user-metadata.table");
const user_table_1 = require("./tables/user.table");
const version_history_table_1 = require("./tables/version-history.table");
const workflow_table_1 = require("./tables/workflow.table");
const sql_tools_1 = require("../sql-tools");
let ImmichDatabase = class ImmichDatabase {
    tables = [
        activity_table_1.ActivityTable,
        album_asset_table_1.AlbumAssetTable,
        album_asset_audit_table_1.AlbumAssetAuditTable,
        album_audit_table_1.AlbumAuditTable,
        album_user_audit_table_1.AlbumUserAuditTable,
        album_user_table_1.AlbumUserTable,
        album_table_1.AlbumTable,
        api_key_table_1.ApiKeyTable,
        asset_audit_table_1.AssetAuditTable,
        asset_edit_table_1.AssetEditTable,
        asset_face_table_1.AssetFaceTable,
        asset_face_audit_table_1.AssetFaceAuditTable,
        asset_metadata_table_1.AssetMetadataTable,
        asset_metadata_audit_table_1.AssetMetadataAuditTable,
        asset_job_status_table_1.AssetJobStatusTable,
        asset_ocr_table_1.AssetOcrTable,
        asset_table_1.AssetTable,
        asset_file_table_1.AssetFileTable,
        audit_table_1.AuditTable,
        asset_exif_table_1.AssetExifTable,
        face_search_table_1.FaceSearchTable,
        geodata_places_table_1.GeodataPlacesTable,
        library_table_1.LibraryTable,
        memory_table_1.MemoryTable,
        memory_audit_table_1.MemoryAuditTable,
        memory_asset_table_1.MemoryAssetTable,
        memory_asset_audit_table_1.MemoryAssetAuditTable,
        move_table_1.MoveTable,
        natural_earth_countries_table_1.NaturalEarthCountriesTable,
        notification_table_1.NotificationTable,
        ocr_search_table_1.OcrSearchTable,
        partner_audit_table_1.PartnerAuditTable,
        partner_table_1.PartnerTable,
        person_table_1.PersonTable,
        person_audit_table_1.PersonAuditTable,
        session_table_1.SessionTable,
        shared_link_asset_table_1.SharedLinkAssetTable,
        shared_link_table_1.SharedLinkTable,
        smart_search_table_1.SmartSearchTable,
        stack_table_1.StackTable,
        stack_audit_table_1.StackAuditTable,
        sync_checkpoint_table_1.SessionSyncCheckpointTable,
        system_metadata_table_1.SystemMetadataTable,
        tag_table_1.TagTable,
        tag_asset_table_1.TagAssetTable,
        tag_closure_table_1.TagClosureTable,
        user_audit_table_1.UserAuditTable,
        user_metadata_table_1.UserMetadataTable,
        user_metadata_audit_table_1.UserMetadataAuditTable,
        user_table_1.UserTable,
        version_history_table_1.VersionHistoryTable,
        plugin_table_1.PluginTable,
        plugin_table_1.PluginFilterTable,
        plugin_table_1.PluginActionTable,
        workflow_table_1.WorkflowTable,
        workflow_table_1.WorkflowFilterTable,
        workflow_table_1.WorkflowActionTable,
    ];
    functions = [
        functions_1.immich_uuid_v7,
        functions_1.updated_at,
        functions_1.f_concat_ws,
        functions_1.f_unaccent,
        functions_1.ll_to_earth_public,
        functions_1.user_delete_audit,
        functions_1.partner_delete_audit,
        functions_1.asset_delete_audit,
        functions_1.album_delete_audit,
        functions_1.album_user_after_insert,
        functions_1.album_user_delete_audit,
        functions_1.memory_delete_audit,
        functions_1.memory_asset_delete_audit,
        functions_1.stack_delete_audit,
        functions_1.person_delete_audit,
        functions_1.user_metadata_audit,
        functions_1.asset_metadata_audit,
        functions_1.asset_face_audit,
    ];
    enum = [enums_1.assets_status_enum, enums_1.asset_face_source_type, enums_1.asset_visibility_enum];
};
exports.ImmichDatabase = ImmichDatabase;
exports.ImmichDatabase = ImmichDatabase = __decorate([
    (0, sql_tools_1.Extensions)(['uuid-ossp', 'unaccent', 'cube', 'earthdistance', 'pg_trgm', 'plpgsql']),
    (0, sql_tools_1.Database)({ name: 'immich' })
], ImmichDatabase);
//# sourceMappingURL=index.js.map