"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.up = up;
exports.down = down;
const kysely_1 = require("kysely");
async function up(db) {
    await (0, kysely_1.sql) `DELETE FROM "asset_edit";`.execute(db);
    await (0, kysely_1.sql) `ALTER TABLE "asset_edit" ADD "sequence" integer NOT NULL;`.execute(db);
    await (0, kysely_1.sql) `ALTER TABLE "asset_edit" ADD CONSTRAINT "asset_edit_assetId_sequence_uq" UNIQUE ("assetId", "sequence");`.execute(db);
}
async function down(db) {
    await (0, kysely_1.sql) `ALTER TABLE "asset_edit" DROP CONSTRAINT "asset_edit_assetId_sequence_uq";`.execute(db);
    await (0, kysely_1.sql) `ALTER TABLE "asset_edit" DROP COLUMN "sequence";`.execute(db);
}
//# sourceMappingURL=1769105700133-AddAssetEditSequence.js.map