"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.JobService = void 0;
const common_1 = require("@nestjs/common");
const decorators_1 = require("../decorators");
const asset_response_dto_1 = require("../dtos/asset-response.dto");
const enum_1 = require("../enum");
const base_service_1 = require("./base.service");
const bytes_1 = require("../utils/bytes");
const asJobItem = (dto) => {
    switch (dto.name) {
        case enum_1.ManualJobName.TagCleanup: {
            return { name: enum_1.JobName.TagCleanup };
        }
        case enum_1.ManualJobName.PersonCleanup: {
            return { name: enum_1.JobName.PersonCleanup };
        }
        case enum_1.ManualJobName.UserCleanup: {
            return { name: enum_1.JobName.UserDeleteCheck };
        }
        case enum_1.ManualJobName.MemoryCleanup: {
            return { name: enum_1.JobName.MemoryCleanup };
        }
        case enum_1.ManualJobName.MemoryCreate: {
            return { name: enum_1.JobName.MemoryGenerate };
        }
        case enum_1.ManualJobName.BackupDatabase: {
            return { name: enum_1.JobName.DatabaseBackup };
        }
        default: {
            throw new common_1.BadRequestException('Invalid job name');
        }
    }
};
let JobService = class JobService extends base_service_1.BaseService {
    async create(dto) {
        await this.jobRepository.queue(asJobItem(dto));
    }
    async onJobRun(...[queueName, job]) {
        try {
            await this.eventRepository.emit('JobStart', queueName, job);
            const response = await this.jobRepository.run(job);
            await this.eventRepository.emit('JobSuccess', { job, response });
            if (response && typeof response === 'string' && [enum_1.JobStatus.Success, enum_1.JobStatus.Skipped].includes(response)) {
                await this.onDone(job);
            }
        }
        catch (error) {
            await this.eventRepository.emit('JobError', { job, error });
        }
        finally {
            await this.eventRepository.emit('JobComplete', queueName, job);
        }
    }
    async onDone(item) {
        switch (item.name) {
            case enum_1.JobName.SidecarCheck: {
                await this.jobRepository.queue({ name: enum_1.JobName.AssetExtractMetadata, data: item.data });
                break;
            }
            case enum_1.JobName.SidecarWrite: {
                await this.jobRepository.queue({
                    name: enum_1.JobName.AssetExtractMetadata,
                    data: { id: item.data.id, source: 'sidecar-write' },
                });
                break;
            }
            case enum_1.JobName.StorageTemplateMigrationSingle: {
                if (item.data.source === 'upload' || item.data.source === 'copy') {
                    await this.jobRepository.queue({ name: enum_1.JobName.AssetGenerateThumbnails, data: item.data });
                }
                break;
            }
            case enum_1.JobName.PersonGenerateThumbnail: {
                const { id } = item.data;
                const person = await this.personRepository.getById(id);
                if (person) {
                    this.websocketRepository.clientSend('on_person_thumbnail', person.ownerId, person.id);
                }
                break;
            }
            case enum_1.JobName.AssetEditThumbnailGeneration: {
                const asset = await this.assetRepository.getById(item.data.id);
                if (asset) {
                    this.websocketRepository.clientSend('AssetEditReadyV1', asset.ownerId, {
                        asset: {
                            id: asset.id,
                            ownerId: asset.ownerId,
                            originalFileName: asset.originalFileName,
                            thumbhash: asset.thumbhash ? (0, bytes_1.hexOrBufferToBase64)(asset.thumbhash) : null,
                            checksum: (0, bytes_1.hexOrBufferToBase64)(asset.checksum),
                            fileCreatedAt: asset.fileCreatedAt,
                            fileModifiedAt: asset.fileModifiedAt,
                            localDateTime: asset.localDateTime,
                            duration: asset.duration,
                            type: asset.type,
                            deletedAt: asset.deletedAt,
                            isFavorite: asset.isFavorite,
                            visibility: asset.visibility,
                            livePhotoVideoId: asset.livePhotoVideoId,
                            stackId: asset.stackId,
                            libraryId: asset.libraryId,
                            width: asset.width,
                            height: asset.height,
                            isEdited: asset.isEdited,
                        },
                    });
                }
                break;
            }
            case enum_1.JobName.AssetGenerateThumbnails: {
                if (!item.data.notify && item.data.source !== 'upload') {
                    break;
                }
                const [asset] = await this.assetRepository.getByIdsWithAllRelationsButStacks([item.data.id]);
                if (!asset) {
                    this.logger.warn(`Could not find asset ${item.data.id} after generating thumbnails`);
                    break;
                }
                const jobs = [
                    { name: enum_1.JobName.SmartSearch, data: item.data },
                    { name: enum_1.JobName.AssetDetectFaces, data: item.data },
                    { name: enum_1.JobName.Ocr, data: item.data },
                ];
                if (asset.type === enum_1.AssetType.Video) {
                    jobs.push({ name: enum_1.JobName.AssetEncodeVideo, data: item.data });
                }
                await this.jobRepository.queueAll(jobs);
                if (asset.visibility === enum_1.AssetVisibility.Timeline || asset.visibility === enum_1.AssetVisibility.Archive) {
                    this.websocketRepository.clientSend('on_upload_success', asset.ownerId, (0, asset_response_dto_1.mapAsset)(asset));
                    if (asset.exifInfo) {
                        const exif = asset.exifInfo;
                        this.websocketRepository.clientSend('AssetUploadReadyV1', asset.ownerId, {
                            asset: {
                                id: asset.id,
                                ownerId: asset.ownerId,
                                originalFileName: asset.originalFileName,
                                thumbhash: asset.thumbhash ? (0, bytes_1.hexOrBufferToBase64)(asset.thumbhash) : null,
                                checksum: (0, bytes_1.hexOrBufferToBase64)(asset.checksum),
                                fileCreatedAt: asset.fileCreatedAt,
                                fileModifiedAt: asset.fileModifiedAt,
                                localDateTime: asset.localDateTime,
                                duration: asset.duration,
                                type: asset.type,
                                deletedAt: asset.deletedAt,
                                isFavorite: asset.isFavorite,
                                visibility: asset.visibility,
                                livePhotoVideoId: asset.livePhotoVideoId,
                                stackId: asset.stackId,
                                libraryId: asset.libraryId,
                                width: asset.width,
                                height: asset.height,
                                isEdited: asset.isEdited,
                            },
                            exif: {
                                assetId: exif.assetId,
                                description: exif.description,
                                exifImageWidth: exif.exifImageWidth,
                                exifImageHeight: exif.exifImageHeight,
                                fileSizeInByte: exif.fileSizeInByte,
                                orientation: exif.orientation,
                                dateTimeOriginal: exif.dateTimeOriginal,
                                modifyDate: exif.modifyDate,
                                timeZone: exif.timeZone,
                                latitude: exif.latitude,
                                longitude: exif.longitude,
                                projectionType: exif.projectionType,
                                city: exif.city,
                                state: exif.state,
                                country: exif.country,
                                make: exif.make,
                                model: exif.model,
                                lensModel: exif.lensModel,
                                fNumber: exif.fNumber,
                                focalLength: exif.focalLength,
                                iso: exif.iso,
                                exposureTime: exif.exposureTime,
                                profileDescription: exif.profileDescription,
                                rating: exif.rating,
                                fps: exif.fps,
                            },
                        });
                    }
                }
                break;
            }
            case enum_1.JobName.SmartSearch: {
                if (item.data.source === 'upload') {
                    await this.jobRepository.queue({ name: enum_1.JobName.AssetDetectDuplicates, data: item.data });
                }
                break;
            }
        }
    }
};
exports.JobService = JobService;
__decorate([
    (0, decorators_1.OnEvent)({ name: 'JobRun' }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], JobService.prototype, "onJobRun", null);
exports.JobService = JobService = __decorate([
    (0, common_1.Injectable)()
], JobService);
//# sourceMappingURL=job.service.js.map