import { MaintenanceAuthDto, MaintenanceDetectInstallResponseDto, MaintenanceStatusResponseDto, SetMaintenanceModeDto } from 'src/dtos/maintenance.dto';
import { ArgOf } from 'src/repositories/event.repository';
import { BaseService } from 'src/services/base.service';
import { MaintenanceModeState } from 'src/types';
export declare class MaintenanceService extends BaseService {
    getMaintenanceMode(): Promise<MaintenanceModeState>;
    getMaintenanceStatus(): MaintenanceStatusResponseDto;
    detectPriorInstall(): Promise<MaintenanceDetectInstallResponseDto>;
    startMaintenance(action: SetMaintenanceModeDto, username: string): Promise<{
        jwt: string;
    }>;
    startRestoreFlow(): Promise<{
        jwt: string;
    }>;
    onRestart(event: ArgOf<'AppRestart'>, ack?: (ok: 'ok') => void): void;
    createLoginUrl(auth: MaintenanceAuthDto, secret?: string): Promise<string>;
}
