import { Exif } from 'src/database';
import { JobName, JobStatus } from 'src/enum';
import { BaseService } from 'src/services/base.service';
import { JobOf, VideoInterfaces } from 'src/types';
export declare class MediaService extends BaseService {
    videoInterfaces: VideoInterfaces;
    onBootstrap(): Promise<void>;
    handleQueueGenerateThumbnails({ force }: JobOf<JobName.AssetGenerateThumbnailsQueueAll>): Promise<JobStatus>;
    handleQueueMigration(): Promise<JobStatus>;
    handleAssetMigration({ id }: JobOf<JobName.AssetFileMigration>): Promise<JobStatus>;
    handleAssetEditThumbnailGeneration({ id }: JobOf<JobName.AssetEditThumbnailGeneration>): Promise<JobStatus>;
    handleGenerateThumbnails({ id }: JobOf<JobName.AssetGenerateThumbnails>): Promise<JobStatus>;
    private extractImage;
    private decodeImage;
    private extractOriginalImage;
    private generateImageThumbnails;
    handleGeneratePersonThumbnail({ id }: JobOf<JobName.PersonGenerateThumbnail>): Promise<JobStatus>;
    private getCrop;
    private generateVideoThumbnails;
    handleQueueVideoConversion(job: JobOf<JobName.AssetEncodeVideoQueueAll>): Promise<JobStatus>;
    handleVideoConversion({ id }: JobOf<JobName.AssetEncodeVideo>): Promise<JobStatus>;
    private getMainStream;
    private getTranscodeTarget;
    private isAudioTranscodeRequired;
    private isVideoTranscodeRequired;
    private isRemuxRequired;
    isSRGB({ colorspace, profileDescription, bitsPerSample }: Exif): boolean;
    private parseBitrateToBps;
    private shouldUseExtractedImage;
    private getDevices;
    private hasMaliOpenCL;
    private syncFiles;
    private generateEditedThumbnails;
    private getImageFile;
}
