"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.readFunctions = void 0;
const kysely_1 = require("kysely");
const readFunctions = async (ctx, db) => {
    const routines = await db
        .selectFrom('pg_proc as p')
        .innerJoin('pg_namespace', 'pg_namespace.oid', 'p.pronamespace')
        .leftJoin('pg_depend as d', (join) => join.onRef('d.objid', '=', 'p.oid').on('d.deptype', '=', kysely_1.sql.lit('e')))
        .where('d.objid', 'is', kysely_1.sql.lit(null))
        .where('p.prokind', '=', kysely_1.sql.lit('f'))
        .where('pg_namespace.nspname', '=', ctx.schemaName)
        .select((eb) => [
        'p.proname as name',
        eb.fn('pg_get_function_identity_arguments', ['p.oid']).as('arguments'),
        eb.fn('pg_get_functiondef', ['p.oid']).as('expression'),
    ])
        .execute();
    for (const { name, expression } of routines) {
        ctx.functions.push({
            name,
            expression,
            synchronize: true,
        });
    }
};
exports.readFunctions = readFunctions;
//# sourceMappingURL=function.reader.js.map