import { CacheControl } from 'src/enum';
import { MaintenanceHealthRepository } from 'src/maintenance/maintenance-health.repository';
import { ConfigRepository } from 'src/repositories/config.repository';
import { DatabaseRepository } from 'src/repositories/database.repository';
import { LoggingRepository } from 'src/repositories/logging.repository';
import { ProcessRepository } from 'src/repositories/process.repository';
import { StorageRepository } from 'src/repositories/storage.repository';
export declare function isValidDatabaseBackupName(filename: string): RegExpMatchArray | null;
export declare function isValidDatabaseRoutineBackupName(filename: string): RegExpMatchArray | null;
export declare function isFailedDatabaseBackupName(filename: string): RegExpMatchArray | null;
export declare function findVersion(filename: string): string | undefined;
type BackupRepos = {
    logger: LoggingRepository;
    storage: StorageRepository;
    config: ConfigRepository;
    process: ProcessRepository;
    database: DatabaseRepository;
    health: MaintenanceHealthRepository;
};
export declare class UnsupportedPostgresError extends Error {
    constructor(databaseVersion: string);
}
export declare function buildPostgresLaunchArguments({ logger, config, database }: Pick<BackupRepos, 'logger' | 'config' | 'database'>, bin: 'pg_dump' | 'pg_dumpall' | 'psql', options?: {
    singleTransaction?: boolean;
    username?: string;
}): Promise<{
    bin: string;
    args: string[];
    databasePassword: string;
    databaseVersion: string;
    databaseMajorVersion?: number;
}>;
export declare function createDatabaseBackup({ logger, storage, process: processRepository, ...pgRepos }: Omit<BackupRepos, 'health'>, filenamePrefix?: string): Promise<string>;
export declare function restoreDatabaseBackup({ logger, storage, process: processRepository, database: databaseRepository, health, ...pgRepos }: BackupRepos, filename: string, progressCb?: (action: 'backup' | 'restore' | 'migrations' | 'rollback', progress: number) => void): Promise<void>;
export declare function deleteDatabaseBackup({ storage }: Pick<BackupRepos, 'storage'>, files: string[]): Promise<void>;
export declare function listDatabaseBackups({ storage, }: Pick<BackupRepos, 'storage'>): Promise<{
    filename: string;
    filesize: number;
}[]>;
export declare function uploadDatabaseBackup({ storage }: Pick<BackupRepos, 'storage'>, file: Express.Multer.File): Promise<void>;
export declare function downloadDatabaseBackup(fileName: string): {
    path: string;
    fileName: string;
    cacheControl: CacheControl;
    contentType: string;
};
export {};
