import { AssetEditActionItem } from 'src/dtos/editing.dto';
import { AssetOcrResponseDto } from 'src/dtos/ocr.dto';
import { ImageDimensions } from 'src/types';
import { Matrix } from 'transformation-matrix';
export declare const getOutputDimensions: (edits: AssetEditActionItem[], startingDimensions: ImageDimensions) => ImageDimensions;
export declare const createAffineMatrix: (edits: AssetEditActionItem[], scalingParameters?: {
    pointSpace: ImageDimensions;
    targetSpace: ImageDimensions;
}) => Matrix;
type FaceBoundingBox = {
    boundingBoxX1: number;
    boundingBoxX2: number;
    boundingBoxY1: number;
    boundingBoxY2: number;
    imageWidth: number;
    imageHeight: number;
};
export declare const transformFaceBoundingBox: (box: FaceBoundingBox, edits: AssetEditActionItem[], imageDimensions: ImageDimensions) => FaceBoundingBox;
export declare const transformOcrBoundingBox: (box: AssetOcrResponseDto, edits: AssetEditActionItem[], imageDimensions: ImageDimensions) => AssetOcrResponseDto;
export {};
