/*
 * Copyright The OpenTelemetry Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
'use strict';
Object.defineProperty(exports, "__esModule", { value: true });
exports.InstrumentType = exports.ExporterDefaultHistogramAggregation = exports.ExporterTemporalityPreference = exports.ExemplarFilter = exports.initializeDefaultMeterProviderConfiguration = void 0;
function initializeDefaultMeterProviderConfiguration() {
    return {
        readers: [],
        exemplar_filter: ExemplarFilter.TraceBased,
    };
}
exports.initializeDefaultMeterProviderConfiguration = initializeDefaultMeterProviderConfiguration;
var ExemplarFilter;
(function (ExemplarFilter) {
    ExemplarFilter["AlwaysOff"] = "always_off";
    ExemplarFilter["AlwaysOn"] = "always_on";
    ExemplarFilter["TraceBased"] = "trace_based";
})(ExemplarFilter = exports.ExemplarFilter || (exports.ExemplarFilter = {}));
var ExporterTemporalityPreference;
(function (ExporterTemporalityPreference) {
    ExporterTemporalityPreference["Cumulative"] = "cumulative";
    ExporterTemporalityPreference["Delta"] = "delta";
    ExporterTemporalityPreference["LowMemory"] = "low_memory";
})(ExporterTemporalityPreference = exports.ExporterTemporalityPreference || (exports.ExporterTemporalityPreference = {}));
var ExporterDefaultHistogramAggregation;
(function (ExporterDefaultHistogramAggregation) {
    ExporterDefaultHistogramAggregation["Base2ExponentialBucketHistogram"] = "base2_exponential_bucket_histogram";
    ExporterDefaultHistogramAggregation["ExplicitBucketHistogram"] = "explicit_bucket_histogram";
})(ExporterDefaultHistogramAggregation = exports.ExporterDefaultHistogramAggregation || (exports.ExporterDefaultHistogramAggregation = {}));
var InstrumentType;
(function (InstrumentType) {
    InstrumentType["Counter"] = "counter";
    InstrumentType["Gauge"] = "gauge";
    InstrumentType["Histogram"] = "histogram";
    InstrumentType["ObservableCounter"] = "observable_counter";
    InstrumentType["ObservableGauge"] = "observable_gauge";
    InstrumentType["ObservableUpDownCounter"] = "observable_up_down_counter";
    InstrumentType["UpDownCounter"] = "up_down_counter";
})(InstrumentType = exports.InstrumentType || (exports.InstrumentType = {}));
//# sourceMappingURL=meterProviderModel.js.map