import { ExifToolOptions } from "./ExifToolOptions";
import { ExifToolTask } from "./ExifToolTask";
import { Maybe } from "./Maybe";
export type BinaryExtractionTaskOptions = Pick<ExifToolOptions, "ignoreMinorErrors"> & Partial<Pick<ExifToolOptions, "forceWrite">>;
/**
 * Task that returns an error string (to prevent retries), or undefined if
 * everything seems to have worked.
 */
export declare class BinaryExtractionTask extends ExifToolTask<Maybe<string>> {
    private constructor();
    /**
     * Creates a task to extract a binary tag value to a file.
     * @param tagname the tag containing the binary data (e.g., "ThumbnailImage", "PreviewImage")
     * @param imgSrc the source image file path
     * @param imgDest the destination file path for the extracted binary data
     * @param options extraction options
     * @returns a new BinaryExtractionTask instance
     */
    static for(tagname: string, imgSrc: string, imgDest: string, options?: BinaryExtractionTaskOptions): BinaryExtractionTask;
    parse(stdout: string, err?: Error): Maybe<string>;
}
