import { Maybe } from "./Maybe";
/**
 * Represents a binary field in the Exif data.
 *
 * These fields can be used to store images (including thumbnails and full-sized
 * images), audio, and other binary data. The size of the field is specified in
 * bytes.
 */
export declare class BinaryField {
    readonly bytes: number;
    readonly rawValue: string;
    constructor(bytes: number, rawValue: string);
    toJSON(): {
        _ctor: string;
        bytes: number;
        rawValue: string;
    };
    static fromJSON(json: ReturnType<BinaryField["toJSON"]>): BinaryField;
    static fromRawValue(rawValue: string): Maybe<BinaryField>;
}
