"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.errorsAndWarnings = errorsAndWarnings;
exports.toError = toError;
const Array_1 = require("./Array");
const String_1 = require("./String");
function errorsAndWarnings(task, t) {
    return {
        errors: (0, Array_1.uniq)((0, String_1.compactBlanks)([t?.Error, ...task.errors])),
        warnings: (0, Array_1.uniq)((0, String_1.compactBlanks)([t?.Warning, ...task.warnings])),
    };
}
/**
 * Convert an unknown value to an Error.
 */
function toError(e, messageIfBlank = "Unknown error") {
    return e instanceof Error
        ? e
        : new Error((0, String_1.toNotBlank)((0, String_1.toS)(e)) ?? messageIfBlank);
}
//# sourceMappingURL=ErrorsAndWarnings.js.map