export type Json = Literal | {
    [key: string]: Json;
} | Json[];
export type Literal = string | number | boolean | bigint | null;
/**
 * Parses a JSON string into an object, reviving the custom types defined in the Revivers map.
 *
 * - {@link BinaryField} is revived using {@link BinaryField.fromJSON}
 * - {@link ExifDateTime} is revived using {@link ExifDateTime.fromJSON}
 * - {@link ExifDate} is revived using {@link ExifDate.fromJSON}
 * - {@link ExifTime} is revived using {@link ExifTime.fromJSON}
 */
export declare function parseJSON(s: string): any;
