import { INestApplicationContext, Type } from '@nestjs/common';
import { DynamicModule, ModuleMetadata } from '@nestjs/common/interfaces';
import { CommanderOptionsType, CommandFactoryRunOptions, DefinedCommandFactoryRunOptions, NestLogger } from './command-factory.interface';
export declare class CommandFactory {
    static run(rootModule: Type<any> | DynamicModule, optionsOrLogger?: CommandFactoryRunOptions | NestLogger): Promise<void>;
    static runWithoutClosing(rootModule: Type<any> | DynamicModule, optionsOrLogger?: CommandFactoryRunOptions | NestLogger): Promise<INestApplicationContext>;
    static createWithoutRunning(rootModule: Type<any> | DynamicModule, optionsOrLogger?: CommandFactoryRunOptions | NestLogger): Promise<INestApplicationContext>;
    static runApplication(app: INestApplicationContext): Promise<INestApplicationContext>;
    protected static createCommandModule(imports: ModuleMetadata['imports'], options: CommanderOptionsType): DynamicModule;
    protected static getOptions(optionsOrLogger: CommandFactoryRunOptions | NestLogger): DefinedCommandFactoryRunOptions;
    protected static isFactoryOptionsObject(loggerOrOptions: CommandFactoryRunOptions | NestLogger): loggerOrOptions is CommandFactoryRunOptions;
    protected static registerPlugins(cliName: string, imports: ModuleMetadata['imports']): Promise<boolean>;
}
