"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UseCls = UseCls;
require("reflect-metadata");
const copy_method_metadata_1 = require("../../utils/copy-method-metadata");
const cls_service_manager_1 = require("../cls-service-manager");
const cls_constants_1 = require("../cls.constants");
const cls_options_1 = require("../cls.options");
function UseCls(maybeOptions) {
    return (target, propertyKey, descriptor) => {
        const options = { ...new cls_options_1.ClsDecoratorOptions(), ...maybeOptions };
        const cls = cls_service_manager_1.ClsServiceManager.getClsService();
        const original = descriptor.value;
        if (typeof original !== 'function') {
            throw new Error(`The @UseCls decorator can be only used on functions, but ${propertyKey.toString()} is not a function.`);
        }
        descriptor.value = function (...args) {
            return cls.run(options.runOptions ?? {}, async () => {
                if (options.generateId) {
                    const id = await options.idGenerator?.apply(this, args);
                    cls.set(cls_constants_1.CLS_ID, id);
                }
                if (options.setup) {
                    await options.setup.apply(this, [cls, ...args]);
                }
                if (options.initializePlugins) {
                    await cls.initializePlugins();
                }
                if (options.resolveProxyProviders) {
                    await cls.resolveProxyProviders();
                }
                return original.apply(this, args);
            });
        };
        (0, copy_method_metadata_1.copyMethodMetadata)(original, descriptor.value);
    };
}
//# sourceMappingURL=use-cls.decorator.js.map