import { ExecutionContext } from '@nestjs/common';
import { ClsStore } from '../../cls.options';
/**
 * This static class can be used to save the CLS store in a WeakMap based on the ExecutionContext
 * or any object that is passed to the `setByRawContext` method.
 *
 * It is used internally by the `ClsMiddleware`, `ClsInterceptor` and `ClsGuard` to prevent
 * instantiating the context multiple times for the same request.
 *
 * It can also be used as an escape hatch to retrieve the CLS store based on the ExecutionContext
 * or the "raw context" when the ExecutionContext is not available.
 * * For HTTP, it is the Request (@Req) object
 * * For WS, it is the data object
 * * For RPC (microservices), it is the RpcContext (@Ctx) object
 * * For GraphQL, it is the GqlContext object
 */
export declare class ContextClsStoreMap {
    private static readonly contextMap;
    private constructor();
    static set(context: ExecutionContext, value: ClsStore): void;
    static get(context: ExecutionContext): ClsStore | undefined;
    static setByRaw(ctx: any, value: ClsStore): void;
    static getByRaw(ctx: any): ClsStore | undefined;
    private static getContextByType;
}
//# sourceMappingURL=context-cls-store-map.d.ts.map