import { OtelMetricOptions } from '../../interfaces/metric-options.interface';
/**
 * Create and increment a counter when a new instance is created
 *
 * @param originalClass
 */
export declare const OtelInstanceCounter: (options?: OtelMetricOptions) => <T extends {
    new (...args: any[]): {};
}>(originalClass: T) => {
    new (...args: any[]): {};
} & T;
/**
 * Create and increment a counter when the method is called
 */
export declare const OtelMethodCounter: (options?: OtelMetricOptions) => (target: Object, propertyKey: string | symbol, descriptor: TypedPropertyDescriptor<(...args: any[]) => any>) => void;
