import { AssetResponseDto } from 'src/dtos/asset-response.dto';
import { AssetBulkDeleteDto, AssetBulkUpdateDto, AssetCopyDto, AssetJobsDto, AssetMetadataBulkDeleteDto, AssetMetadataBulkResponseDto, AssetMetadataBulkUpsertDto, AssetMetadataResponseDto, AssetMetadataRouteParams, AssetMetadataUpsertDto, AssetStatsDto, AssetStatsResponseDto, DeviceIdDto, RandomAssetsDto, UpdateAssetDto } from 'src/dtos/asset.dto';
import { AuthDto } from 'src/dtos/auth.dto';
import { AssetEditActionListDto, AssetEditsDto } from 'src/dtos/editing.dto';
import { AssetOcrResponseDto } from 'src/dtos/ocr.dto';
import { AssetService } from 'src/services/asset.service';
import { UUIDParamDto } from 'src/validation';
export declare class AssetController {
    private service;
    constructor(service: AssetService);
    getRandom(auth: AuthDto, dto: RandomAssetsDto): Promise<AssetResponseDto[]>;
    getAllUserAssetsByDeviceId(auth: AuthDto, { deviceId }: DeviceIdDto): Promise<string[]>;
    getAssetStatistics(auth: AuthDto, dto: AssetStatsDto): Promise<AssetStatsResponseDto>;
    runAssetJobs(auth: AuthDto, dto: AssetJobsDto): Promise<void>;
    updateAssets(auth: AuthDto, dto: AssetBulkUpdateDto): Promise<void>;
    deleteAssets(auth: AuthDto, dto: AssetBulkDeleteDto): Promise<void>;
    getAssetInfo(auth: AuthDto, { id }: UUIDParamDto): Promise<AssetResponseDto>;
    copyAsset(auth: AuthDto, dto: AssetCopyDto): Promise<void>;
    updateBulkAssetMetadata(auth: AuthDto, dto: AssetMetadataBulkUpsertDto): Promise<AssetMetadataBulkResponseDto[]>;
    deleteBulkAssetMetadata(auth: AuthDto, dto: AssetMetadataBulkDeleteDto): Promise<void>;
    updateAsset(auth: AuthDto, { id }: UUIDParamDto, dto: UpdateAssetDto): Promise<AssetResponseDto>;
    getAssetMetadata(auth: AuthDto, { id }: UUIDParamDto): Promise<AssetMetadataResponseDto[]>;
    getAssetOcr(auth: AuthDto, { id }: UUIDParamDto): Promise<AssetOcrResponseDto[]>;
    updateAssetMetadata(auth: AuthDto, { id }: UUIDParamDto, dto: AssetMetadataUpsertDto): Promise<AssetMetadataResponseDto[]>;
    getAssetMetadataByKey(auth: AuthDto, { id, key }: AssetMetadataRouteParams): Promise<AssetMetadataResponseDto>;
    deleteAssetMetadata(auth: AuthDto, { id, key }: AssetMetadataRouteParams): Promise<void>;
    getAssetEdits(auth: AuthDto, { id }: UUIDParamDto): Promise<AssetEditsDto>;
    editAsset(auth: AuthDto, { id }: UUIDParamDto, dto: AssetEditActionListDto): Promise<AssetEditsDto>;
    removeAssetEdits(auth: AuthDto, { id }: UUIDParamDto): Promise<void>;
}
