"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.mapStats = exports.AssetDownloadOriginalDto = exports.AssetCopyDto = exports.AssetMetadataBulkResponseDto = exports.AssetMetadataResponseDto = exports.AssetMetadataBulkDeleteItemDto = exports.AssetMetadataBulkDeleteDto = exports.AssetMetadataBulkUpsertItemDto = exports.AssetMetadataBulkUpsertDto = exports.AssetMetadataUpsertItemDto = exports.AssetMetadataUpsertDto = exports.AssetMetadataRouteParams = exports.AssetStatsResponseDto = exports.AssetStatsDto = exports.AssetJobsDto = exports.AssetJobName = exports.AssetIdsDto = exports.AssetBulkDeleteDto = exports.RandomAssetsDto = exports.UpdateAssetDto = exports.AssetBulkUpdateDto = exports.UpdateAssetBase = exports.DeviceIdDto = void 0;
const openapi = require("@nestjs/swagger");
const swagger_1 = require("@nestjs/swagger");
const class_transformer_1 = require("class-transformer");
const class_validator_1 = require("class-validator");
const asset_ids_response_dto_1 = require("./asset-ids.response.dto");
const enum_1 = require("../enum");
const validation_1 = require("../validation");
class DeviceIdDto {
    deviceId;
    static _OPENAPI_METADATA_FACTORY() {
        return { deviceId: { required: true, type: () => String } };
    }
}
exports.DeviceIdDto = DeviceIdDto;
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Device ID' }),
    (0, class_validator_1.IsNotEmpty)(),
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], DeviceIdDto.prototype, "deviceId", void 0);
const hasGPS = (o) => o.latitude !== undefined || o.longitude !== undefined;
const ValidateGPS = () => (0, class_validator_1.ValidateIf)(hasGPS);
class UpdateAssetBase {
    isFavorite;
    visibility;
    dateTimeOriginal;
    latitude;
    longitude;
    rating;
    description;
    static _OPENAPI_METADATA_FACTORY() {
        return { isFavorite: { required: false, type: () => Boolean }, visibility: { required: false, enum: require("../enum").AssetVisibility }, dateTimeOriginal: { required: false, type: () => String }, latitude: { required: false, type: () => Number }, longitude: { required: false, type: () => Number }, rating: { required: false, type: () => Number, minimum: -1, maximum: 5 }, description: { required: false, type: () => String } };
    }
}
exports.UpdateAssetBase = UpdateAssetBase;
__decorate([
    (0, validation_1.ValidateBoolean)({ optional: true, description: 'Mark as favorite' }),
    __metadata("design:type", Boolean)
], UpdateAssetBase.prototype, "isFavorite", void 0);
__decorate([
    (0, validation_1.ValidateEnum)({ enum: enum_1.AssetVisibility, name: 'AssetVisibility', optional: true, description: 'Asset visibility' }),
    __metadata("design:type", String)
], UpdateAssetBase.prototype, "visibility", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Original date and time' }),
    (0, validation_1.Optional)(),
    (0, class_validator_1.IsDateString)(),
    __metadata("design:type", String)
], UpdateAssetBase.prototype, "dateTimeOriginal", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Latitude coordinate' }),
    ValidateGPS(),
    (0, class_validator_1.IsLatitude)(),
    (0, class_validator_1.IsNotEmpty)(),
    __metadata("design:type", Number)
], UpdateAssetBase.prototype, "latitude", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Longitude coordinate' }),
    ValidateGPS(),
    (0, class_validator_1.IsLongitude)(),
    (0, class_validator_1.IsNotEmpty)(),
    __metadata("design:type", Number)
], UpdateAssetBase.prototype, "longitude", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Rating' }),
    (0, validation_1.Optional)(),
    (0, class_validator_1.IsInt)(),
    (0, class_validator_1.Max)(5),
    (0, class_validator_1.Min)(-1),
    __metadata("design:type", Number)
], UpdateAssetBase.prototype, "rating", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Asset description' }),
    (0, validation_1.Optional)(),
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], UpdateAssetBase.prototype, "description", void 0);
class AssetBulkUpdateDto extends UpdateAssetBase {
    ids;
    duplicateId;
    dateTimeRelative;
    timeZone;
    static _OPENAPI_METADATA_FACTORY() {
        return { ids: { required: true, type: () => [String] }, duplicateId: { required: false, type: () => String, nullable: true }, dateTimeRelative: { required: false, type: () => Number }, timeZone: { required: false, type: () => String } };
    }
}
exports.AssetBulkUpdateDto = AssetBulkUpdateDto;
__decorate([
    (0, validation_1.ValidateUUID)({ each: true, description: 'Asset IDs to update' }),
    __metadata("design:type", Array)
], AssetBulkUpdateDto.prototype, "ids", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Duplicate asset ID' }),
    (0, validation_1.Optional)(),
    __metadata("design:type", Object)
], AssetBulkUpdateDto.prototype, "duplicateId", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Relative time offset in seconds' }),
    (0, validation_1.IsNotSiblingOf)(['dateTimeOriginal']),
    (0, validation_1.Optional)(),
    (0, class_validator_1.IsInt)(),
    __metadata("design:type", Number)
], AssetBulkUpdateDto.prototype, "dateTimeRelative", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Time zone (IANA timezone)' }),
    (0, validation_1.IsNotSiblingOf)(['dateTimeOriginal']),
    (0, class_validator_1.IsTimeZone)(),
    (0, validation_1.Optional)(),
    __metadata("design:type", String)
], AssetBulkUpdateDto.prototype, "timeZone", void 0);
class UpdateAssetDto extends UpdateAssetBase {
    livePhotoVideoId;
    static _OPENAPI_METADATA_FACTORY() {
        return { livePhotoVideoId: { required: false, type: () => String, nullable: true } };
    }
}
exports.UpdateAssetDto = UpdateAssetDto;
__decorate([
    (0, validation_1.ValidateUUID)({ optional: true, nullable: true, description: 'Live photo video ID' }),
    __metadata("design:type", Object)
], UpdateAssetDto.prototype, "livePhotoVideoId", void 0);
class RandomAssetsDto {
    count;
    static _OPENAPI_METADATA_FACTORY() {
        return { count: { required: false, type: () => Number, minimum: 1 } };
    }
}
exports.RandomAssetsDto = RandomAssetsDto;
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Number of random assets to return' }),
    (0, validation_1.Optional)(),
    (0, class_validator_1.IsInt)(),
    (0, class_validator_1.IsPositive)(),
    (0, class_transformer_1.Type)(() => Number),
    __metadata("design:type", Number)
], RandomAssetsDto.prototype, "count", void 0);
class AssetBulkDeleteDto extends asset_ids_response_dto_1.BulkIdsDto {
    force;
    static _OPENAPI_METADATA_FACTORY() {
        return { force: { required: false, type: () => Boolean } };
    }
}
exports.AssetBulkDeleteDto = AssetBulkDeleteDto;
__decorate([
    (0, validation_1.ValidateBoolean)({ optional: true, description: 'Force delete even if in use' }),
    __metadata("design:type", Boolean)
], AssetBulkDeleteDto.prototype, "force", void 0);
class AssetIdsDto {
    assetIds;
    static _OPENAPI_METADATA_FACTORY() {
        return { assetIds: { required: true, type: () => [String] } };
    }
}
exports.AssetIdsDto = AssetIdsDto;
__decorate([
    (0, validation_1.ValidateUUID)({ each: true, description: 'Asset IDs' }),
    __metadata("design:type", Array)
], AssetIdsDto.prototype, "assetIds", void 0);
var AssetJobName;
(function (AssetJobName) {
    AssetJobName["REFRESH_FACES"] = "refresh-faces";
    AssetJobName["REFRESH_METADATA"] = "refresh-metadata";
    AssetJobName["REGENERATE_THUMBNAIL"] = "regenerate-thumbnail";
    AssetJobName["TRANSCODE_VIDEO"] = "transcode-video";
})(AssetJobName || (exports.AssetJobName = AssetJobName = {}));
class AssetJobsDto extends AssetIdsDto {
    name;
    static _OPENAPI_METADATA_FACTORY() {
        return { name: { required: true, enum: require("./asset.dto").AssetJobName } };
    }
}
exports.AssetJobsDto = AssetJobsDto;
__decorate([
    (0, validation_1.ValidateEnum)({ enum: AssetJobName, name: 'AssetJobName', description: 'Job name' }),
    __metadata("design:type", String)
], AssetJobsDto.prototype, "name", void 0);
class AssetStatsDto {
    visibility;
    isFavorite;
    isTrashed;
    static _OPENAPI_METADATA_FACTORY() {
        return { visibility: { required: false, enum: require("../enum").AssetVisibility }, isFavorite: { required: false, type: () => Boolean }, isTrashed: { required: false, type: () => Boolean } };
    }
}
exports.AssetStatsDto = AssetStatsDto;
__decorate([
    (0, validation_1.ValidateEnum)({ enum: enum_1.AssetVisibility, name: 'AssetVisibility', description: 'Filter by visibility', optional: true }),
    __metadata("design:type", String)
], AssetStatsDto.prototype, "visibility", void 0);
__decorate([
    (0, validation_1.ValidateBoolean)({ optional: true, description: 'Filter by favorite status' }),
    __metadata("design:type", Boolean)
], AssetStatsDto.prototype, "isFavorite", void 0);
__decorate([
    (0, validation_1.ValidateBoolean)({ optional: true, description: 'Filter by trash status' }),
    __metadata("design:type", Boolean)
], AssetStatsDto.prototype, "isTrashed", void 0);
class AssetStatsResponseDto {
    images;
    videos;
    total;
    static _OPENAPI_METADATA_FACTORY() {
        return { images: { required: true, type: () => Number }, videos: { required: true, type: () => Number }, total: { required: true, type: () => Number } };
    }
}
exports.AssetStatsResponseDto = AssetStatsResponseDto;
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Number of images', type: 'integer' }),
    __metadata("design:type", Number)
], AssetStatsResponseDto.prototype, "images", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Number of videos', type: 'integer' }),
    __metadata("design:type", Number)
], AssetStatsResponseDto.prototype, "videos", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Total number of assets', type: 'integer' }),
    __metadata("design:type", Number)
], AssetStatsResponseDto.prototype, "total", void 0);
class AssetMetadataRouteParams {
    id;
    key;
    static _OPENAPI_METADATA_FACTORY() {
        return { id: { required: true, type: () => String }, key: { required: true, type: () => String } };
    }
}
exports.AssetMetadataRouteParams = AssetMetadataRouteParams;
__decorate([
    (0, validation_1.ValidateUUID)({ description: 'Asset ID' }),
    __metadata("design:type", String)
], AssetMetadataRouteParams.prototype, "id", void 0);
__decorate([
    (0, validation_1.ValidateString)({ description: 'Metadata key' }),
    __metadata("design:type", String)
], AssetMetadataRouteParams.prototype, "key", void 0);
class AssetMetadataUpsertDto {
    items;
    static _OPENAPI_METADATA_FACTORY() {
        return { items: { required: true, type: () => [require("./asset.dto").AssetMetadataUpsertItemDto] } };
    }
}
exports.AssetMetadataUpsertDto = AssetMetadataUpsertDto;
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Metadata items to upsert' }),
    (0, class_validator_1.IsArray)(),
    (0, class_validator_1.ValidateNested)({ each: true }),
    (0, class_transformer_1.Type)(() => AssetMetadataUpsertItemDto),
    __metadata("design:type", Array)
], AssetMetadataUpsertDto.prototype, "items", void 0);
class AssetMetadataUpsertItemDto {
    key;
    value;
    static _OPENAPI_METADATA_FACTORY() {
        return { key: { required: true, type: () => String }, value: { required: true, type: () => Object } };
    }
}
exports.AssetMetadataUpsertItemDto = AssetMetadataUpsertItemDto;
__decorate([
    (0, validation_1.ValidateString)({ description: 'Metadata key' }),
    __metadata("design:type", String)
], AssetMetadataUpsertItemDto.prototype, "key", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Metadata value (object)' }),
    (0, class_validator_1.IsObject)(),
    __metadata("design:type", Object)
], AssetMetadataUpsertItemDto.prototype, "value", void 0);
class AssetMetadataBulkUpsertDto {
    items;
    static _OPENAPI_METADATA_FACTORY() {
        return { items: { required: true, type: () => [require("./asset.dto").AssetMetadataBulkUpsertItemDto] } };
    }
}
exports.AssetMetadataBulkUpsertDto = AssetMetadataBulkUpsertDto;
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Metadata items to upsert' }),
    (0, class_validator_1.IsArray)(),
    (0, class_validator_1.ValidateNested)({ each: true }),
    (0, class_transformer_1.Type)(() => AssetMetadataBulkUpsertItemDto),
    __metadata("design:type", Array)
], AssetMetadataBulkUpsertDto.prototype, "items", void 0);
class AssetMetadataBulkUpsertItemDto {
    assetId;
    key;
    value;
    static _OPENAPI_METADATA_FACTORY() {
        return { assetId: { required: true, type: () => String }, key: { required: true, type: () => String }, value: { required: true, type: () => Object } };
    }
}
exports.AssetMetadataBulkUpsertItemDto = AssetMetadataBulkUpsertItemDto;
__decorate([
    (0, validation_1.ValidateUUID)({ description: 'Asset ID' }),
    __metadata("design:type", String)
], AssetMetadataBulkUpsertItemDto.prototype, "assetId", void 0);
__decorate([
    (0, validation_1.ValidateString)({ description: 'Metadata key' }),
    __metadata("design:type", String)
], AssetMetadataBulkUpsertItemDto.prototype, "key", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Metadata value (object)' }),
    (0, class_validator_1.IsObject)(),
    __metadata("design:type", Object)
], AssetMetadataBulkUpsertItemDto.prototype, "value", void 0);
class AssetMetadataBulkDeleteDto {
    items;
    static _OPENAPI_METADATA_FACTORY() {
        return { items: { required: true, type: () => [require("./asset.dto").AssetMetadataBulkDeleteItemDto] } };
    }
}
exports.AssetMetadataBulkDeleteDto = AssetMetadataBulkDeleteDto;
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Metadata items to delete' }),
    (0, class_validator_1.IsArray)(),
    (0, class_validator_1.ValidateNested)({ each: true }),
    (0, class_transformer_1.Type)(() => AssetMetadataBulkDeleteItemDto),
    __metadata("design:type", Array)
], AssetMetadataBulkDeleteDto.prototype, "items", void 0);
class AssetMetadataBulkDeleteItemDto {
    assetId;
    key;
    static _OPENAPI_METADATA_FACTORY() {
        return { assetId: { required: true, type: () => String }, key: { required: true, type: () => String } };
    }
}
exports.AssetMetadataBulkDeleteItemDto = AssetMetadataBulkDeleteItemDto;
__decorate([
    (0, validation_1.ValidateUUID)({ description: 'Asset ID' }),
    __metadata("design:type", String)
], AssetMetadataBulkDeleteItemDto.prototype, "assetId", void 0);
__decorate([
    (0, validation_1.ValidateString)({ description: 'Metadata key' }),
    __metadata("design:type", String)
], AssetMetadataBulkDeleteItemDto.prototype, "key", void 0);
class AssetMetadataResponseDto {
    key;
    value;
    updatedAt;
    static _OPENAPI_METADATA_FACTORY() {
        return { key: { required: true, type: () => String }, value: { required: true, type: () => Object }, updatedAt: { required: true, type: () => Date } };
    }
}
exports.AssetMetadataResponseDto = AssetMetadataResponseDto;
__decorate([
    (0, validation_1.ValidateString)({ description: 'Metadata key' }),
    __metadata("design:type", String)
], AssetMetadataResponseDto.prototype, "key", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Metadata value (object)' }),
    __metadata("design:type", Object)
], AssetMetadataResponseDto.prototype, "value", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Last update date' }),
    __metadata("design:type", Date)
], AssetMetadataResponseDto.prototype, "updatedAt", void 0);
class AssetMetadataBulkResponseDto extends AssetMetadataResponseDto {
    assetId;
    static _OPENAPI_METADATA_FACTORY() {
        return { assetId: { required: true, type: () => String } };
    }
}
exports.AssetMetadataBulkResponseDto = AssetMetadataBulkResponseDto;
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Asset ID' }),
    __metadata("design:type", String)
], AssetMetadataBulkResponseDto.prototype, "assetId", void 0);
class AssetCopyDto {
    sourceId;
    targetId;
    sharedLinks;
    albums;
    sidecar;
    stack;
    favorite;
    static _OPENAPI_METADATA_FACTORY() {
        return { sourceId: { required: true, type: () => String }, targetId: { required: true, type: () => String }, sharedLinks: { required: false, type: () => Boolean }, albums: { required: false, type: () => Boolean }, sidecar: { required: false, type: () => Boolean }, stack: { required: false, type: () => Boolean }, favorite: { required: false, type: () => Boolean } };
    }
}
exports.AssetCopyDto = AssetCopyDto;
__decorate([
    (0, validation_1.ValidateUUID)({ description: 'Source asset ID' }),
    __metadata("design:type", String)
], AssetCopyDto.prototype, "sourceId", void 0);
__decorate([
    (0, validation_1.ValidateUUID)({ description: 'Target asset ID' }),
    __metadata("design:type", String)
], AssetCopyDto.prototype, "targetId", void 0);
__decorate([
    (0, validation_1.ValidateBoolean)({ optional: true, description: 'Copy shared links', default: true }),
    __metadata("design:type", Boolean)
], AssetCopyDto.prototype, "sharedLinks", void 0);
__decorate([
    (0, validation_1.ValidateBoolean)({ optional: true, description: 'Copy album associations', default: true }),
    __metadata("design:type", Boolean)
], AssetCopyDto.prototype, "albums", void 0);
__decorate([
    (0, validation_1.ValidateBoolean)({ optional: true, description: 'Copy sidecar file', default: true }),
    __metadata("design:type", Boolean)
], AssetCopyDto.prototype, "sidecar", void 0);
__decorate([
    (0, validation_1.ValidateBoolean)({ optional: true, description: 'Copy stack association', default: true }),
    __metadata("design:type", Boolean)
], AssetCopyDto.prototype, "stack", void 0);
__decorate([
    (0, validation_1.ValidateBoolean)({ optional: true, description: 'Copy favorite status', default: true }),
    __metadata("design:type", Boolean)
], AssetCopyDto.prototype, "favorite", void 0);
class AssetDownloadOriginalDto {
    edited;
    static _OPENAPI_METADATA_FACTORY() {
        return { edited: { required: false, type: () => Boolean } };
    }
}
exports.AssetDownloadOriginalDto = AssetDownloadOriginalDto;
__decorate([
    (0, validation_1.ValidateBoolean)({ optional: true, description: 'Return edited asset if available', default: false }),
    __metadata("design:type", Boolean)
], AssetDownloadOriginalDto.prototype, "edited", void 0);
const mapStats = (stats) => {
    return {
        images: stats[enum_1.AssetType.Image],
        videos: stats[enum_1.AssetType.Video],
        total: Object.values(stats).reduce((total, value) => total + value, 0),
    };
};
exports.mapStats = mapStats;
//# sourceMappingURL=asset.dto.js.map