"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.mapNotification = exports.NotificationDeleteAllDto = exports.NotificationUpdateAllDto = exports.NotificationUpdateDto = exports.NotificationCreateDto = exports.NotificationSearchDto = exports.NotificationDto = exports.TemplateDto = exports.TemplateResponseDto = exports.TestEmailResponseDto = void 0;
const openapi = require("@nestjs/swagger");
const swagger_1 = require("@nestjs/swagger");
const class_validator_1 = require("class-validator");
const enum_1 = require("../enum");
const validation_1 = require("../validation");
class TestEmailResponseDto {
    messageId;
    static _OPENAPI_METADATA_FACTORY() {
        return { messageId: { required: true, type: () => String } };
    }
}
exports.TestEmailResponseDto = TestEmailResponseDto;
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Email message ID' }),
    __metadata("design:type", String)
], TestEmailResponseDto.prototype, "messageId", void 0);
class TemplateResponseDto {
    name;
    html;
    static _OPENAPI_METADATA_FACTORY() {
        return { name: { required: true, type: () => String }, html: { required: true, type: () => String } };
    }
}
exports.TemplateResponseDto = TemplateResponseDto;
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Template name' }),
    __metadata("design:type", String)
], TemplateResponseDto.prototype, "name", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Template HTML content' }),
    __metadata("design:type", String)
], TemplateResponseDto.prototype, "html", void 0);
class TemplateDto {
    template;
    static _OPENAPI_METADATA_FACTORY() {
        return { template: { required: true, type: () => String } };
    }
}
exports.TemplateDto = TemplateDto;
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Template name' }),
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], TemplateDto.prototype, "template", void 0);
class NotificationDto {
    id;
    createdAt;
    level;
    type;
    title;
    description;
    data;
    readAt;
    static _OPENAPI_METADATA_FACTORY() {
        return { id: { required: true, type: () => String }, createdAt: { required: true, type: () => Date }, level: { required: true, enum: require("../enum").NotificationLevel }, type: { required: true, enum: require("../enum").NotificationType }, title: { required: true, type: () => String }, description: { required: false, type: () => String }, data: { required: false, type: () => Object }, readAt: { required: false, type: () => Date } };
    }
}
exports.NotificationDto = NotificationDto;
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Notification ID' }),
    __metadata("design:type", String)
], NotificationDto.prototype, "id", void 0);
__decorate([
    (0, validation_1.ValidateDate)({ description: 'Creation date' }),
    __metadata("design:type", Date)
], NotificationDto.prototype, "createdAt", void 0);
__decorate([
    (0, validation_1.ValidateEnum)({ enum: enum_1.NotificationLevel, name: 'NotificationLevel', description: 'Notification level' }),
    __metadata("design:type", String)
], NotificationDto.prototype, "level", void 0);
__decorate([
    (0, validation_1.ValidateEnum)({ enum: enum_1.NotificationType, name: 'NotificationType', description: 'Notification type' }),
    __metadata("design:type", String)
], NotificationDto.prototype, "type", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Notification title' }),
    __metadata("design:type", String)
], NotificationDto.prototype, "title", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: 'Notification description' }),
    __metadata("design:type", String)
], NotificationDto.prototype, "description", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: 'Additional notification data' }),
    __metadata("design:type", Object)
], NotificationDto.prototype, "data", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: 'Date when notification was read', format: 'date-time' }),
    __metadata("design:type", Date)
], NotificationDto.prototype, "readAt", void 0);
class NotificationSearchDto {
    id;
    level;
    type;
    unread;
    static _OPENAPI_METADATA_FACTORY() {
        return { id: { required: false, type: () => String }, level: { required: false, enum: require("../enum").NotificationLevel }, type: { required: false, enum: require("../enum").NotificationType }, unread: { required: false, type: () => Boolean } };
    }
}
exports.NotificationSearchDto = NotificationSearchDto;
__decorate([
    (0, validation_1.ValidateUUID)({ optional: true, description: 'Filter by notification ID' }),
    __metadata("design:type", String)
], NotificationSearchDto.prototype, "id", void 0);
__decorate([
    (0, validation_1.ValidateEnum)({
        enum: enum_1.NotificationLevel,
        name: 'NotificationLevel',
        optional: true,
        description: 'Filter by notification level',
    }),
    __metadata("design:type", String)
], NotificationSearchDto.prototype, "level", void 0);
__decorate([
    (0, validation_1.ValidateEnum)({
        enum: enum_1.NotificationType,
        name: 'NotificationType',
        optional: true,
        description: 'Filter by notification type',
    }),
    __metadata("design:type", String)
], NotificationSearchDto.prototype, "type", void 0);
__decorate([
    (0, validation_1.ValidateBoolean)({ optional: true, description: 'Filter by unread status' }),
    __metadata("design:type", Boolean)
], NotificationSearchDto.prototype, "unread", void 0);
class NotificationCreateDto {
    level;
    type;
    title;
    description;
    data;
    readAt;
    userId;
    static _OPENAPI_METADATA_FACTORY() {
        return { level: { required: false, enum: require("../enum").NotificationLevel }, type: { required: false, enum: require("../enum").NotificationType }, title: { required: true, type: () => String }, description: { required: false, type: () => String, nullable: true }, data: { required: false, type: () => Object }, readAt: { required: false, type: () => Date, nullable: true }, userId: { required: true, type: () => String } };
    }
}
exports.NotificationCreateDto = NotificationCreateDto;
__decorate([
    (0, validation_1.ValidateEnum)({
        enum: enum_1.NotificationLevel,
        name: 'NotificationLevel',
        optional: true,
        description: 'Notification level',
    }),
    __metadata("design:type", String)
], NotificationCreateDto.prototype, "level", void 0);
__decorate([
    (0, validation_1.ValidateEnum)({ enum: enum_1.NotificationType, name: 'NotificationType', optional: true, description: 'Notification type' }),
    __metadata("design:type", String)
], NotificationCreateDto.prototype, "type", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Notification title' }),
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], NotificationCreateDto.prototype, "title", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: 'Notification description' }),
    (0, class_validator_1.IsString)(),
    (0, validation_1.Optional)({ nullable: true }),
    __metadata("design:type", Object)
], NotificationCreateDto.prototype, "description", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: 'Additional notification data' }),
    (0, validation_1.Optional)({ nullable: true }),
    __metadata("design:type", Object)
], NotificationCreateDto.prototype, "data", void 0);
__decorate([
    (0, validation_1.ValidateDate)({ optional: true, description: 'Date when notification was read' }),
    __metadata("design:type", Object)
], NotificationCreateDto.prototype, "readAt", void 0);
__decorate([
    (0, validation_1.ValidateUUID)({ description: 'User ID to send notification to' }),
    __metadata("design:type", String)
], NotificationCreateDto.prototype, "userId", void 0);
class NotificationUpdateDto {
    readAt;
    static _OPENAPI_METADATA_FACTORY() {
        return { readAt: { required: false, type: () => Date, nullable: true } };
    }
}
exports.NotificationUpdateDto = NotificationUpdateDto;
__decorate([
    (0, validation_1.ValidateDate)({ optional: true, description: 'Date when notification was read' }),
    __metadata("design:type", Object)
], NotificationUpdateDto.prototype, "readAt", void 0);
class NotificationUpdateAllDto {
    ids;
    readAt;
    static _OPENAPI_METADATA_FACTORY() {
        return { ids: { required: true, type: () => [String] }, readAt: { required: false, type: () => Date, nullable: true } };
    }
}
exports.NotificationUpdateAllDto = NotificationUpdateAllDto;
__decorate([
    (0, validation_1.ValidateUUID)({ each: true, optional: true, description: 'Notification IDs to update' }),
    __metadata("design:type", Array)
], NotificationUpdateAllDto.prototype, "ids", void 0);
__decorate([
    (0, validation_1.ValidateDate)({ optional: true, description: 'Date when notifications were read' }),
    __metadata("design:type", Object)
], NotificationUpdateAllDto.prototype, "readAt", void 0);
class NotificationDeleteAllDto {
    ids;
    static _OPENAPI_METADATA_FACTORY() {
        return { ids: { required: true, type: () => [String] } };
    }
}
exports.NotificationDeleteAllDto = NotificationDeleteAllDto;
__decorate([
    (0, validation_1.ValidateUUID)({ each: true, description: 'Notification IDs to delete' }),
    __metadata("design:type", Array)
], NotificationDeleteAllDto.prototype, "ids", void 0);
const mapNotification = (notification) => {
    return {
        id: notification.id,
        createdAt: notification.createdAt,
        level: notification.level,
        type: notification.type,
        title: notification.title,
        description: notification.description ?? undefined,
        data: notification.data ?? undefined,
        readAt: notification.readAt ?? undefined,
    };
};
exports.mapNotification = mapNotification;
//# sourceMappingURL=notification.dto.js.map