"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MemoryLaneDto = exports.SearchExploreResponseDto = exports.SearchStatisticsResponseDto = exports.SearchResponseDto = exports.SearchSuggestionRequestDto = exports.SearchSuggestionType = exports.PlacesResponseDto = exports.SearchPeopleDto = exports.SearchPlacesDto = exports.SmartSearchDto = exports.StatisticsSearchDto = exports.MetadataSearchDto = exports.LargeAssetSearchDto = exports.RandomSearchDto = void 0;
exports.mapPlaces = mapPlaces;
const openapi = require("@nestjs/swagger");
const swagger_1 = require("@nestjs/swagger");
const class_transformer_1 = require("class-transformer");
const class_validator_1 = require("class-validator");
const decorators_1 = require("../decorators");
const asset_response_dto_1 = require("./asset-response.dto");
const enum_1 = require("../enum");
const validation_1 = require("../validation");
class BaseSearchDto {
    libraryId;
    deviceId;
    type;
    isEncoded;
    isFavorite;
    isMotion;
    isOffline;
    visibility;
    createdBefore;
    createdAfter;
    updatedBefore;
    updatedAfter;
    trashedBefore;
    trashedAfter;
    takenBefore;
    takenAfter;
    city;
    state;
    country;
    make;
    model;
    lensModel;
    isNotInAlbum;
    personIds;
    tagIds;
    albumIds;
    rating;
    ocr;
    static _OPENAPI_METADATA_FACTORY() {
        return { libraryId: { required: false, type: () => String, nullable: true }, deviceId: { required: false, type: () => String }, type: { required: false, enum: require("../enum").AssetType }, isEncoded: { required: false, type: () => Boolean }, isFavorite: { required: false, type: () => Boolean }, isMotion: { required: false, type: () => Boolean }, isOffline: { required: false, type: () => Boolean }, visibility: { required: false, enum: require("../enum").AssetVisibility }, createdBefore: { required: false, type: () => Date }, createdAfter: { required: false, type: () => Date }, updatedBefore: { required: false, type: () => Date }, updatedAfter: { required: false, type: () => Date }, trashedBefore: { required: false, type: () => Date }, trashedAfter: { required: false, type: () => Date }, takenBefore: { required: false, type: () => Date }, takenAfter: { required: false, type: () => Date }, city: { required: false, type: () => String, nullable: true }, state: { required: false, type: () => String, nullable: true }, country: { required: false, type: () => String, nullable: true }, make: { required: false, type: () => String }, model: { required: false, type: () => String, nullable: true }, lensModel: { required: false, type: () => String, nullable: true }, isNotInAlbum: { required: false, type: () => Boolean }, personIds: { required: false, type: () => [String] }, tagIds: { required: false, type: () => [String], nullable: true }, albumIds: { required: false, type: () => [String] }, rating: { required: false, type: () => Number, minimum: -1, maximum: 5 }, ocr: { required: false, type: () => String } };
    }
}
__decorate([
    (0, validation_1.ValidateUUID)({ optional: true, nullable: true, description: 'Library ID to filter by' }),
    __metadata("design:type", Object)
], BaseSearchDto.prototype, "libraryId", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: 'Device ID to filter by' }),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsNotEmpty)(),
    (0, validation_1.Optional)(),
    __metadata("design:type", String)
], BaseSearchDto.prototype, "deviceId", void 0);
__decorate([
    (0, validation_1.ValidateEnum)({ enum: enum_1.AssetType, name: 'AssetTypeEnum', optional: true, description: 'Asset type filter' }),
    __metadata("design:type", String)
], BaseSearchDto.prototype, "type", void 0);
__decorate([
    (0, validation_1.ValidateBoolean)({ optional: true, description: 'Filter by encoded status' }),
    __metadata("design:type", Boolean)
], BaseSearchDto.prototype, "isEncoded", void 0);
__decorate([
    (0, validation_1.ValidateBoolean)({ optional: true, description: 'Filter by favorite status' }),
    __metadata("design:type", Boolean)
], BaseSearchDto.prototype, "isFavorite", void 0);
__decorate([
    (0, validation_1.ValidateBoolean)({ optional: true, description: 'Filter by motion photo status' }),
    __metadata("design:type", Boolean)
], BaseSearchDto.prototype, "isMotion", void 0);
__decorate([
    (0, validation_1.ValidateBoolean)({ optional: true, description: 'Filter by offline status' }),
    __metadata("design:type", Boolean)
], BaseSearchDto.prototype, "isOffline", void 0);
__decorate([
    (0, validation_1.ValidateEnum)({ enum: enum_1.AssetVisibility, name: 'AssetVisibility', optional: true, description: 'Filter by visibility' }),
    __metadata("design:type", String)
], BaseSearchDto.prototype, "visibility", void 0);
__decorate([
    (0, validation_1.ValidateDate)({ optional: true, description: 'Filter by creation date (before)' }),
    __metadata("design:type", Date)
], BaseSearchDto.prototype, "createdBefore", void 0);
__decorate([
    (0, validation_1.ValidateDate)({ optional: true, description: 'Filter by creation date (after)' }),
    __metadata("design:type", Date)
], BaseSearchDto.prototype, "createdAfter", void 0);
__decorate([
    (0, validation_1.ValidateDate)({ optional: true, description: 'Filter by update date (before)' }),
    __metadata("design:type", Date)
], BaseSearchDto.prototype, "updatedBefore", void 0);
__decorate([
    (0, validation_1.ValidateDate)({ optional: true, description: 'Filter by update date (after)' }),
    __metadata("design:type", Date)
], BaseSearchDto.prototype, "updatedAfter", void 0);
__decorate([
    (0, validation_1.ValidateDate)({ optional: true, description: 'Filter by trash date (before)' }),
    __metadata("design:type", Date)
], BaseSearchDto.prototype, "trashedBefore", void 0);
__decorate([
    (0, validation_1.ValidateDate)({ optional: true, description: 'Filter by trash date (after)' }),
    __metadata("design:type", Date)
], BaseSearchDto.prototype, "trashedAfter", void 0);
__decorate([
    (0, validation_1.ValidateDate)({ optional: true, description: 'Filter by taken date (before)' }),
    __metadata("design:type", Date)
], BaseSearchDto.prototype, "takenBefore", void 0);
__decorate([
    (0, validation_1.ValidateDate)({ optional: true, description: 'Filter by taken date (after)' }),
    __metadata("design:type", Date)
], BaseSearchDto.prototype, "takenAfter", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: 'Filter by city name' }),
    (0, class_validator_1.IsString)(),
    (0, validation_1.Optional)({ nullable: true, emptyToNull: true }),
    __metadata("design:type", Object)
], BaseSearchDto.prototype, "city", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: 'Filter by state/province name' }),
    (0, class_validator_1.IsString)(),
    (0, validation_1.Optional)({ nullable: true, emptyToNull: true }),
    __metadata("design:type", Object)
], BaseSearchDto.prototype, "state", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: 'Filter by country name' }),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsNotEmpty)(),
    (0, validation_1.Optional)({ nullable: true, emptyToNull: true }),
    __metadata("design:type", Object)
], BaseSearchDto.prototype, "country", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: 'Filter by camera make' }),
    (0, class_validator_1.IsString)(),
    (0, validation_1.Optional)({ nullable: true, emptyToNull: true }),
    __metadata("design:type", String)
], BaseSearchDto.prototype, "make", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: 'Filter by camera model' }),
    (0, class_validator_1.IsString)(),
    (0, validation_1.Optional)({ nullable: true, emptyToNull: true }),
    __metadata("design:type", Object)
], BaseSearchDto.prototype, "model", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: 'Filter by lens model' }),
    (0, class_validator_1.IsString)(),
    (0, validation_1.Optional)({ nullable: true, emptyToNull: true }),
    __metadata("design:type", Object)
], BaseSearchDto.prototype, "lensModel", void 0);
__decorate([
    (0, validation_1.ValidateBoolean)({ optional: true, description: 'Filter assets not in any album' }),
    __metadata("design:type", Boolean)
], BaseSearchDto.prototype, "isNotInAlbum", void 0);
__decorate([
    (0, validation_1.ValidateUUID)({ each: true, optional: true, description: 'Filter by person IDs' }),
    __metadata("design:type", Array)
], BaseSearchDto.prototype, "personIds", void 0);
__decorate([
    (0, validation_1.ValidateUUID)({ each: true, optional: true, description: 'Filter by tag IDs' }),
    __metadata("design:type", Object)
], BaseSearchDto.prototype, "tagIds", void 0);
__decorate([
    (0, validation_1.ValidateUUID)({ each: true, optional: true, description: 'Filter by album IDs' }),
    __metadata("design:type", Array)
], BaseSearchDto.prototype, "albumIds", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ type: 'number', description: 'Filter by rating', minimum: -1, maximum: 5 }),
    (0, validation_1.Optional)(),
    (0, class_validator_1.IsInt)(),
    (0, class_validator_1.Max)(5),
    (0, class_validator_1.Min)(-1),
    __metadata("design:type", Number)
], BaseSearchDto.prototype, "rating", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: 'Filter by OCR text content' }),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsNotEmpty)(),
    (0, validation_1.Optional)(),
    __metadata("design:type", String)
], BaseSearchDto.prototype, "ocr", void 0);
class BaseSearchWithResultsDto extends BaseSearchDto {
    withDeleted;
    withExif;
    size;
    static _OPENAPI_METADATA_FACTORY() {
        return { withDeleted: { required: false, type: () => Boolean }, withExif: { required: false, type: () => Boolean }, size: { required: false, type: () => Number, minimum: 1, maximum: 1000 } };
    }
}
__decorate([
    (0, validation_1.ValidateBoolean)({ optional: true, description: 'Include deleted assets' }),
    __metadata("design:type", Boolean)
], BaseSearchWithResultsDto.prototype, "withDeleted", void 0);
__decorate([
    (0, validation_1.ValidateBoolean)({ optional: true, description: 'Include EXIF data in response' }),
    __metadata("design:type", Boolean)
], BaseSearchWithResultsDto.prototype, "withExif", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ type: 'number', description: 'Number of results to return', minimum: 1, maximum: 1000 }),
    (0, class_validator_1.IsInt)(),
    (0, class_validator_1.Min)(1),
    (0, class_validator_1.Max)(1000),
    (0, class_transformer_1.Type)(() => Number),
    (0, validation_1.Optional)(),
    __metadata("design:type", Number)
], BaseSearchWithResultsDto.prototype, "size", void 0);
class RandomSearchDto extends BaseSearchWithResultsDto {
    withStacked;
    withPeople;
    static _OPENAPI_METADATA_FACTORY() {
        return { withStacked: { required: false, type: () => Boolean }, withPeople: { required: false, type: () => Boolean } };
    }
}
exports.RandomSearchDto = RandomSearchDto;
__decorate([
    (0, validation_1.ValidateBoolean)({ optional: true, description: 'Include stacked assets' }),
    __metadata("design:type", Boolean)
], RandomSearchDto.prototype, "withStacked", void 0);
__decorate([
    (0, validation_1.ValidateBoolean)({ optional: true, description: 'Include assets with people' }),
    __metadata("design:type", Boolean)
], RandomSearchDto.prototype, "withPeople", void 0);
class LargeAssetSearchDto extends BaseSearchWithResultsDto {
    minFileSize;
    static _OPENAPI_METADATA_FACTORY() {
        return { minFileSize: { required: false, type: () => Number, minimum: 0 } };
    }
}
exports.LargeAssetSearchDto = LargeAssetSearchDto;
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ type: 'integer', description: 'Minimum file size in bytes', minimum: 0 }),
    (0, validation_1.Optional)(),
    (0, class_validator_1.IsInt)(),
    (0, class_validator_1.Min)(0),
    (0, class_transformer_1.Type)(() => Number),
    __metadata("design:type", Number)
], LargeAssetSearchDto.prototype, "minFileSize", void 0);
class MetadataSearchDto extends RandomSearchDto {
    id;
    deviceAssetId;
    description;
    checksum;
    originalFileName;
    originalPath;
    previewPath;
    thumbnailPath;
    encodedVideoPath;
    order;
    page;
    static _OPENAPI_METADATA_FACTORY() {
        return { id: { required: false, type: () => String }, deviceAssetId: { required: false, type: () => String }, description: { required: false, type: () => String }, checksum: { required: false, type: () => String }, originalFileName: { required: false, type: () => String }, originalPath: { required: false, type: () => String }, previewPath: { required: false, type: () => String }, thumbnailPath: { required: false, type: () => String }, encodedVideoPath: { required: false, type: () => String }, order: { required: false, enum: require("../enum").AssetOrder }, page: { required: false, type: () => Number, minimum: 1 } };
    }
}
exports.MetadataSearchDto = MetadataSearchDto;
__decorate([
    (0, validation_1.ValidateUUID)({ optional: true, description: 'Filter by asset ID' }),
    __metadata("design:type", String)
], MetadataSearchDto.prototype, "id", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: 'Filter by device asset ID' }),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsNotEmpty)(),
    (0, validation_1.Optional)(),
    __metadata("design:type", String)
], MetadataSearchDto.prototype, "deviceAssetId", void 0);
__decorate([
    (0, validation_1.ValidateString)({ optional: true, trim: true, description: 'Filter by description text' }),
    __metadata("design:type", String)
], MetadataSearchDto.prototype, "description", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: 'Filter by file checksum' }),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsNotEmpty)(),
    (0, validation_1.Optional)(),
    __metadata("design:type", String)
], MetadataSearchDto.prototype, "checksum", void 0);
__decorate([
    (0, validation_1.ValidateString)({ optional: true, trim: true, description: 'Filter by original file name' }),
    __metadata("design:type", String)
], MetadataSearchDto.prototype, "originalFileName", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: 'Filter by original file path' }),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsNotEmpty)(),
    (0, validation_1.Optional)(),
    __metadata("design:type", String)
], MetadataSearchDto.prototype, "originalPath", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: 'Filter by preview file path' }),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsNotEmpty)(),
    (0, validation_1.Optional)(),
    __metadata("design:type", String)
], MetadataSearchDto.prototype, "previewPath", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: 'Filter by thumbnail file path' }),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsNotEmpty)(),
    (0, validation_1.Optional)(),
    __metadata("design:type", String)
], MetadataSearchDto.prototype, "thumbnailPath", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: 'Filter by encoded video file path' }),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsNotEmpty)(),
    (0, validation_1.Optional)(),
    __metadata("design:type", String)
], MetadataSearchDto.prototype, "encodedVideoPath", void 0);
__decorate([
    (0, validation_1.ValidateEnum)({
        enum: enum_1.AssetOrder,
        name: 'AssetOrder',
        optional: true,
        default: enum_1.AssetOrder.Desc,
        description: 'Sort order',
    }),
    __metadata("design:type", String)
], MetadataSearchDto.prototype, "order", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ type: 'number', description: 'Page number', minimum: 1 }),
    (0, class_validator_1.IsInt)(),
    (0, class_validator_1.Min)(1),
    (0, class_transformer_1.Type)(() => Number),
    (0, validation_1.Optional)(),
    __metadata("design:type", Number)
], MetadataSearchDto.prototype, "page", void 0);
class StatisticsSearchDto extends BaseSearchDto {
    description;
    static _OPENAPI_METADATA_FACTORY() {
        return { description: { required: false, type: () => String } };
    }
}
exports.StatisticsSearchDto = StatisticsSearchDto;
__decorate([
    (0, validation_1.ValidateString)({ optional: true, trim: true, description: 'Filter by description text' }),
    __metadata("design:type", String)
], StatisticsSearchDto.prototype, "description", void 0);
class SmartSearchDto extends BaseSearchWithResultsDto {
    query;
    queryAssetId;
    language;
    page;
    static _OPENAPI_METADATA_FACTORY() {
        return { query: { required: false, type: () => String }, queryAssetId: { required: false, type: () => String }, language: { required: false, type: () => String }, page: { required: false, type: () => Number, minimum: 1 } };
    }
}
exports.SmartSearchDto = SmartSearchDto;
__decorate([
    (0, validation_1.ValidateString)({ optional: true, trim: true, description: 'Natural language search query' }),
    __metadata("design:type", String)
], SmartSearchDto.prototype, "query", void 0);
__decorate([
    (0, validation_1.ValidateUUID)({ optional: true, description: 'Asset ID to use as search reference' }),
    __metadata("design:type", String)
], SmartSearchDto.prototype, "queryAssetId", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: 'Search language code' }),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsNotEmpty)(),
    (0, validation_1.Optional)(),
    __metadata("design:type", String)
], SmartSearchDto.prototype, "language", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ type: 'number', description: 'Page number', minimum: 1 }),
    (0, class_validator_1.IsInt)(),
    (0, class_validator_1.Min)(1),
    (0, class_transformer_1.Type)(() => Number),
    (0, validation_1.Optional)(),
    __metadata("design:type", Number)
], SmartSearchDto.prototype, "page", void 0);
class SearchPlacesDto {
    name;
    static _OPENAPI_METADATA_FACTORY() {
        return { name: { required: true, type: () => String } };
    }
}
exports.SearchPlacesDto = SearchPlacesDto;
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Place name to search for' }),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsNotEmpty)(),
    __metadata("design:type", String)
], SearchPlacesDto.prototype, "name", void 0);
class SearchPeopleDto {
    name;
    withHidden;
    static _OPENAPI_METADATA_FACTORY() {
        return { name: { required: true, type: () => String }, withHidden: { required: false, type: () => Boolean } };
    }
}
exports.SearchPeopleDto = SearchPeopleDto;
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Person name to search for' }),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsNotEmpty)(),
    __metadata("design:type", String)
], SearchPeopleDto.prototype, "name", void 0);
__decorate([
    (0, validation_1.ValidateBoolean)({ optional: true, description: 'Include hidden people' }),
    __metadata("design:type", Boolean)
], SearchPeopleDto.prototype, "withHidden", void 0);
class PlacesResponseDto {
    name;
    latitude;
    longitude;
    admin1name;
    admin2name;
    static _OPENAPI_METADATA_FACTORY() {
        return { name: { required: true, type: () => String }, latitude: { required: true, type: () => Number }, longitude: { required: true, type: () => Number }, admin1name: { required: false, type: () => String }, admin2name: { required: false, type: () => String } };
    }
}
exports.PlacesResponseDto = PlacesResponseDto;
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Place name' }),
    __metadata("design:type", String)
], PlacesResponseDto.prototype, "name", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'number', description: 'Latitude coordinate' }),
    __metadata("design:type", Number)
], PlacesResponseDto.prototype, "latitude", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'number', description: 'Longitude coordinate' }),
    __metadata("design:type", Number)
], PlacesResponseDto.prototype, "longitude", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: 'Administrative level 1 name (state/province)' }),
    __metadata("design:type", String)
], PlacesResponseDto.prototype, "admin1name", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: 'Administrative level 2 name (county/district)' }),
    __metadata("design:type", String)
], PlacesResponseDto.prototype, "admin2name", void 0);
function mapPlaces(place) {
    return {
        name: place.name,
        latitude: place.latitude,
        longitude: place.longitude,
        admin1name: place.admin1Name ?? undefined,
        admin2name: place.admin2Name ?? undefined,
    };
}
var SearchSuggestionType;
(function (SearchSuggestionType) {
    SearchSuggestionType["COUNTRY"] = "country";
    SearchSuggestionType["STATE"] = "state";
    SearchSuggestionType["CITY"] = "city";
    SearchSuggestionType["CAMERA_MAKE"] = "camera-make";
    SearchSuggestionType["CAMERA_MODEL"] = "camera-model";
    SearchSuggestionType["CAMERA_LENS_MODEL"] = "camera-lens-model";
})(SearchSuggestionType || (exports.SearchSuggestionType = SearchSuggestionType = {}));
class SearchSuggestionRequestDto {
    type;
    country;
    state;
    make;
    model;
    lensModel;
    includeNull;
    static _OPENAPI_METADATA_FACTORY() {
        return { type: { required: true, enum: require("./search.dto").SearchSuggestionType }, country: { required: false, type: () => String }, state: { required: false, type: () => String }, make: { required: false, type: () => String }, model: { required: false, type: () => String }, lensModel: { required: false, type: () => String }, includeNull: { required: false, type: () => Boolean } };
    }
}
exports.SearchSuggestionRequestDto = SearchSuggestionRequestDto;
__decorate([
    (0, validation_1.ValidateEnum)({ enum: SearchSuggestionType, name: 'SearchSuggestionType', description: 'Suggestion type' }),
    __metadata("design:type", String)
], SearchSuggestionRequestDto.prototype, "type", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: 'Filter by country' }),
    (0, class_validator_1.IsString)(),
    (0, validation_1.Optional)(),
    __metadata("design:type", String)
], SearchSuggestionRequestDto.prototype, "country", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: 'Filter by state/province' }),
    (0, class_validator_1.IsString)(),
    (0, validation_1.Optional)(),
    __metadata("design:type", String)
], SearchSuggestionRequestDto.prototype, "state", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: 'Filter by camera make' }),
    (0, class_validator_1.IsString)(),
    (0, validation_1.Optional)(),
    __metadata("design:type", String)
], SearchSuggestionRequestDto.prototype, "make", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: 'Filter by camera model' }),
    (0, class_validator_1.IsString)(),
    (0, validation_1.Optional)(),
    __metadata("design:type", String)
], SearchSuggestionRequestDto.prototype, "model", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: 'Filter by lens model' }),
    (0, class_validator_1.IsString)(),
    (0, validation_1.Optional)(),
    __metadata("design:type", String)
], SearchSuggestionRequestDto.prototype, "lensModel", void 0);
__decorate([
    (0, validation_1.ValidateBoolean)({
        optional: true,
        description: 'Include null values in suggestions',
        history: new decorators_1.HistoryBuilder().added('v1.111.0').stable('v2'),
    }),
    __metadata("design:type", Boolean)
], SearchSuggestionRequestDto.prototype, "includeNull", void 0);
class SearchFacetCountResponseDto {
    count;
    value;
    static _OPENAPI_METADATA_FACTORY() {
        return { count: { required: true, type: () => Number }, value: { required: true, type: () => String } };
    }
}
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer', description: 'Number of assets with this facet value' }),
    __metadata("design:type", Number)
], SearchFacetCountResponseDto.prototype, "count", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Facet value' }),
    __metadata("design:type", String)
], SearchFacetCountResponseDto.prototype, "value", void 0);
class SearchFacetResponseDto {
    fieldName;
    counts;
    static _OPENAPI_METADATA_FACTORY() {
        return { fieldName: { required: true, type: () => String }, counts: { required: true, type: () => [SearchFacetCountResponseDto] } };
    }
}
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Facet field name' }),
    __metadata("design:type", String)
], SearchFacetResponseDto.prototype, "fieldName", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Facet counts' }),
    __metadata("design:type", Array)
], SearchFacetResponseDto.prototype, "counts", void 0);
class SearchAlbumResponseDto {
    total;
    count;
    items;
    facets;
    static _OPENAPI_METADATA_FACTORY() {
        return { total: { required: true, type: () => Number }, count: { required: true, type: () => Number }, items: { required: true, type: () => [require("./album.dto").AlbumResponseDto] }, facets: { required: true, type: () => [SearchFacetResponseDto] } };
    }
}
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer', description: 'Total number of matching albums' }),
    __metadata("design:type", Number)
], SearchAlbumResponseDto.prototype, "total", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer', description: 'Number of albums in this page' }),
    __metadata("design:type", Number)
], SearchAlbumResponseDto.prototype, "count", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: undefined }),
    __metadata("design:type", Array)
], SearchAlbumResponseDto.prototype, "items", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: undefined }),
    __metadata("design:type", Array)
], SearchAlbumResponseDto.prototype, "facets", void 0);
class SearchAssetResponseDto {
    total;
    count;
    items;
    facets;
    nextPage;
    static _OPENAPI_METADATA_FACTORY() {
        return { total: { required: true, type: () => Number }, count: { required: true, type: () => Number }, items: { required: true, type: () => [require("./asset-response.dto").AssetResponseDto] }, facets: { required: true, type: () => [SearchFacetResponseDto] }, nextPage: { required: true, type: () => String, nullable: true } };
    }
}
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer', description: 'Total number of matching assets' }),
    __metadata("design:type", Number)
], SearchAssetResponseDto.prototype, "total", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer', description: 'Number of assets in this page' }),
    __metadata("design:type", Number)
], SearchAssetResponseDto.prototype, "count", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: undefined }),
    __metadata("design:type", Array)
], SearchAssetResponseDto.prototype, "items", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: undefined }),
    __metadata("design:type", Array)
], SearchAssetResponseDto.prototype, "facets", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Next page token' }),
    __metadata("design:type", Object)
], SearchAssetResponseDto.prototype, "nextPage", void 0);
class SearchResponseDto {
    albums;
    assets;
    static _OPENAPI_METADATA_FACTORY() {
        return { albums: { required: true, type: () => SearchAlbumResponseDto }, assets: { required: true, type: () => SearchAssetResponseDto } };
    }
}
exports.SearchResponseDto = SearchResponseDto;
__decorate([
    (0, swagger_1.ApiProperty)({ description: undefined }),
    __metadata("design:type", SearchAlbumResponseDto)
], SearchResponseDto.prototype, "albums", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: undefined }),
    __metadata("design:type", SearchAssetResponseDto)
], SearchResponseDto.prototype, "assets", void 0);
class SearchStatisticsResponseDto {
    total;
    static _OPENAPI_METADATA_FACTORY() {
        return { total: { required: true, type: () => Number } };
    }
}
exports.SearchStatisticsResponseDto = SearchStatisticsResponseDto;
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer', description: 'Total number of matching assets' }),
    __metadata("design:type", Number)
], SearchStatisticsResponseDto.prototype, "total", void 0);
class SearchExploreItem {
    value;
    data;
    static _OPENAPI_METADATA_FACTORY() {
        return { value: { required: true, type: () => String }, data: { required: true, type: () => require("./asset-response.dto").AssetResponseDto } };
    }
}
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Explore value' }),
    __metadata("design:type", String)
], SearchExploreItem.prototype, "value", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: undefined }),
    __metadata("design:type", asset_response_dto_1.AssetResponseDto)
], SearchExploreItem.prototype, "data", void 0);
class SearchExploreResponseDto {
    fieldName;
    items;
    static _OPENAPI_METADATA_FACTORY() {
        return { fieldName: { required: true, type: () => String }, items: { required: true, type: () => [SearchExploreItem] } };
    }
}
exports.SearchExploreResponseDto = SearchExploreResponseDto;
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Explore field name' }),
    __metadata("design:type", String)
], SearchExploreResponseDto.prototype, "fieldName", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: undefined }),
    __metadata("design:type", Array)
], SearchExploreResponseDto.prototype, "items", void 0);
class MemoryLaneDto {
    day;
    month;
    static _OPENAPI_METADATA_FACTORY() {
        return { day: { required: true, type: () => Number, minimum: 1, maximum: 31 }, month: { required: true, type: () => Number, minimum: 1, maximum: 12 } };
    }
}
exports.MemoryLaneDto = MemoryLaneDto;
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer', description: 'Day of month' }),
    (0, class_validator_1.IsInt)(),
    (0, class_transformer_1.Type)(() => Number),
    (0, class_validator_1.Max)(31),
    (0, class_validator_1.Min)(1),
    __metadata("design:type", Number)
], MemoryLaneDto.prototype, "day", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer', description: 'Month' }),
    (0, class_validator_1.IsInt)(),
    (0, class_transformer_1.Type)(() => Number),
    (0, class_validator_1.Max)(12),
    (0, class_validator_1.Min)(1),
    __metadata("design:type", Number)
], MemoryLaneDto.prototype, "month", void 0);
//# sourceMappingURL=search.dto.js.map