"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SystemConfigDto = exports.SystemConfigImageDto = exports.SystemConfigThemeDto = exports.SystemConfigTemplateStorageOptionDto = exports.SystemConfigSmtpDto = exports.MapThemeDto = exports.SystemConfigFFmpegDto = exports.SystemConfigBackupsDto = exports.DatabaseBackupConfig = void 0;
exports.mapConfig = mapConfig;
const openapi = require("@nestjs/swagger");
const swagger_1 = require("@nestjs/swagger");
const class_transformer_1 = require("class-transformer");
const class_validator_1 = require("class-validator");
const model_config_dto_1 = require("./model-config.dto");
const enum_1 = require("../enum");
const validation_1 = require("../validation");
const isLibraryScanEnabled = (config) => config.enabled;
const isOAuthEnabled = (config) => config.enabled;
const isOAuthOverrideEnabled = (config) => config.mobileOverrideEnabled;
const isEmailNotificationEnabled = (config) => config.enabled;
const isDatabaseBackupEnabled = (config) => config.enabled;
class DatabaseBackupConfig {
    enabled;
    cronExpression;
    keepLastAmount;
    static _OPENAPI_METADATA_FACTORY() {
        return { enabled: { required: true, type: () => Boolean }, cronExpression: { required: true, type: () => String }, keepLastAmount: { required: true, type: () => Number, minimum: 1 } };
    }
}
exports.DatabaseBackupConfig = DatabaseBackupConfig;
__decorate([
    (0, validation_1.ValidateBoolean)({ description: 'Enabled' }),
    __metadata("design:type", Boolean)
], DatabaseBackupConfig.prototype, "enabled", void 0);
__decorate([
    (0, class_validator_1.ValidateIf)(isDatabaseBackupEnabled),
    (0, class_validator_1.IsNotEmpty)(),
    (0, validation_1.IsCronExpression)(),
    (0, class_validator_1.IsString)(),
    (0, swagger_1.ApiProperty)({ description: 'Cron expression' }),
    __metadata("design:type", String)
], DatabaseBackupConfig.prototype, "cronExpression", void 0);
__decorate([
    (0, class_validator_1.IsInt)(),
    (0, class_validator_1.IsPositive)(),
    (0, class_validator_1.IsNotEmpty)(),
    (0, swagger_1.ApiProperty)({ description: 'Keep last amount' }),
    __metadata("design:type", Number)
], DatabaseBackupConfig.prototype, "keepLastAmount", void 0);
class SystemConfigBackupsDto {
    database;
    static _OPENAPI_METADATA_FACTORY() {
        return { database: { required: true, type: () => require("./system-config.dto").DatabaseBackupConfig } };
    }
}
exports.SystemConfigBackupsDto = SystemConfigBackupsDto;
__decorate([
    (0, class_transformer_1.Type)(() => DatabaseBackupConfig),
    (0, class_validator_1.ValidateNested)(),
    (0, class_validator_1.IsObject)(),
    __metadata("design:type", DatabaseBackupConfig)
], SystemConfigBackupsDto.prototype, "database", void 0);
class SystemConfigFFmpegDto {
    crf;
    threads;
    preset;
    targetVideoCodec;
    acceptedVideoCodecs;
    targetAudioCodec;
    acceptedAudioCodecs;
    acceptedContainers;
    targetResolution;
    maxBitrate;
    bframes;
    refs;
    gopSize;
    temporalAQ;
    cqMode;
    twoPass;
    preferredHwDevice;
    transcode;
    accel;
    accelDecode;
    tonemap;
    static _OPENAPI_METADATA_FACTORY() {
        return { crf: { required: true, type: () => Number, minimum: 0, maximum: 51 }, threads: { required: true, type: () => Number, minimum: 0 }, preset: { required: true, type: () => String }, targetVideoCodec: { required: true, enum: require("../enum").VideoCodec }, acceptedVideoCodecs: { required: true, enum: require("../enum").VideoCodec, isArray: true }, targetAudioCodec: { required: true, enum: require("../enum").AudioCodec }, acceptedAudioCodecs: { required: true, enum: require("../enum").AudioCodec, isArray: true }, acceptedContainers: { required: true, enum: require("../enum").VideoContainer, isArray: true }, targetResolution: { required: true, type: () => String }, maxBitrate: { required: true, type: () => String }, bframes: { required: true, type: () => Number, minimum: -1, maximum: 16 }, refs: { required: true, type: () => Number, minimum: 0, maximum: 6 }, gopSize: { required: true, type: () => Number, minimum: 0 }, temporalAQ: { required: true, type: () => Boolean }, cqMode: { required: true, enum: require("../enum").CQMode }, twoPass: { required: true, type: () => Boolean }, preferredHwDevice: { required: true, type: () => String }, transcode: { required: true, enum: require("../enum").TranscodePolicy }, accel: { required: true, enum: require("../enum").TranscodeHardwareAcceleration }, accelDecode: { required: true, type: () => Boolean }, tonemap: { required: true, enum: require("../enum").ToneMapping } };
    }
}
exports.SystemConfigFFmpegDto = SystemConfigFFmpegDto;
__decorate([
    (0, class_validator_1.IsInt)(),
    (0, class_validator_1.Min)(0),
    (0, class_validator_1.Max)(51),
    (0, class_transformer_1.Type)(() => Number),
    (0, swagger_1.ApiProperty)({ type: 'integer', description: 'CRF' }),
    __metadata("design:type", Number)
], SystemConfigFFmpegDto.prototype, "crf", void 0);
__decorate([
    (0, class_validator_1.IsInt)(),
    (0, class_validator_1.Min)(0),
    (0, class_transformer_1.Type)(() => Number),
    (0, swagger_1.ApiProperty)({ type: 'integer', description: 'Threads' }),
    __metadata("design:type", Number)
], SystemConfigFFmpegDto.prototype, "threads", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    (0, swagger_1.ApiProperty)({ description: 'Preset' }),
    __metadata("design:type", String)
], SystemConfigFFmpegDto.prototype, "preset", void 0);
__decorate([
    (0, validation_1.ValidateEnum)({ enum: enum_1.VideoCodec, name: 'VideoCodec', description: 'Target video codec' }),
    __metadata("design:type", String)
], SystemConfigFFmpegDto.prototype, "targetVideoCodec", void 0);
__decorate([
    (0, validation_1.ValidateEnum)({ enum: enum_1.VideoCodec, name: 'VideoCodec', each: true, description: 'Accepted video codecs' }),
    __metadata("design:type", Array)
], SystemConfigFFmpegDto.prototype, "acceptedVideoCodecs", void 0);
__decorate([
    (0, validation_1.ValidateEnum)({ enum: enum_1.AudioCodec, name: 'AudioCodec', description: 'Target audio codec' }),
    __metadata("design:type", String)
], SystemConfigFFmpegDto.prototype, "targetAudioCodec", void 0);
__decorate([
    (0, validation_1.ValidateEnum)({ enum: enum_1.AudioCodec, name: 'AudioCodec', each: true, description: 'Accepted audio codecs' }),
    __metadata("design:type", Array)
], SystemConfigFFmpegDto.prototype, "acceptedAudioCodecs", void 0);
__decorate([
    (0, validation_1.ValidateEnum)({ enum: enum_1.VideoContainer, name: 'VideoContainer', each: true, description: 'Accepted containers' }),
    __metadata("design:type", Array)
], SystemConfigFFmpegDto.prototype, "acceptedContainers", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    (0, swagger_1.ApiProperty)({ description: 'Target resolution' }),
    __metadata("design:type", String)
], SystemConfigFFmpegDto.prototype, "targetResolution", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    (0, swagger_1.ApiProperty)({ description: 'Max bitrate' }),
    __metadata("design:type", String)
], SystemConfigFFmpegDto.prototype, "maxBitrate", void 0);
__decorate([
    (0, class_validator_1.IsInt)(),
    (0, class_validator_1.Min)(-1),
    (0, class_validator_1.Max)(16),
    (0, class_transformer_1.Type)(() => Number),
    (0, swagger_1.ApiProperty)({ type: 'integer', description: 'B-frames' }),
    __metadata("design:type", Number)
], SystemConfigFFmpegDto.prototype, "bframes", void 0);
__decorate([
    (0, class_validator_1.IsInt)(),
    (0, class_validator_1.Min)(0),
    (0, class_validator_1.Max)(6),
    (0, class_transformer_1.Type)(() => Number),
    (0, swagger_1.ApiProperty)({ type: 'integer', description: 'References' }),
    __metadata("design:type", Number)
], SystemConfigFFmpegDto.prototype, "refs", void 0);
__decorate([
    (0, class_validator_1.IsInt)(),
    (0, class_validator_1.Min)(0),
    (0, class_transformer_1.Type)(() => Number),
    (0, swagger_1.ApiProperty)({ type: 'integer', description: 'GOP size' }),
    __metadata("design:type", Number)
], SystemConfigFFmpegDto.prototype, "gopSize", void 0);
__decorate([
    (0, validation_1.ValidateBoolean)({ description: 'Temporal AQ' }),
    __metadata("design:type", Boolean)
], SystemConfigFFmpegDto.prototype, "temporalAQ", void 0);
__decorate([
    (0, validation_1.ValidateEnum)({ enum: enum_1.CQMode, name: 'CQMode', description: 'CQ mode' }),
    __metadata("design:type", String)
], SystemConfigFFmpegDto.prototype, "cqMode", void 0);
__decorate([
    (0, validation_1.ValidateBoolean)({ description: 'Two pass' }),
    __metadata("design:type", Boolean)
], SystemConfigFFmpegDto.prototype, "twoPass", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Preferred hardware device' }),
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], SystemConfigFFmpegDto.prototype, "preferredHwDevice", void 0);
__decorate([
    (0, validation_1.ValidateEnum)({ enum: enum_1.TranscodePolicy, name: 'TranscodePolicy', description: 'Transcode policy' }),
    __metadata("design:type", String)
], SystemConfigFFmpegDto.prototype, "transcode", void 0);
__decorate([
    (0, validation_1.ValidateEnum)({
        enum: enum_1.TranscodeHardwareAcceleration,
        name: 'TranscodeHWAccel',
        description: 'Transcode hardware acceleration',
    }),
    __metadata("design:type", String)
], SystemConfigFFmpegDto.prototype, "accel", void 0);
__decorate([
    (0, validation_1.ValidateBoolean)({ description: 'Accelerated decode' }),
    __metadata("design:type", Boolean)
], SystemConfigFFmpegDto.prototype, "accelDecode", void 0);
__decorate([
    (0, validation_1.ValidateEnum)({ enum: enum_1.ToneMapping, name: 'ToneMapping', description: 'Tone mapping' }),
    __metadata("design:type", String)
], SystemConfigFFmpegDto.prototype, "tonemap", void 0);
class JobSettingsDto {
    concurrency;
    static _OPENAPI_METADATA_FACTORY() {
        return { concurrency: { required: true, type: () => Number, minimum: 1 } };
    }
}
__decorate([
    (0, class_validator_1.IsInt)(),
    (0, class_validator_1.IsPositive)(),
    (0, swagger_1.ApiProperty)({ type: 'integer', description: 'Concurrency' }),
    __metadata("design:type", Number)
], JobSettingsDto.prototype, "concurrency", void 0);
class SystemConfigJobDto {
    [_a = enum_1.QueueName.ThumbnailGeneration];
    [_b = enum_1.QueueName.MetadataExtraction];
    [_c = enum_1.QueueName.VideoConversion];
    [_d = enum_1.QueueName.SmartSearch];
    [_e = enum_1.QueueName.Migration];
    [_f = enum_1.QueueName.BackgroundTask];
    [_g = enum_1.QueueName.Search];
    [_h = enum_1.QueueName.FaceDetection];
    [_j = enum_1.QueueName.Ocr];
    [_k = enum_1.QueueName.Sidecar];
    [_l = enum_1.QueueName.Library];
    [_m = enum_1.QueueName.Notification];
    [_o = enum_1.QueueName.Workflow];
    [_p = enum_1.QueueName.Editor];
    static _OPENAPI_METADATA_FACTORY() {
        return {};
    }
}
__decorate([
    (0, swagger_1.ApiProperty)({ type: JobSettingsDto, description: undefined }),
    (0, class_validator_1.ValidateNested)(),
    (0, class_validator_1.IsObject)(),
    (0, class_transformer_1.Type)(() => JobSettingsDto),
    __metadata("design:type", JobSettingsDto)
], SystemConfigJobDto.prototype, _a, void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: JobSettingsDto, description: undefined }),
    (0, class_validator_1.ValidateNested)(),
    (0, class_validator_1.IsObject)(),
    (0, class_transformer_1.Type)(() => JobSettingsDto),
    __metadata("design:type", JobSettingsDto)
], SystemConfigJobDto.prototype, _b, void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: JobSettingsDto, description: undefined }),
    (0, class_validator_1.ValidateNested)(),
    (0, class_validator_1.IsObject)(),
    (0, class_transformer_1.Type)(() => JobSettingsDto),
    __metadata("design:type", JobSettingsDto)
], SystemConfigJobDto.prototype, _c, void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: JobSettingsDto, description: undefined }),
    (0, class_validator_1.ValidateNested)(),
    (0, class_validator_1.IsObject)(),
    (0, class_transformer_1.Type)(() => JobSettingsDto),
    __metadata("design:type", JobSettingsDto)
], SystemConfigJobDto.prototype, _d, void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: JobSettingsDto, description: undefined }),
    (0, class_validator_1.ValidateNested)(),
    (0, class_validator_1.IsObject)(),
    (0, class_transformer_1.Type)(() => JobSettingsDto),
    __metadata("design:type", JobSettingsDto)
], SystemConfigJobDto.prototype, _e, void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: JobSettingsDto, description: undefined }),
    (0, class_validator_1.ValidateNested)(),
    (0, class_validator_1.IsObject)(),
    (0, class_transformer_1.Type)(() => JobSettingsDto),
    __metadata("design:type", JobSettingsDto)
], SystemConfigJobDto.prototype, _f, void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: JobSettingsDto, description: undefined }),
    (0, class_validator_1.ValidateNested)(),
    (0, class_validator_1.IsObject)(),
    (0, class_transformer_1.Type)(() => JobSettingsDto),
    __metadata("design:type", JobSettingsDto)
], SystemConfigJobDto.prototype, _g, void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: JobSettingsDto, description: undefined }),
    (0, class_validator_1.ValidateNested)(),
    (0, class_validator_1.IsObject)(),
    (0, class_transformer_1.Type)(() => JobSettingsDto),
    __metadata("design:type", JobSettingsDto)
], SystemConfigJobDto.prototype, _h, void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: JobSettingsDto, description: undefined }),
    (0, class_validator_1.ValidateNested)(),
    (0, class_validator_1.IsObject)(),
    (0, class_transformer_1.Type)(() => JobSettingsDto),
    __metadata("design:type", JobSettingsDto)
], SystemConfigJobDto.prototype, _j, void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: JobSettingsDto, description: undefined }),
    (0, class_validator_1.ValidateNested)(),
    (0, class_validator_1.IsObject)(),
    (0, class_transformer_1.Type)(() => JobSettingsDto),
    __metadata("design:type", JobSettingsDto)
], SystemConfigJobDto.prototype, _k, void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: JobSettingsDto, description: undefined }),
    (0, class_validator_1.ValidateNested)(),
    (0, class_validator_1.IsObject)(),
    (0, class_transformer_1.Type)(() => JobSettingsDto),
    __metadata("design:type", JobSettingsDto)
], SystemConfigJobDto.prototype, _l, void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: JobSettingsDto, description: undefined }),
    (0, class_validator_1.ValidateNested)(),
    (0, class_validator_1.IsObject)(),
    (0, class_transformer_1.Type)(() => JobSettingsDto),
    __metadata("design:type", JobSettingsDto)
], SystemConfigJobDto.prototype, _m, void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: JobSettingsDto, description: undefined }),
    (0, class_validator_1.ValidateNested)(),
    (0, class_validator_1.IsObject)(),
    (0, class_transformer_1.Type)(() => JobSettingsDto),
    __metadata("design:type", JobSettingsDto)
], SystemConfigJobDto.prototype, _o, void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: JobSettingsDto, description: undefined }),
    (0, class_validator_1.ValidateNested)(),
    (0, class_validator_1.IsObject)(),
    (0, class_transformer_1.Type)(() => JobSettingsDto),
    __metadata("design:type", JobSettingsDto)
], SystemConfigJobDto.prototype, _p, void 0);
class SystemConfigLibraryScanDto {
    enabled;
    cronExpression;
    static _OPENAPI_METADATA_FACTORY() {
        return { enabled: { required: true, type: () => Boolean }, cronExpression: { required: true, type: () => String } };
    }
}
__decorate([
    (0, validation_1.ValidateBoolean)({ description: 'Enabled' }),
    __metadata("design:type", Boolean)
], SystemConfigLibraryScanDto.prototype, "enabled", void 0);
__decorate([
    (0, class_validator_1.ValidateIf)(isLibraryScanEnabled),
    (0, class_validator_1.IsNotEmpty)(),
    (0, validation_1.IsCronExpression)(),
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], SystemConfigLibraryScanDto.prototype, "cronExpression", void 0);
class SystemConfigLibraryWatchDto {
    enabled;
    static _OPENAPI_METADATA_FACTORY() {
        return { enabled: { required: true, type: () => Boolean } };
    }
}
__decorate([
    (0, validation_1.ValidateBoolean)({ description: 'Enabled' }),
    __metadata("design:type", Boolean)
], SystemConfigLibraryWatchDto.prototype, "enabled", void 0);
class SystemConfigLibraryDto {
    scan;
    watch;
    static _OPENAPI_METADATA_FACTORY() {
        return { scan: { required: true, type: () => SystemConfigLibraryScanDto }, watch: { required: true, type: () => SystemConfigLibraryWatchDto } };
    }
}
__decorate([
    (0, class_transformer_1.Type)(() => SystemConfigLibraryScanDto),
    (0, class_validator_1.ValidateNested)(),
    (0, class_validator_1.IsObject)(),
    __metadata("design:type", SystemConfigLibraryScanDto)
], SystemConfigLibraryDto.prototype, "scan", void 0);
__decorate([
    (0, class_transformer_1.Type)(() => SystemConfigLibraryWatchDto),
    (0, class_validator_1.ValidateNested)(),
    (0, class_validator_1.IsObject)(),
    __metadata("design:type", SystemConfigLibraryWatchDto)
], SystemConfigLibraryDto.prototype, "watch", void 0);
class SystemConfigLoggingDto {
    enabled;
    level;
    static _OPENAPI_METADATA_FACTORY() {
        return { enabled: { required: true, type: () => Boolean }, level: { required: true, enum: require("../enum").LogLevel } };
    }
}
__decorate([
    (0, validation_1.ValidateBoolean)({ description: 'Enabled' }),
    __metadata("design:type", Boolean)
], SystemConfigLoggingDto.prototype, "enabled", void 0);
__decorate([
    (0, validation_1.ValidateEnum)({ enum: enum_1.LogLevel, name: 'LogLevel' }),
    __metadata("design:type", String)
], SystemConfigLoggingDto.prototype, "level", void 0);
class MachineLearningAvailabilityChecksDto {
    enabled;
    timeout;
    interval;
    static _OPENAPI_METADATA_FACTORY() {
        return { enabled: { required: true, type: () => Boolean }, timeout: { required: true, type: () => Number }, interval: { required: true, type: () => Number } };
    }
}
__decorate([
    (0, validation_1.ValidateBoolean)({ description: 'Enabled' }),
    __metadata("design:type", Boolean)
], MachineLearningAvailabilityChecksDto.prototype, "enabled", void 0);
__decorate([
    (0, class_validator_1.IsInt)(),
    __metadata("design:type", Number)
], MachineLearningAvailabilityChecksDto.prototype, "timeout", void 0);
__decorate([
    (0, class_validator_1.IsInt)(),
    __metadata("design:type", Number)
], MachineLearningAvailabilityChecksDto.prototype, "interval", void 0);
class SystemConfigMachineLearningDto {
    enabled;
    urls;
    availabilityChecks;
    clip;
    duplicateDetection;
    facialRecognition;
    ocr;
    static _OPENAPI_METADATA_FACTORY() {
        return { enabled: { required: true, type: () => Boolean }, urls: { required: true, type: () => [String], format: "uri", minItems: 1 }, availabilityChecks: { required: true, type: () => MachineLearningAvailabilityChecksDto }, clip: { required: true, type: () => require("./model-config.dto").CLIPConfig }, duplicateDetection: { required: true, type: () => require("./model-config.dto").DuplicateDetectionConfig }, facialRecognition: { required: true, type: () => require("./model-config.dto").FacialRecognitionConfig }, ocr: { required: true, type: () => require("./model-config.dto").OcrConfig } };
    }
}
__decorate([
    (0, validation_1.ValidateBoolean)({ description: 'Enabled' }),
    __metadata("design:type", Boolean)
], SystemConfigMachineLearningDto.prototype, "enabled", void 0);
__decorate([
    (0, class_validator_1.IsUrl)({ require_tld: false, allow_underscores: true }, { each: true }),
    (0, class_validator_1.ArrayMinSize)(1),
    (0, class_validator_1.ValidateIf)((dto) => dto.enabled),
    (0, swagger_1.ApiProperty)({ type: 'array', items: { type: 'string', format: 'uri' }, minItems: 1 }),
    __metadata("design:type", Array)
], SystemConfigMachineLearningDto.prototype, "urls", void 0);
__decorate([
    (0, class_transformer_1.Type)(() => MachineLearningAvailabilityChecksDto),
    (0, class_validator_1.ValidateNested)(),
    (0, class_validator_1.IsObject)(),
    __metadata("design:type", MachineLearningAvailabilityChecksDto)
], SystemConfigMachineLearningDto.prototype, "availabilityChecks", void 0);
__decorate([
    (0, class_transformer_1.Type)(() => model_config_dto_1.CLIPConfig),
    (0, class_validator_1.ValidateNested)(),
    (0, class_validator_1.IsObject)(),
    __metadata("design:type", model_config_dto_1.CLIPConfig)
], SystemConfigMachineLearningDto.prototype, "clip", void 0);
__decorate([
    (0, class_transformer_1.Type)(() => model_config_dto_1.DuplicateDetectionConfig),
    (0, class_validator_1.ValidateNested)(),
    (0, class_validator_1.IsObject)(),
    __metadata("design:type", model_config_dto_1.DuplicateDetectionConfig)
], SystemConfigMachineLearningDto.prototype, "duplicateDetection", void 0);
__decorate([
    (0, class_transformer_1.Type)(() => model_config_dto_1.FacialRecognitionConfig),
    (0, class_validator_1.ValidateNested)(),
    (0, class_validator_1.IsObject)(),
    __metadata("design:type", model_config_dto_1.FacialRecognitionConfig)
], SystemConfigMachineLearningDto.prototype, "facialRecognition", void 0);
__decorate([
    (0, class_transformer_1.Type)(() => model_config_dto_1.OcrConfig),
    (0, class_validator_1.ValidateNested)(),
    (0, class_validator_1.IsObject)(),
    __metadata("design:type", model_config_dto_1.OcrConfig)
], SystemConfigMachineLearningDto.prototype, "ocr", void 0);
var MapTheme;
(function (MapTheme) {
    MapTheme["LIGHT"] = "light";
    MapTheme["DARK"] = "dark";
})(MapTheme || (MapTheme = {}));
class MapThemeDto {
    theme;
    static _OPENAPI_METADATA_FACTORY() {
        return { theme: { required: true, enum: MapTheme } };
    }
}
exports.MapThemeDto = MapThemeDto;
__decorate([
    (0, validation_1.ValidateEnum)({ enum: MapTheme, name: 'MapTheme' }),
    __metadata("design:type", String)
], MapThemeDto.prototype, "theme", void 0);
class SystemConfigMapDto {
    enabled;
    lightStyle;
    darkStyle;
    static _OPENAPI_METADATA_FACTORY() {
        return { enabled: { required: true, type: () => Boolean }, lightStyle: { required: true, type: () => String, format: "uri" }, darkStyle: { required: true, type: () => String, format: "uri" } };
    }
}
__decorate([
    (0, validation_1.ValidateBoolean)({ description: 'Enabled' }),
    __metadata("design:type", Boolean)
], SystemConfigMapDto.prototype, "enabled", void 0);
__decorate([
    (0, class_validator_1.IsNotEmpty)(),
    (0, class_validator_1.IsUrl)(),
    __metadata("design:type", String)
], SystemConfigMapDto.prototype, "lightStyle", void 0);
__decorate([
    (0, class_validator_1.IsNotEmpty)(),
    (0, class_validator_1.IsUrl)(),
    __metadata("design:type", String)
], SystemConfigMapDto.prototype, "darkStyle", void 0);
class SystemConfigNewVersionCheckDto {
    enabled;
    static _OPENAPI_METADATA_FACTORY() {
        return { enabled: { required: true, type: () => Boolean } };
    }
}
__decorate([
    (0, validation_1.ValidateBoolean)({ description: 'Enabled' }),
    __metadata("design:type", Boolean)
], SystemConfigNewVersionCheckDto.prototype, "enabled", void 0);
class SystemConfigNightlyTasksDto {
    startTime;
    databaseCleanup;
    missingThumbnails;
    clusterNewFaces;
    generateMemories;
    syncQuotaUsage;
    static _OPENAPI_METADATA_FACTORY() {
        return { startTime: { required: true, type: () => String }, databaseCleanup: { required: true, type: () => Boolean }, missingThumbnails: { required: true, type: () => Boolean }, clusterNewFaces: { required: true, type: () => Boolean }, generateMemories: { required: true, type: () => Boolean }, syncQuotaUsage: { required: true, type: () => Boolean } };
    }
}
__decorate([
    (0, validation_1.IsDateStringFormat)('HH:mm', { message: 'startTime must be in HH:mm format' }),
    __metadata("design:type", String)
], SystemConfigNightlyTasksDto.prototype, "startTime", void 0);
__decorate([
    (0, validation_1.ValidateBoolean)({ description: 'Database cleanup' }),
    __metadata("design:type", Boolean)
], SystemConfigNightlyTasksDto.prototype, "databaseCleanup", void 0);
__decorate([
    (0, validation_1.ValidateBoolean)({ description: 'Missing thumbnails' }),
    __metadata("design:type", Boolean)
], SystemConfigNightlyTasksDto.prototype, "missingThumbnails", void 0);
__decorate([
    (0, validation_1.ValidateBoolean)({ description: 'Cluster new faces' }),
    __metadata("design:type", Boolean)
], SystemConfigNightlyTasksDto.prototype, "clusterNewFaces", void 0);
__decorate([
    (0, validation_1.ValidateBoolean)({ description: 'Generate memories' }),
    __metadata("design:type", Boolean)
], SystemConfigNightlyTasksDto.prototype, "generateMemories", void 0);
__decorate([
    (0, validation_1.ValidateBoolean)({ description: 'Sync quota usage' }),
    __metadata("design:type", Boolean)
], SystemConfigNightlyTasksDto.prototype, "syncQuotaUsage", void 0);
class SystemConfigOAuthDto {
    autoLaunch;
    autoRegister;
    buttonText;
    clientId;
    clientSecret;
    tokenEndpointAuthMethod;
    timeout;
    defaultStorageQuota;
    enabled;
    issuerUrl;
    mobileOverrideEnabled;
    mobileRedirectUri;
    scope;
    signingAlgorithm;
    profileSigningAlgorithm;
    storageLabelClaim;
    storageQuotaClaim;
    roleClaim;
    static _OPENAPI_METADATA_FACTORY() {
        return { autoLaunch: { required: true, type: () => Boolean }, autoRegister: { required: true, type: () => Boolean }, buttonText: { required: true, type: () => String }, clientId: { required: true, type: () => String }, clientSecret: { required: true, type: () => String }, tokenEndpointAuthMethod: { required: true, enum: require("../enum").OAuthTokenEndpointAuthMethod }, timeout: { required: true, type: () => Number, minimum: 1 }, defaultStorageQuota: { required: true, type: () => Number, nullable: true, minimum: 0 }, enabled: { required: true, type: () => Boolean }, issuerUrl: { required: true, type: () => String }, mobileOverrideEnabled: { required: true, type: () => Boolean }, mobileRedirectUri: { required: true, type: () => String, format: "uri" }, scope: { required: true, type: () => String }, signingAlgorithm: { required: true, type: () => String }, profileSigningAlgorithm: { required: true, type: () => String }, storageLabelClaim: { required: true, type: () => String }, storageQuotaClaim: { required: true, type: () => String }, roleClaim: { required: true, type: () => String } };
    }
}
__decorate([
    (0, validation_1.ValidateBoolean)({ description: 'Auto launch' }),
    __metadata("design:type", Boolean)
], SystemConfigOAuthDto.prototype, "autoLaunch", void 0);
__decorate([
    (0, validation_1.ValidateBoolean)({ description: 'Auto register' }),
    __metadata("design:type", Boolean)
], SystemConfigOAuthDto.prototype, "autoRegister", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    (0, swagger_1.ApiProperty)({ description: 'Button text' }),
    __metadata("design:type", String)
], SystemConfigOAuthDto.prototype, "buttonText", void 0);
__decorate([
    (0, class_validator_1.ValidateIf)(isOAuthEnabled),
    (0, class_validator_1.IsNotEmpty)(),
    (0, class_validator_1.IsString)(),
    (0, swagger_1.ApiProperty)({ description: 'Client ID' }),
    __metadata("design:type", String)
], SystemConfigOAuthDto.prototype, "clientId", void 0);
__decorate([
    (0, class_validator_1.ValidateIf)(isOAuthEnabled),
    (0, class_validator_1.IsString)(),
    (0, swagger_1.ApiProperty)({ description: 'Client secret' }),
    __metadata("design:type", String)
], SystemConfigOAuthDto.prototype, "clientSecret", void 0);
__decorate([
    (0, validation_1.ValidateEnum)({
        enum: enum_1.OAuthTokenEndpointAuthMethod,
        name: 'OAuthTokenEndpointAuthMethod',
        description: 'Token endpoint auth method',
    }),
    __metadata("design:type", String)
], SystemConfigOAuthDto.prototype, "tokenEndpointAuthMethod", void 0);
__decorate([
    (0, class_validator_1.IsInt)(),
    (0, class_validator_1.IsPositive)(),
    (0, validation_1.Optional)(),
    (0, swagger_1.ApiProperty)({ type: 'integer', description: 'Timeout' }),
    __metadata("design:type", Number)
], SystemConfigOAuthDto.prototype, "timeout", void 0);
__decorate([
    (0, class_validator_1.IsNumber)(),
    (0, class_validator_1.Min)(0),
    (0, validation_1.Optional)({ nullable: true }),
    (0, swagger_1.ApiProperty)({ type: 'integer', format: 'int64', description: 'Default storage quota' }),
    __metadata("design:type", Object)
], SystemConfigOAuthDto.prototype, "defaultStorageQuota", void 0);
__decorate([
    (0, validation_1.ValidateBoolean)({ description: 'Enabled' }),
    __metadata("design:type", Boolean)
], SystemConfigOAuthDto.prototype, "enabled", void 0);
__decorate([
    (0, class_validator_1.ValidateIf)(isOAuthEnabled),
    (0, class_validator_1.IsNotEmpty)(),
    (0, class_validator_1.IsString)(),
    (0, swagger_1.ApiProperty)({ description: 'Issuer URL' }),
    __metadata("design:type", String)
], SystemConfigOAuthDto.prototype, "issuerUrl", void 0);
__decorate([
    (0, validation_1.ValidateBoolean)({ description: 'Mobile override enabled' }),
    __metadata("design:type", Boolean)
], SystemConfigOAuthDto.prototype, "mobileOverrideEnabled", void 0);
__decorate([
    (0, class_validator_1.ValidateIf)(isOAuthOverrideEnabled),
    (0, class_validator_1.IsUrl)(),
    (0, swagger_1.ApiProperty)({ description: 'Mobile redirect URI' }),
    __metadata("design:type", String)
], SystemConfigOAuthDto.prototype, "mobileRedirectUri", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    (0, swagger_1.ApiProperty)({ description: 'Scope' }),
    __metadata("design:type", String)
], SystemConfigOAuthDto.prototype, "scope", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsNotEmpty)(),
    __metadata("design:type", String)
], SystemConfigOAuthDto.prototype, "signingAlgorithm", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsNotEmpty)(),
    (0, swagger_1.ApiProperty)({ description: 'Profile signing algorithm' }),
    __metadata("design:type", String)
], SystemConfigOAuthDto.prototype, "profileSigningAlgorithm", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    (0, swagger_1.ApiProperty)({ description: 'Storage label claim' }),
    __metadata("design:type", String)
], SystemConfigOAuthDto.prototype, "storageLabelClaim", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    (0, swagger_1.ApiProperty)({ description: 'Storage quota claim' }),
    __metadata("design:type", String)
], SystemConfigOAuthDto.prototype, "storageQuotaClaim", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    (0, swagger_1.ApiProperty)({ description: 'Role claim' }),
    __metadata("design:type", String)
], SystemConfigOAuthDto.prototype, "roleClaim", void 0);
class SystemConfigPasswordLoginDto {
    enabled;
    static _OPENAPI_METADATA_FACTORY() {
        return { enabled: { required: true, type: () => Boolean } };
    }
}
__decorate([
    (0, validation_1.ValidateBoolean)({ description: 'Enabled' }),
    __metadata("design:type", Boolean)
], SystemConfigPasswordLoginDto.prototype, "enabled", void 0);
class SystemConfigReverseGeocodingDto {
    enabled;
    static _OPENAPI_METADATA_FACTORY() {
        return { enabled: { required: true, type: () => Boolean } };
    }
}
__decorate([
    (0, validation_1.ValidateBoolean)({ description: 'Enabled' }),
    __metadata("design:type", Boolean)
], SystemConfigReverseGeocodingDto.prototype, "enabled", void 0);
class SystemConfigFacesDto {
    import;
    static _OPENAPI_METADATA_FACTORY() {
        return { import: { required: true, type: () => Boolean } };
    }
}
__decorate([
    (0, validation_1.ValidateBoolean)({ description: 'Import' }),
    __metadata("design:type", Boolean)
], SystemConfigFacesDto.prototype, "import", void 0);
class SystemConfigMetadataDto {
    faces;
    static _OPENAPI_METADATA_FACTORY() {
        return { faces: { required: true, type: () => SystemConfigFacesDto } };
    }
}
__decorate([
    (0, class_transformer_1.Type)(() => SystemConfigFacesDto),
    (0, class_validator_1.ValidateNested)(),
    (0, class_validator_1.IsObject)(),
    __metadata("design:type", SystemConfigFacesDto)
], SystemConfigMetadataDto.prototype, "faces", void 0);
class SystemConfigServerDto {
    externalDomain;
    loginPageMessage;
    publicUsers;
    static _OPENAPI_METADATA_FACTORY() {
        return { externalDomain: { required: true, type: () => String, format: "uri" }, loginPageMessage: { required: true, type: () => String }, publicUsers: { required: true, type: () => Boolean } };
    }
}
__decorate([
    (0, class_validator_1.ValidateIf)((_, value) => value !== ''),
    (0, class_validator_1.IsUrl)({ require_tld: false, require_protocol: true, protocols: ['http', 'https'] }),
    (0, swagger_1.ApiProperty)({ description: 'External domain' }),
    __metadata("design:type", String)
], SystemConfigServerDto.prototype, "externalDomain", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    (0, swagger_1.ApiProperty)({ description: 'Login page message' }),
    __metadata("design:type", String)
], SystemConfigServerDto.prototype, "loginPageMessage", void 0);
__decorate([
    (0, validation_1.ValidateBoolean)({ description: 'Public users' }),
    __metadata("design:type", Boolean)
], SystemConfigServerDto.prototype, "publicUsers", void 0);
class SystemConfigSmtpTransportDto {
    ignoreCert;
    host;
    port;
    secure;
    username;
    password;
    static _OPENAPI_METADATA_FACTORY() {
        return { ignoreCert: { required: true, type: () => Boolean }, host: { required: true, type: () => String }, port: { required: true, type: () => Number, minimum: 0, maximum: 65535 }, secure: { required: true, type: () => Boolean }, username: { required: true, type: () => String }, password: { required: true, type: () => String } };
    }
}
__decorate([
    (0, validation_1.ValidateBoolean)({ description: 'Whether to ignore SSL certificate errors' }),
    __metadata("design:type", Boolean)
], SystemConfigSmtpTransportDto.prototype, "ignoreCert", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'SMTP server hostname' }),
    (0, class_validator_1.IsNotEmpty)(),
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], SystemConfigSmtpTransportDto.prototype, "host", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'SMTP server port', type: Number, minimum: 0, maximum: 65_535 }),
    (0, class_validator_1.IsNumber)(),
    (0, class_validator_1.Min)(0),
    (0, class_validator_1.Max)(65_535),
    __metadata("design:type", Number)
], SystemConfigSmtpTransportDto.prototype, "port", void 0);
__decorate([
    (0, validation_1.ValidateBoolean)({ description: 'Whether to use secure connection (TLS/SSL)' }),
    __metadata("design:type", Boolean)
], SystemConfigSmtpTransportDto.prototype, "secure", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'SMTP username' }),
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], SystemConfigSmtpTransportDto.prototype, "username", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'SMTP password' }),
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], SystemConfigSmtpTransportDto.prototype, "password", void 0);
class SystemConfigSmtpDto {
    enabled;
    from;
    replyTo;
    transport;
    static _OPENAPI_METADATA_FACTORY() {
        return { enabled: { required: true, type: () => Boolean }, from: { required: true, type: () => String }, replyTo: { required: true, type: () => String }, transport: { required: true, type: () => SystemConfigSmtpTransportDto } };
    }
}
exports.SystemConfigSmtpDto = SystemConfigSmtpDto;
__decorate([
    (0, validation_1.ValidateBoolean)({ description: 'Whether SMTP email notifications are enabled' }),
    __metadata("design:type", Boolean)
], SystemConfigSmtpDto.prototype, "enabled", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Email address to send from' }),
    (0, class_validator_1.ValidateIf)(isEmailNotificationEnabled),
    (0, class_validator_1.IsNotEmpty)(),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsNotEmpty)(),
    __metadata("design:type", String)
], SystemConfigSmtpDto.prototype, "from", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Email address for replies' }),
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], SystemConfigSmtpDto.prototype, "replyTo", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: undefined }),
    (0, class_validator_1.ValidateIf)(isEmailNotificationEnabled),
    (0, class_transformer_1.Type)(() => SystemConfigSmtpTransportDto),
    (0, class_validator_1.ValidateNested)(),
    (0, class_validator_1.IsObject)(),
    __metadata("design:type", SystemConfigSmtpTransportDto)
], SystemConfigSmtpDto.prototype, "transport", void 0);
class SystemConfigNotificationsDto {
    smtp;
    static _OPENAPI_METADATA_FACTORY() {
        return { smtp: { required: true, type: () => require("./system-config.dto").SystemConfigSmtpDto } };
    }
}
__decorate([
    (0, class_transformer_1.Type)(() => SystemConfigSmtpDto),
    (0, class_validator_1.ValidateNested)(),
    (0, class_validator_1.IsObject)(),
    __metadata("design:type", SystemConfigSmtpDto)
], SystemConfigNotificationsDto.prototype, "smtp", void 0);
class SystemConfigTemplateEmailsDto {
    albumInviteTemplate;
    welcomeTemplate;
    albumUpdateTemplate;
    static _OPENAPI_METADATA_FACTORY() {
        return { albumInviteTemplate: { required: true, type: () => String }, welcomeTemplate: { required: true, type: () => String }, albumUpdateTemplate: { required: true, type: () => String } };
    }
}
__decorate([
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], SystemConfigTemplateEmailsDto.prototype, "albumInviteTemplate", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], SystemConfigTemplateEmailsDto.prototype, "welcomeTemplate", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], SystemConfigTemplateEmailsDto.prototype, "albumUpdateTemplate", void 0);
class SystemConfigTemplatesDto {
    email;
    static _OPENAPI_METADATA_FACTORY() {
        return { email: { required: true, type: () => SystemConfigTemplateEmailsDto } };
    }
}
__decorate([
    (0, class_transformer_1.Type)(() => SystemConfigTemplateEmailsDto),
    (0, class_validator_1.ValidateNested)(),
    (0, class_validator_1.IsObject)(),
    __metadata("design:type", SystemConfigTemplateEmailsDto)
], SystemConfigTemplatesDto.prototype, "email", void 0);
class SystemConfigStorageTemplateDto {
    enabled;
    hashVerificationEnabled;
    template;
    static _OPENAPI_METADATA_FACTORY() {
        return { enabled: { required: true, type: () => Boolean }, hashVerificationEnabled: { required: true, type: () => Boolean }, template: { required: true, type: () => String } };
    }
}
__decorate([
    (0, validation_1.ValidateBoolean)({ description: 'Enabled' }),
    __metadata("design:type", Boolean)
], SystemConfigStorageTemplateDto.prototype, "enabled", void 0);
__decorate([
    (0, validation_1.ValidateBoolean)({ description: 'Hash verification enabled' }),
    __metadata("design:type", Boolean)
], SystemConfigStorageTemplateDto.prototype, "hashVerificationEnabled", void 0);
__decorate([
    (0, class_validator_1.IsNotEmpty)(),
    (0, class_validator_1.IsString)(),
    (0, swagger_1.ApiProperty)({ description: 'Template' }),
    __metadata("design:type", String)
], SystemConfigStorageTemplateDto.prototype, "template", void 0);
class SystemConfigTemplateStorageOptionDto {
    yearOptions;
    monthOptions;
    weekOptions;
    dayOptions;
    hourOptions;
    minuteOptions;
    secondOptions;
    presetOptions;
    static _OPENAPI_METADATA_FACTORY() {
        return { yearOptions: { required: true, type: () => [String] }, monthOptions: { required: true, type: () => [String] }, weekOptions: { required: true, type: () => [String] }, dayOptions: { required: true, type: () => [String] }, hourOptions: { required: true, type: () => [String] }, minuteOptions: { required: true, type: () => [String] }, secondOptions: { required: true, type: () => [String] }, presetOptions: { required: true, type: () => [String] } };
    }
}
exports.SystemConfigTemplateStorageOptionDto = SystemConfigTemplateStorageOptionDto;
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Available year format options for storage template' }),
    __metadata("design:type", Array)
], SystemConfigTemplateStorageOptionDto.prototype, "yearOptions", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Available month format options for storage template' }),
    __metadata("design:type", Array)
], SystemConfigTemplateStorageOptionDto.prototype, "monthOptions", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Available week format options for storage template' }),
    __metadata("design:type", Array)
], SystemConfigTemplateStorageOptionDto.prototype, "weekOptions", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Available day format options for storage template' }),
    __metadata("design:type", Array)
], SystemConfigTemplateStorageOptionDto.prototype, "dayOptions", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Available hour format options for storage template' }),
    __metadata("design:type", Array)
], SystemConfigTemplateStorageOptionDto.prototype, "hourOptions", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Available minute format options for storage template' }),
    __metadata("design:type", Array)
], SystemConfigTemplateStorageOptionDto.prototype, "minuteOptions", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Available second format options for storage template' }),
    __metadata("design:type", Array)
], SystemConfigTemplateStorageOptionDto.prototype, "secondOptions", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Available preset template options' }),
    __metadata("design:type", Array)
], SystemConfigTemplateStorageOptionDto.prototype, "presetOptions", void 0);
class SystemConfigThemeDto {
    customCss;
    static _OPENAPI_METADATA_FACTORY() {
        return { customCss: { required: true, type: () => String } };
    }
}
exports.SystemConfigThemeDto = SystemConfigThemeDto;
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Custom CSS for theming' }),
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], SystemConfigThemeDto.prototype, "customCss", void 0);
class SystemConfigGeneratedImageDto {
    format;
    quality;
    size;
    progressive;
    static _OPENAPI_METADATA_FACTORY() {
        return { format: { required: true, enum: require("../enum").ImageFormat }, quality: { required: true, type: () => Number, minimum: 1, maximum: 100 }, size: { required: true, type: () => Number, minimum: 1 }, progressive: { required: false, type: () => Boolean } };
    }
}
__decorate([
    (0, validation_1.ValidateEnum)({ enum: enum_1.ImageFormat, name: 'ImageFormat', description: 'Image format' }),
    __metadata("design:type", String)
], SystemConfigGeneratedImageDto.prototype, "format", void 0);
__decorate([
    (0, class_validator_1.IsInt)(),
    (0, class_validator_1.Min)(1),
    (0, class_validator_1.Max)(100),
    (0, class_transformer_1.Type)(() => Number),
    (0, swagger_1.ApiProperty)({ type: 'integer', description: 'Quality' }),
    __metadata("design:type", Number)
], SystemConfigGeneratedImageDto.prototype, "quality", void 0);
__decorate([
    (0, class_validator_1.IsInt)(),
    (0, class_validator_1.Min)(1),
    (0, class_transformer_1.Type)(() => Number),
    (0, swagger_1.ApiProperty)({ type: 'integer', description: 'Size' }),
    __metadata("design:type", Number)
], SystemConfigGeneratedImageDto.prototype, "size", void 0);
__decorate([
    (0, validation_1.ValidateBoolean)({ optional: true, default: false }),
    __metadata("design:type", Boolean)
], SystemConfigGeneratedImageDto.prototype, "progressive", void 0);
class SystemConfigGeneratedFullsizeImageDto {
    enabled;
    format;
    quality;
    progressive;
    static _OPENAPI_METADATA_FACTORY() {
        return { enabled: { required: true, type: () => Boolean }, format: { required: true, enum: require("../enum").ImageFormat }, quality: { required: true, type: () => Number, minimum: 1, maximum: 100 }, progressive: { required: false, type: () => Boolean } };
    }
}
__decorate([
    (0, validation_1.ValidateBoolean)({ description: 'Enabled' }),
    __metadata("design:type", Boolean)
], SystemConfigGeneratedFullsizeImageDto.prototype, "enabled", void 0);
__decorate([
    (0, validation_1.ValidateEnum)({ enum: enum_1.ImageFormat, name: 'ImageFormat', description: 'Image format' }),
    __metadata("design:type", String)
], SystemConfigGeneratedFullsizeImageDto.prototype, "format", void 0);
__decorate([
    (0, class_validator_1.IsInt)(),
    (0, class_validator_1.Min)(1),
    (0, class_validator_1.Max)(100),
    (0, class_transformer_1.Type)(() => Number),
    (0, swagger_1.ApiProperty)({ type: 'integer', description: 'Quality' }),
    __metadata("design:type", Number)
], SystemConfigGeneratedFullsizeImageDto.prototype, "quality", void 0);
__decorate([
    (0, validation_1.ValidateBoolean)({ optional: true, default: false, description: 'Progressive' }),
    __metadata("design:type", Boolean)
], SystemConfigGeneratedFullsizeImageDto.prototype, "progressive", void 0);
class SystemConfigImageDto {
    thumbnail;
    preview;
    fullsize;
    colorspace;
    extractEmbedded;
    static _OPENAPI_METADATA_FACTORY() {
        return { thumbnail: { required: true, type: () => SystemConfigGeneratedImageDto }, preview: { required: true, type: () => SystemConfigGeneratedImageDto }, fullsize: { required: true, type: () => SystemConfigGeneratedFullsizeImageDto }, colorspace: { required: true, enum: require("../enum").Colorspace }, extractEmbedded: { required: true, type: () => Boolean } };
    }
}
exports.SystemConfigImageDto = SystemConfigImageDto;
__decorate([
    (0, class_transformer_1.Type)(() => SystemConfigGeneratedImageDto),
    (0, class_validator_1.ValidateNested)(),
    (0, class_validator_1.IsObject)(),
    (0, swagger_1.ApiProperty)({ description: undefined }),
    __metadata("design:type", SystemConfigGeneratedImageDto)
], SystemConfigImageDto.prototype, "thumbnail", void 0);
__decorate([
    (0, class_transformer_1.Type)(() => SystemConfigGeneratedImageDto),
    (0, class_validator_1.ValidateNested)(),
    (0, class_validator_1.IsObject)(),
    (0, swagger_1.ApiProperty)({ description: undefined }),
    __metadata("design:type", SystemConfigGeneratedImageDto)
], SystemConfigImageDto.prototype, "preview", void 0);
__decorate([
    (0, class_transformer_1.Type)(() => SystemConfigGeneratedFullsizeImageDto),
    (0, class_validator_1.ValidateNested)(),
    (0, class_validator_1.IsObject)(),
    (0, swagger_1.ApiProperty)({ description: undefined }),
    __metadata("design:type", SystemConfigGeneratedFullsizeImageDto)
], SystemConfigImageDto.prototype, "fullsize", void 0);
__decorate([
    (0, validation_1.ValidateEnum)({ enum: enum_1.Colorspace, name: 'Colorspace', description: 'Colorspace' }),
    __metadata("design:type", String)
], SystemConfigImageDto.prototype, "colorspace", void 0);
__decorate([
    (0, validation_1.ValidateBoolean)({ description: 'Extract embedded' }),
    __metadata("design:type", Boolean)
], SystemConfigImageDto.prototype, "extractEmbedded", void 0);
class SystemConfigTrashDto {
    enabled;
    days;
    static _OPENAPI_METADATA_FACTORY() {
        return { enabled: { required: true, type: () => Boolean }, days: { required: true, type: () => Number, minimum: 0 } };
    }
}
__decorate([
    (0, validation_1.ValidateBoolean)({ description: 'Enabled' }),
    __metadata("design:type", Boolean)
], SystemConfigTrashDto.prototype, "enabled", void 0);
__decorate([
    (0, class_validator_1.IsInt)(),
    (0, class_validator_1.Min)(0),
    (0, class_transformer_1.Type)(() => Number),
    (0, swagger_1.ApiProperty)({ type: 'integer', description: 'Days' }),
    __metadata("design:type", Number)
], SystemConfigTrashDto.prototype, "days", void 0);
class SystemConfigUserDto {
    deleteDelay;
    static _OPENAPI_METADATA_FACTORY() {
        return { deleteDelay: { required: true, type: () => Number, minimum: 1 } };
    }
}
__decorate([
    (0, class_validator_1.IsInt)(),
    (0, class_validator_1.Min)(1),
    (0, class_transformer_1.Type)(() => Number),
    (0, swagger_1.ApiProperty)({ type: 'integer', description: 'Delete delay' }),
    __metadata("design:type", Number)
], SystemConfigUserDto.prototype, "deleteDelay", void 0);
class SystemConfigDto {
    backup;
    ffmpeg;
    logging;
    machineLearning;
    map;
    newVersionCheck;
    nightlyTasks;
    oauth;
    passwordLogin;
    reverseGeocoding;
    metadata;
    storageTemplate;
    job;
    image;
    trash;
    theme;
    library;
    notifications;
    templates;
    server;
    user;
    static _OPENAPI_METADATA_FACTORY() {
        return { backup: { required: true, type: () => require("./system-config.dto").SystemConfigBackupsDto }, ffmpeg: { required: true, type: () => require("./system-config.dto").SystemConfigFFmpegDto }, logging: { required: true, type: () => SystemConfigLoggingDto }, machineLearning: { required: true, type: () => SystemConfigMachineLearningDto }, map: { required: true, type: () => SystemConfigMapDto }, newVersionCheck: { required: true, type: () => SystemConfigNewVersionCheckDto }, nightlyTasks: { required: true, type: () => SystemConfigNightlyTasksDto }, oauth: { required: true, type: () => SystemConfigOAuthDto }, passwordLogin: { required: true, type: () => SystemConfigPasswordLoginDto }, reverseGeocoding: { required: true, type: () => SystemConfigReverseGeocodingDto }, metadata: { required: true, type: () => SystemConfigMetadataDto }, storageTemplate: { required: true, type: () => SystemConfigStorageTemplateDto }, job: { required: true, type: () => SystemConfigJobDto }, image: { required: true, type: () => require("./system-config.dto").SystemConfigImageDto }, trash: { required: true, type: () => SystemConfigTrashDto }, theme: { required: true, type: () => require("./system-config.dto").SystemConfigThemeDto }, library: { required: true, type: () => SystemConfigLibraryDto }, notifications: { required: true, type: () => SystemConfigNotificationsDto }, templates: { required: true, type: () => SystemConfigTemplatesDto }, server: { required: true, type: () => SystemConfigServerDto }, user: { required: true, type: () => SystemConfigUserDto } };
    }
}
exports.SystemConfigDto = SystemConfigDto;
__decorate([
    (0, swagger_1.ApiProperty)({ description: undefined }),
    (0, class_transformer_1.Type)(() => SystemConfigBackupsDto),
    (0, class_validator_1.ValidateNested)(),
    (0, class_validator_1.IsObject)(),
    __metadata("design:type", SystemConfigBackupsDto)
], SystemConfigDto.prototype, "backup", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: undefined }),
    (0, class_transformer_1.Type)(() => SystemConfigFFmpegDto),
    (0, class_validator_1.ValidateNested)(),
    (0, class_validator_1.IsObject)(),
    __metadata("design:type", SystemConfigFFmpegDto)
], SystemConfigDto.prototype, "ffmpeg", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: undefined }),
    (0, class_transformer_1.Type)(() => SystemConfigLoggingDto),
    (0, class_validator_1.ValidateNested)(),
    (0, class_validator_1.IsObject)(),
    __metadata("design:type", SystemConfigLoggingDto)
], SystemConfigDto.prototype, "logging", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: undefined }),
    (0, class_transformer_1.Type)(() => SystemConfigMachineLearningDto),
    (0, class_validator_1.ValidateNested)(),
    (0, class_validator_1.IsObject)(),
    __metadata("design:type", SystemConfigMachineLearningDto)
], SystemConfigDto.prototype, "machineLearning", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: undefined }),
    (0, class_transformer_1.Type)(() => SystemConfigMapDto),
    (0, class_validator_1.ValidateNested)(),
    (0, class_validator_1.IsObject)(),
    __metadata("design:type", SystemConfigMapDto)
], SystemConfigDto.prototype, "map", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: undefined }),
    (0, class_transformer_1.Type)(() => SystemConfigNewVersionCheckDto),
    (0, class_validator_1.ValidateNested)(),
    (0, class_validator_1.IsObject)(),
    __metadata("design:type", SystemConfigNewVersionCheckDto)
], SystemConfigDto.prototype, "newVersionCheck", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: undefined }),
    (0, class_transformer_1.Type)(() => SystemConfigNightlyTasksDto),
    (0, class_validator_1.ValidateNested)(),
    (0, class_validator_1.IsObject)(),
    __metadata("design:type", SystemConfigNightlyTasksDto)
], SystemConfigDto.prototype, "nightlyTasks", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: undefined }),
    (0, class_transformer_1.Type)(() => SystemConfigOAuthDto),
    (0, class_validator_1.ValidateNested)(),
    (0, class_validator_1.IsObject)(),
    __metadata("design:type", SystemConfigOAuthDto)
], SystemConfigDto.prototype, "oauth", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: undefined }),
    (0, class_transformer_1.Type)(() => SystemConfigPasswordLoginDto),
    (0, class_validator_1.ValidateNested)(),
    (0, class_validator_1.IsObject)(),
    __metadata("design:type", SystemConfigPasswordLoginDto)
], SystemConfigDto.prototype, "passwordLogin", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: undefined }),
    (0, class_transformer_1.Type)(() => SystemConfigReverseGeocodingDto),
    (0, class_validator_1.ValidateNested)(),
    (0, class_validator_1.IsObject)(),
    __metadata("design:type", SystemConfigReverseGeocodingDto)
], SystemConfigDto.prototype, "reverseGeocoding", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: undefined }),
    (0, class_transformer_1.Type)(() => SystemConfigMetadataDto),
    (0, class_validator_1.ValidateNested)(),
    (0, class_validator_1.IsObject)(),
    __metadata("design:type", SystemConfigMetadataDto)
], SystemConfigDto.prototype, "metadata", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: undefined }),
    (0, class_transformer_1.Type)(() => SystemConfigStorageTemplateDto),
    (0, class_validator_1.ValidateNested)(),
    (0, class_validator_1.IsObject)(),
    __metadata("design:type", SystemConfigStorageTemplateDto)
], SystemConfigDto.prototype, "storageTemplate", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: undefined }),
    (0, class_transformer_1.Type)(() => SystemConfigJobDto),
    (0, class_validator_1.ValidateNested)(),
    (0, class_validator_1.IsObject)(),
    __metadata("design:type", SystemConfigJobDto)
], SystemConfigDto.prototype, "job", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: undefined }),
    (0, class_transformer_1.Type)(() => SystemConfigImageDto),
    (0, class_validator_1.ValidateNested)(),
    (0, class_validator_1.IsObject)(),
    __metadata("design:type", SystemConfigImageDto)
], SystemConfigDto.prototype, "image", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: undefined }),
    (0, class_transformer_1.Type)(() => SystemConfigTrashDto),
    (0, class_validator_1.ValidateNested)(),
    (0, class_validator_1.IsObject)(),
    __metadata("design:type", SystemConfigTrashDto)
], SystemConfigDto.prototype, "trash", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: undefined }),
    (0, class_transformer_1.Type)(() => SystemConfigThemeDto),
    (0, class_validator_1.ValidateNested)(),
    (0, class_validator_1.IsObject)(),
    __metadata("design:type", SystemConfigThemeDto)
], SystemConfigDto.prototype, "theme", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: undefined }),
    (0, class_transformer_1.Type)(() => SystemConfigLibraryDto),
    (0, class_validator_1.ValidateNested)(),
    (0, class_validator_1.IsObject)(),
    __metadata("design:type", SystemConfigLibraryDto)
], SystemConfigDto.prototype, "library", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: undefined }),
    (0, class_transformer_1.Type)(() => SystemConfigNotificationsDto),
    (0, class_validator_1.ValidateNested)(),
    (0, class_validator_1.IsObject)(),
    __metadata("design:type", SystemConfigNotificationsDto)
], SystemConfigDto.prototype, "notifications", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: undefined }),
    (0, class_transformer_1.Type)(() => SystemConfigTemplatesDto),
    (0, class_validator_1.ValidateNested)(),
    (0, class_validator_1.IsObject)(),
    __metadata("design:type", SystemConfigTemplatesDto)
], SystemConfigDto.prototype, "templates", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: undefined }),
    (0, class_transformer_1.Type)(() => SystemConfigServerDto),
    (0, class_validator_1.ValidateNested)(),
    (0, class_validator_1.IsObject)(),
    __metadata("design:type", SystemConfigServerDto)
], SystemConfigDto.prototype, "server", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: undefined }),
    (0, class_transformer_1.Type)(() => SystemConfigUserDto),
    (0, class_validator_1.ValidateNested)(),
    (0, class_validator_1.IsObject)(),
    __metadata("design:type", SystemConfigUserDto)
], SystemConfigDto.prototype, "user", void 0);
function mapConfig(config) {
    return config;
}
//# sourceMappingURL=system-config.dto.js.map