"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.mapPreferences = exports.UserPreferencesResponseDto = exports.UserPreferencesUpdateDto = void 0;
const openapi = require("@nestjs/swagger");
const swagger_1 = require("@nestjs/swagger");
const class_transformer_1 = require("class-transformer");
const class_validator_1 = require("class-validator");
const enum_1 = require("../enum");
const validation_1 = require("../validation");
class AvatarUpdate {
    color;
    static _OPENAPI_METADATA_FACTORY() {
        return { color: { required: false, enum: require("../enum").UserAvatarColor } };
    }
}
__decorate([
    (0, validation_1.ValidateEnum)({ enum: enum_1.UserAvatarColor, name: 'UserAvatarColor', optional: true, description: 'Avatar color' }),
    __metadata("design:type", String)
], AvatarUpdate.prototype, "color", void 0);
class MemoriesUpdate {
    enabled;
    duration;
    static _OPENAPI_METADATA_FACTORY() {
        return { enabled: { required: false, type: () => Boolean }, duration: { required: false, type: () => Number, minimum: 1 } };
    }
}
__decorate([
    (0, validation_1.ValidateBoolean)({ optional: true, description: 'Whether memories are enabled' }),
    __metadata("design:type", Boolean)
], MemoriesUpdate.prototype, "enabled", void 0);
__decorate([
    (0, validation_1.Optional)(),
    (0, class_validator_1.IsInt)(),
    (0, class_validator_1.IsPositive)(),
    (0, swagger_1.ApiProperty)({ type: 'integer', description: 'Memory duration in seconds' }),
    __metadata("design:type", Number)
], MemoriesUpdate.prototype, "duration", void 0);
class RatingsUpdate {
    enabled;
    static _OPENAPI_METADATA_FACTORY() {
        return { enabled: { required: false, type: () => Boolean } };
    }
}
__decorate([
    (0, validation_1.ValidateBoolean)({ optional: true, description: 'Whether ratings are enabled' }),
    __metadata("design:type", Boolean)
], RatingsUpdate.prototype, "enabled", void 0);
let AlbumsUpdate = class AlbumsUpdate {
    defaultAssetOrder;
    static _OPENAPI_METADATA_FACTORY() {
        return { defaultAssetOrder: { required: false, enum: require("../enum").AssetOrder } };
    }
};
__decorate([
    (0, validation_1.ValidateEnum)({ enum: enum_1.AssetOrder, name: 'AssetOrder', optional: true, description: 'Default asset order for albums' }),
    __metadata("design:type", String)
], AlbumsUpdate.prototype, "defaultAssetOrder", void 0);
AlbumsUpdate = __decorate([
    (0, swagger_1.ApiSchema)({ description: 'Album preferences' })
], AlbumsUpdate);
class FoldersUpdate {
    enabled;
    sidebarWeb;
    static _OPENAPI_METADATA_FACTORY() {
        return { enabled: { required: false, type: () => Boolean }, sidebarWeb: { required: false, type: () => Boolean } };
    }
}
__decorate([
    (0, validation_1.ValidateBoolean)({ optional: true, description: 'Whether folders are enabled' }),
    __metadata("design:type", Boolean)
], FoldersUpdate.prototype, "enabled", void 0);
__decorate([
    (0, validation_1.ValidateBoolean)({ optional: true, description: 'Whether folders appear in web sidebar' }),
    __metadata("design:type", Boolean)
], FoldersUpdate.prototype, "sidebarWeb", void 0);
class PeopleUpdate {
    enabled;
    sidebarWeb;
    static _OPENAPI_METADATA_FACTORY() {
        return { enabled: { required: false, type: () => Boolean }, sidebarWeb: { required: false, type: () => Boolean } };
    }
}
__decorate([
    (0, validation_1.ValidateBoolean)({ optional: true, description: 'Whether people are enabled' }),
    __metadata("design:type", Boolean)
], PeopleUpdate.prototype, "enabled", void 0);
__decorate([
    (0, validation_1.ValidateBoolean)({ optional: true, description: 'Whether people appear in web sidebar' }),
    __metadata("design:type", Boolean)
], PeopleUpdate.prototype, "sidebarWeb", void 0);
class SharedLinksUpdate {
    enabled;
    sidebarWeb;
    static _OPENAPI_METADATA_FACTORY() {
        return { enabled: { required: false, type: () => Boolean }, sidebarWeb: { required: false, type: () => Boolean } };
    }
}
__decorate([
    (0, validation_1.ValidateBoolean)({ optional: true, description: 'Whether shared links are enabled' }),
    __metadata("design:type", Boolean)
], SharedLinksUpdate.prototype, "enabled", void 0);
__decorate([
    (0, validation_1.ValidateBoolean)({ optional: true, description: 'Whether shared links appear in web sidebar' }),
    __metadata("design:type", Boolean)
], SharedLinksUpdate.prototype, "sidebarWeb", void 0);
class TagsUpdate {
    enabled;
    sidebarWeb;
    static _OPENAPI_METADATA_FACTORY() {
        return { enabled: { required: false, type: () => Boolean }, sidebarWeb: { required: false, type: () => Boolean } };
    }
}
__decorate([
    (0, validation_1.ValidateBoolean)({ optional: true, description: 'Whether tags are enabled' }),
    __metadata("design:type", Boolean)
], TagsUpdate.prototype, "enabled", void 0);
__decorate([
    (0, validation_1.ValidateBoolean)({ optional: true, description: 'Whether tags appear in web sidebar' }),
    __metadata("design:type", Boolean)
], TagsUpdate.prototype, "sidebarWeb", void 0);
class EmailNotificationsUpdate {
    enabled;
    albumInvite;
    albumUpdate;
    static _OPENAPI_METADATA_FACTORY() {
        return { enabled: { required: false, type: () => Boolean }, albumInvite: { required: false, type: () => Boolean }, albumUpdate: { required: false, type: () => Boolean } };
    }
}
__decorate([
    (0, validation_1.ValidateBoolean)({ optional: true, description: 'Whether email notifications are enabled' }),
    __metadata("design:type", Boolean)
], EmailNotificationsUpdate.prototype, "enabled", void 0);
__decorate([
    (0, validation_1.ValidateBoolean)({ optional: true, description: 'Whether to receive email notifications for album invites' }),
    __metadata("design:type", Boolean)
], EmailNotificationsUpdate.prototype, "albumInvite", void 0);
__decorate([
    (0, validation_1.ValidateBoolean)({ optional: true, description: 'Whether to receive email notifications for album updates' }),
    __metadata("design:type", Boolean)
], EmailNotificationsUpdate.prototype, "albumUpdate", void 0);
class DownloadUpdate {
    archiveSize;
    includeEmbeddedVideos;
    static _OPENAPI_METADATA_FACTORY() {
        return { archiveSize: { required: false, type: () => Number, minimum: 1 }, includeEmbeddedVideos: { required: false, type: () => Boolean } };
    }
}
__decorate([
    (0, validation_1.Optional)(),
    (0, class_validator_1.IsInt)(),
    (0, class_validator_1.IsPositive)(),
    (0, swagger_1.ApiPropertyOptional)({ type: 'integer', description: 'Maximum archive size in bytes' }),
    __metadata("design:type", Number)
], DownloadUpdate.prototype, "archiveSize", void 0);
__decorate([
    (0, validation_1.ValidateBoolean)({ optional: true, description: 'Whether to include embedded videos in downloads' }),
    __metadata("design:type", Boolean)
], DownloadUpdate.prototype, "includeEmbeddedVideos", void 0);
class PurchaseUpdate {
    showSupportBadge;
    hideBuyButtonUntil;
    static _OPENAPI_METADATA_FACTORY() {
        return { showSupportBadge: { required: false, type: () => Boolean }, hideBuyButtonUntil: { required: false, type: () => String } };
    }
}
__decorate([
    (0, validation_1.ValidateBoolean)({ optional: true, description: 'Whether to show support badge' }),
    __metadata("design:type", Boolean)
], PurchaseUpdate.prototype, "showSupportBadge", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: 'Date until which to hide buy button' }),
    (0, class_validator_1.IsDateString)(),
    (0, validation_1.Optional)(),
    __metadata("design:type", String)
], PurchaseUpdate.prototype, "hideBuyButtonUntil", void 0);
class CastUpdate {
    gCastEnabled;
    static _OPENAPI_METADATA_FACTORY() {
        return { gCastEnabled: { required: false, type: () => Boolean } };
    }
}
__decorate([
    (0, validation_1.ValidateBoolean)({ optional: true, description: 'Whether Google Cast is enabled' }),
    __metadata("design:type", Boolean)
], CastUpdate.prototype, "gCastEnabled", void 0);
class UserPreferencesUpdateDto {
    albums;
    folders;
    memories;
    people;
    ratings;
    sharedLinks;
    tags;
    avatar;
    emailNotifications;
    download;
    purchase;
    cast;
    static _OPENAPI_METADATA_FACTORY() {
        return { albums: { required: false, type: () => AlbumsUpdate }, folders: { required: false, type: () => FoldersUpdate }, memories: { required: false, type: () => MemoriesUpdate }, people: { required: false, type: () => PeopleUpdate }, ratings: { required: false, type: () => RatingsUpdate }, sharedLinks: { required: false, type: () => SharedLinksUpdate }, tags: { required: false, type: () => TagsUpdate }, avatar: { required: false, type: () => AvatarUpdate }, emailNotifications: { required: false, type: () => EmailNotificationsUpdate }, download: { required: false, type: () => DownloadUpdate }, purchase: { required: false, type: () => PurchaseUpdate }, cast: { required: false, type: () => CastUpdate } };
    }
}
exports.UserPreferencesUpdateDto = UserPreferencesUpdateDto;
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: undefined }),
    (0, validation_1.Optional)(),
    (0, class_validator_1.ValidateNested)(),
    (0, class_transformer_1.Type)(() => AlbumsUpdate),
    __metadata("design:type", AlbumsUpdate)
], UserPreferencesUpdateDto.prototype, "albums", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: undefined }),
    (0, validation_1.Optional)(),
    (0, class_validator_1.ValidateNested)(),
    (0, class_transformer_1.Type)(() => FoldersUpdate),
    __metadata("design:type", FoldersUpdate)
], UserPreferencesUpdateDto.prototype, "folders", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: undefined }),
    (0, validation_1.Optional)(),
    (0, class_validator_1.ValidateNested)(),
    (0, class_transformer_1.Type)(() => MemoriesUpdate),
    __metadata("design:type", MemoriesUpdate)
], UserPreferencesUpdateDto.prototype, "memories", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: undefined }),
    (0, validation_1.Optional)(),
    (0, class_validator_1.ValidateNested)(),
    (0, class_transformer_1.Type)(() => PeopleUpdate),
    __metadata("design:type", PeopleUpdate)
], UserPreferencesUpdateDto.prototype, "people", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: undefined }),
    (0, validation_1.Optional)(),
    (0, class_validator_1.ValidateNested)(),
    (0, class_transformer_1.Type)(() => RatingsUpdate),
    __metadata("design:type", RatingsUpdate)
], UserPreferencesUpdateDto.prototype, "ratings", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: undefined, required: false }),
    (0, validation_1.Optional)(),
    (0, class_validator_1.ValidateNested)(),
    (0, class_transformer_1.Type)(() => SharedLinksUpdate),
    __metadata("design:type", SharedLinksUpdate)
], UserPreferencesUpdateDto.prototype, "sharedLinks", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: undefined }),
    (0, validation_1.Optional)(),
    (0, class_validator_1.ValidateNested)(),
    (0, class_transformer_1.Type)(() => TagsUpdate),
    __metadata("design:type", TagsUpdate)
], UserPreferencesUpdateDto.prototype, "tags", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: undefined }),
    (0, validation_1.Optional)(),
    (0, class_validator_1.ValidateNested)(),
    (0, class_transformer_1.Type)(() => AvatarUpdate),
    __metadata("design:type", AvatarUpdate)
], UserPreferencesUpdateDto.prototype, "avatar", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: undefined }),
    (0, validation_1.Optional)(),
    (0, class_validator_1.ValidateNested)(),
    (0, class_transformer_1.Type)(() => EmailNotificationsUpdate),
    __metadata("design:type", EmailNotificationsUpdate)
], UserPreferencesUpdateDto.prototype, "emailNotifications", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: undefined }),
    (0, validation_1.Optional)(),
    (0, class_validator_1.ValidateNested)(),
    (0, class_transformer_1.Type)(() => DownloadUpdate),
    __metadata("design:type", DownloadUpdate)
], UserPreferencesUpdateDto.prototype, "download", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: undefined }),
    (0, validation_1.Optional)(),
    (0, class_validator_1.ValidateNested)(),
    (0, class_transformer_1.Type)(() => PurchaseUpdate),
    __metadata("design:type", PurchaseUpdate)
], UserPreferencesUpdateDto.prototype, "purchase", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: undefined }),
    (0, validation_1.Optional)(),
    (0, class_validator_1.ValidateNested)(),
    (0, class_transformer_1.Type)(() => CastUpdate),
    __metadata("design:type", CastUpdate)
], UserPreferencesUpdateDto.prototype, "cast", void 0);
class AlbumsResponse {
    defaultAssetOrder = enum_1.AssetOrder.Desc;
    static _OPENAPI_METADATA_FACTORY() {
        return { defaultAssetOrder: { required: true, default: enum_1.AssetOrder.Desc, enum: require("../enum").AssetOrder } };
    }
}
__decorate([
    (0, validation_1.ValidateEnum)({ enum: enum_1.AssetOrder, name: 'AssetOrder', description: 'Default asset order for albums' }),
    __metadata("design:type", String)
], AlbumsResponse.prototype, "defaultAssetOrder", void 0);
class RatingsResponse {
    enabled = false;
    static _OPENAPI_METADATA_FACTORY() {
        return { enabled: { required: true, type: () => Boolean, default: false } };
    }
}
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Whether ratings are enabled' }),
    __metadata("design:type", Boolean)
], RatingsResponse.prototype, "enabled", void 0);
class MemoriesResponse {
    enabled = true;
    duration = 5;
    static _OPENAPI_METADATA_FACTORY() {
        return { enabled: { required: true, type: () => Boolean, default: true }, duration: { required: true, type: () => Number, default: 5 } };
    }
}
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Whether memories are enabled' }),
    __metadata("design:type", Boolean)
], MemoriesResponse.prototype, "enabled", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer', description: 'Memory duration in seconds' }),
    __metadata("design:type", Number)
], MemoriesResponse.prototype, "duration", void 0);
class FoldersResponse {
    enabled = false;
    sidebarWeb = false;
    static _OPENAPI_METADATA_FACTORY() {
        return { enabled: { required: true, type: () => Boolean, default: false }, sidebarWeb: { required: true, type: () => Boolean, default: false } };
    }
}
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Whether folders are enabled' }),
    __metadata("design:type", Boolean)
], FoldersResponse.prototype, "enabled", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Whether folders appear in web sidebar' }),
    __metadata("design:type", Boolean)
], FoldersResponse.prototype, "sidebarWeb", void 0);
class PeopleResponse {
    enabled = true;
    sidebarWeb = false;
    static _OPENAPI_METADATA_FACTORY() {
        return { enabled: { required: true, type: () => Boolean, default: true }, sidebarWeb: { required: true, type: () => Boolean, default: false } };
    }
}
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Whether people are enabled' }),
    __metadata("design:type", Boolean)
], PeopleResponse.prototype, "enabled", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Whether people appear in web sidebar' }),
    __metadata("design:type", Boolean)
], PeopleResponse.prototype, "sidebarWeb", void 0);
class TagsResponse {
    enabled = true;
    sidebarWeb = true;
    static _OPENAPI_METADATA_FACTORY() {
        return { enabled: { required: true, type: () => Boolean, default: true }, sidebarWeb: { required: true, type: () => Boolean, default: true } };
    }
}
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Whether tags are enabled' }),
    __metadata("design:type", Boolean)
], TagsResponse.prototype, "enabled", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Whether tags appear in web sidebar' }),
    __metadata("design:type", Boolean)
], TagsResponse.prototype, "sidebarWeb", void 0);
class SharedLinksResponse {
    enabled = true;
    sidebarWeb = false;
    static _OPENAPI_METADATA_FACTORY() {
        return { enabled: { required: true, type: () => Boolean, default: true }, sidebarWeb: { required: true, type: () => Boolean, default: false } };
    }
}
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Whether shared links are enabled' }),
    __metadata("design:type", Boolean)
], SharedLinksResponse.prototype, "enabled", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Whether shared links appear in web sidebar' }),
    __metadata("design:type", Boolean)
], SharedLinksResponse.prototype, "sidebarWeb", void 0);
class EmailNotificationsResponse {
    enabled;
    albumInvite;
    albumUpdate;
    static _OPENAPI_METADATA_FACTORY() {
        return { enabled: { required: true, type: () => Boolean }, albumInvite: { required: true, type: () => Boolean }, albumUpdate: { required: true, type: () => Boolean } };
    }
}
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Whether email notifications are enabled' }),
    __metadata("design:type", Boolean)
], EmailNotificationsResponse.prototype, "enabled", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Whether to receive email notifications for album invites' }),
    __metadata("design:type", Boolean)
], EmailNotificationsResponse.prototype, "albumInvite", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Whether to receive email notifications for album updates' }),
    __metadata("design:type", Boolean)
], EmailNotificationsResponse.prototype, "albumUpdate", void 0);
class DownloadResponse {
    archiveSize;
    includeEmbeddedVideos = false;
    static _OPENAPI_METADATA_FACTORY() {
        return { archiveSize: { required: true, type: () => Number }, includeEmbeddedVideos: { required: true, type: () => Boolean, default: false } };
    }
}
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer', description: 'Maximum archive size in bytes' }),
    __metadata("design:type", Number)
], DownloadResponse.prototype, "archiveSize", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Whether to include embedded videos in downloads' }),
    __metadata("design:type", Boolean)
], DownloadResponse.prototype, "includeEmbeddedVideos", void 0);
class PurchaseResponse {
    showSupportBadge;
    hideBuyButtonUntil;
    static _OPENAPI_METADATA_FACTORY() {
        return { showSupportBadge: { required: true, type: () => Boolean }, hideBuyButtonUntil: { required: true, type: () => String } };
    }
}
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Whether to show support badge' }),
    __metadata("design:type", Boolean)
], PurchaseResponse.prototype, "showSupportBadge", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Date until which to hide buy button' }),
    __metadata("design:type", String)
], PurchaseResponse.prototype, "hideBuyButtonUntil", void 0);
class CastResponse {
    gCastEnabled = false;
    static _OPENAPI_METADATA_FACTORY() {
        return { gCastEnabled: { required: true, type: () => Boolean, default: false } };
    }
}
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Whether Google Cast is enabled' }),
    __metadata("design:type", Boolean)
], CastResponse.prototype, "gCastEnabled", void 0);
class UserPreferencesResponseDto {
    albums;
    folders;
    memories;
    people;
    ratings;
    sharedLinks;
    tags;
    emailNotifications;
    download;
    purchase;
    cast;
    static _OPENAPI_METADATA_FACTORY() {
        return { albums: { required: true, type: () => AlbumsResponse }, folders: { required: true, type: () => FoldersResponse }, memories: { required: true, type: () => MemoriesResponse }, people: { required: true, type: () => PeopleResponse }, ratings: { required: true, type: () => RatingsResponse }, sharedLinks: { required: true, type: () => SharedLinksResponse }, tags: { required: true, type: () => TagsResponse }, emailNotifications: { required: true, type: () => EmailNotificationsResponse }, download: { required: true, type: () => DownloadResponse }, purchase: { required: true, type: () => PurchaseResponse }, cast: { required: true, type: () => CastResponse } };
    }
}
exports.UserPreferencesResponseDto = UserPreferencesResponseDto;
__decorate([
    (0, swagger_1.ApiProperty)({ description: undefined }),
    __metadata("design:type", AlbumsResponse)
], UserPreferencesResponseDto.prototype, "albums", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: undefined }),
    __metadata("design:type", FoldersResponse)
], UserPreferencesResponseDto.prototype, "folders", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: undefined }),
    __metadata("design:type", MemoriesResponse)
], UserPreferencesResponseDto.prototype, "memories", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: undefined }),
    __metadata("design:type", PeopleResponse)
], UserPreferencesResponseDto.prototype, "people", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: undefined }),
    __metadata("design:type", RatingsResponse)
], UserPreferencesResponseDto.prototype, "ratings", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: undefined }),
    __metadata("design:type", SharedLinksResponse)
], UserPreferencesResponseDto.prototype, "sharedLinks", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: undefined }),
    __metadata("design:type", TagsResponse)
], UserPreferencesResponseDto.prototype, "tags", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: undefined }),
    __metadata("design:type", EmailNotificationsResponse)
], UserPreferencesResponseDto.prototype, "emailNotifications", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: undefined }),
    __metadata("design:type", DownloadResponse)
], UserPreferencesResponseDto.prototype, "download", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: undefined }),
    __metadata("design:type", PurchaseResponse)
], UserPreferencesResponseDto.prototype, "purchase", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: undefined }),
    __metadata("design:type", CastResponse)
], UserPreferencesResponseDto.prototype, "cast", void 0);
const mapPreferences = (preferences) => {
    return preferences;
};
exports.mapPreferences = mapPreferences;
//# sourceMappingURL=user-preferences.dto.js.map