"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserAdminResponseDto = exports.UserAdminDeleteDto = exports.UserAdminUpdateDto = exports.UserAdminCreateDto = exports.UserAdminSearchDto = exports.mapUser = exports.UserLicense = exports.UserResponseDto = exports.UserUpdateMeDto = void 0;
exports.mapUserAdmin = mapUserAdmin;
const openapi = require("@nestjs/swagger");
const swagger_1 = require("@nestjs/swagger");
const class_transformer_1 = require("class-transformer");
const class_validator_1 = require("class-validator");
const enum_1 = require("../enum");
const validation_1 = require("../validation");
class UserUpdateMeDto {
    email;
    password;
    name;
    avatarColor;
    static _OPENAPI_METADATA_FACTORY() {
        return { email: { required: false, type: () => String, format: "email" }, password: { required: false, type: () => String }, name: { required: false, type: () => String }, avatarColor: { required: false, nullable: true, enum: require("../enum").UserAvatarColor } };
    }
}
exports.UserUpdateMeDto = UserUpdateMeDto;
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: 'User email' }),
    (0, validation_1.Optional)(),
    (0, class_validator_1.IsEmail)({ require_tld: false }),
    (0, class_transformer_1.Transform)(validation_1.toEmail),
    __metadata("design:type", String)
], UserUpdateMeDto.prototype, "email", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: 'User password (deprecated, use change password endpoint)' }),
    (0, validation_1.Optional)(),
    (0, class_validator_1.IsNotEmpty)(),
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], UserUpdateMeDto.prototype, "password", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: 'User name' }),
    (0, validation_1.Optional)(),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsNotEmpty)(),
    __metadata("design:type", String)
], UserUpdateMeDto.prototype, "name", void 0);
__decorate([
    (0, validation_1.ValidateEnum)({ enum: enum_1.UserAvatarColor, name: 'UserAvatarColor', optional: true, description: 'Avatar color' }),
    __metadata("design:type", Object)
], UserUpdateMeDto.prototype, "avatarColor", void 0);
class UserResponseDto {
    id;
    name;
    email;
    profileImagePath;
    avatarColor;
    profileChangedAt;
    static _OPENAPI_METADATA_FACTORY() {
        return { id: { required: true, type: () => String }, name: { required: true, type: () => String }, email: { required: true, type: () => String }, profileImagePath: { required: true, type: () => String }, avatarColor: { required: true, enum: require("../enum").UserAvatarColor }, profileChangedAt: { required: true, type: () => Date } };
    }
}
exports.UserResponseDto = UserResponseDto;
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'User ID' }),
    __metadata("design:type", String)
], UserResponseDto.prototype, "id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'User name' }),
    __metadata("design:type", String)
], UserResponseDto.prototype, "name", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'User email' }),
    __metadata("design:type", String)
], UserResponseDto.prototype, "email", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Profile image path' }),
    __metadata("design:type", String)
], UserResponseDto.prototype, "profileImagePath", void 0);
__decorate([
    (0, validation_1.ValidateEnum)({ enum: enum_1.UserAvatarColor, name: 'UserAvatarColor', description: 'Avatar color' }),
    __metadata("design:type", String)
], UserResponseDto.prototype, "avatarColor", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Profile change date' }),
    __metadata("design:type", Date)
], UserResponseDto.prototype, "profileChangedAt", void 0);
class UserLicense {
    licenseKey;
    activationKey;
    activatedAt;
    static _OPENAPI_METADATA_FACTORY() {
        return { licenseKey: { required: true, type: () => String }, activationKey: { required: true, type: () => String }, activatedAt: { required: true, type: () => Date } };
    }
}
exports.UserLicense = UserLicense;
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'License key' }),
    __metadata("design:type", String)
], UserLicense.prototype, "licenseKey", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Activation key' }),
    __metadata("design:type", String)
], UserLicense.prototype, "activationKey", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Activation date' }),
    __metadata("design:type", Date)
], UserLicense.prototype, "activatedAt", void 0);
const emailToAvatarColor = (email) => {
    const values = Object.values(enum_1.UserAvatarColor);
    const randomIndex = Math.floor([...email].map((letter) => letter.codePointAt(0) ?? 0).reduce((a, b) => a + b, 0) % values.length);
    return values[randomIndex];
};
const mapUser = (entity) => {
    return {
        id: entity.id,
        email: entity.email,
        name: entity.name,
        profileImagePath: entity.profileImagePath,
        avatarColor: entity.avatarColor ?? emailToAvatarColor(entity.email),
        profileChangedAt: entity.profileChangedAt,
    };
};
exports.mapUser = mapUser;
class UserAdminSearchDto {
    withDeleted;
    id;
    static _OPENAPI_METADATA_FACTORY() {
        return { withDeleted: { required: false, type: () => Boolean }, id: { required: false, type: () => String } };
    }
}
exports.UserAdminSearchDto = UserAdminSearchDto;
__decorate([
    (0, validation_1.ValidateBoolean)({ optional: true, description: 'Include deleted users' }),
    __metadata("design:type", Boolean)
], UserAdminSearchDto.prototype, "withDeleted", void 0);
__decorate([
    (0, validation_1.ValidateUUID)({ optional: true, description: 'User ID filter' }),
    __metadata("design:type", String)
], UserAdminSearchDto.prototype, "id", void 0);
class UserAdminCreateDto {
    email;
    password;
    name;
    avatarColor;
    storageLabel;
    quotaSizeInBytes;
    shouldChangePassword;
    notify;
    isAdmin;
    static _OPENAPI_METADATA_FACTORY() {
        return { email: { required: true, type: () => String, format: "email" }, password: { required: true, type: () => String }, name: { required: true, type: () => String }, avatarColor: { required: false, nullable: true, enum: require("../enum").UserAvatarColor }, storageLabel: { required: false, type: () => String, nullable: true }, quotaSizeInBytes: { required: false, type: () => Number, nullable: true, minimum: 0 }, shouldChangePassword: { required: false, type: () => Boolean }, notify: { required: false, type: () => Boolean }, isAdmin: { required: false, type: () => Boolean } };
    }
}
exports.UserAdminCreateDto = UserAdminCreateDto;
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'User email' }),
    (0, class_validator_1.IsEmail)({ require_tld: false }),
    (0, class_transformer_1.Transform)(validation_1.toEmail),
    __metadata("design:type", String)
], UserAdminCreateDto.prototype, "email", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'User password' }),
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], UserAdminCreateDto.prototype, "password", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'User name' }),
    (0, class_validator_1.IsNotEmpty)(),
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], UserAdminCreateDto.prototype, "name", void 0);
__decorate([
    (0, validation_1.ValidateEnum)({ enum: enum_1.UserAvatarColor, name: 'UserAvatarColor', optional: true, description: 'Avatar color' }),
    __metadata("design:type", Object)
], UserAdminCreateDto.prototype, "avatarColor", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: 'Storage label' }),
    (0, validation_1.Optional)({ nullable: true }),
    (0, class_validator_1.IsString)(),
    (0, class_transformer_1.Transform)(validation_1.toSanitized),
    __metadata("design:type", Object)
], UserAdminCreateDto.prototype, "storageLabel", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ type: 'integer', format: 'int64', description: 'Storage quota in bytes' }),
    (0, validation_1.Optional)({ nullable: true }),
    (0, class_validator_1.IsInt)(),
    (0, class_validator_1.Min)(0),
    __metadata("design:type", Object)
], UserAdminCreateDto.prototype, "quotaSizeInBytes", void 0);
__decorate([
    (0, validation_1.ValidateBoolean)({ optional: true, description: 'Require password change on next login' }),
    __metadata("design:type", Boolean)
], UserAdminCreateDto.prototype, "shouldChangePassword", void 0);
__decorate([
    (0, validation_1.ValidateBoolean)({ optional: true, description: 'Send notification email' }),
    __metadata("design:type", Boolean)
], UserAdminCreateDto.prototype, "notify", void 0);
__decorate([
    (0, validation_1.ValidateBoolean)({ optional: true, description: 'Grant admin privileges' }),
    __metadata("design:type", Boolean)
], UserAdminCreateDto.prototype, "isAdmin", void 0);
class UserAdminUpdateDto {
    email;
    password;
    pinCode;
    name;
    avatarColor;
    storageLabel;
    shouldChangePassword;
    quotaSizeInBytes;
    isAdmin;
    static _OPENAPI_METADATA_FACTORY() {
        return { email: { required: false, type: () => String, format: "email" }, password: { required: false, type: () => String }, pinCode: { required: false, type: () => String, nullable: true }, name: { required: false, type: () => String }, avatarColor: { required: false, nullable: true, enum: require("../enum").UserAvatarColor }, storageLabel: { required: false, type: () => String, nullable: true }, shouldChangePassword: { required: false, type: () => Boolean }, quotaSizeInBytes: { required: false, type: () => Number, nullable: true, minimum: 0 }, isAdmin: { required: false, type: () => Boolean } };
    }
}
exports.UserAdminUpdateDto = UserAdminUpdateDto;
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: 'User email' }),
    (0, validation_1.Optional)(),
    (0, class_validator_1.IsEmail)({ require_tld: false }),
    (0, class_transformer_1.Transform)(validation_1.toEmail),
    __metadata("design:type", String)
], UserAdminUpdateDto.prototype, "email", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: 'User password' }),
    (0, validation_1.Optional)(),
    (0, class_validator_1.IsNotEmpty)(),
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], UserAdminUpdateDto.prototype, "password", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: 'PIN code' }),
    (0, validation_1.PinCode)({ optional: true, emptyToNull: true }),
    __metadata("design:type", Object)
], UserAdminUpdateDto.prototype, "pinCode", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: 'User name' }),
    (0, validation_1.Optional)(),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsNotEmpty)(),
    __metadata("design:type", String)
], UserAdminUpdateDto.prototype, "name", void 0);
__decorate([
    (0, validation_1.ValidateEnum)({ enum: enum_1.UserAvatarColor, name: 'UserAvatarColor', optional: true, description: 'Avatar color' }),
    __metadata("design:type", Object)
], UserAdminUpdateDto.prototype, "avatarColor", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: 'Storage label' }),
    (0, validation_1.Optional)({ nullable: true }),
    (0, class_validator_1.IsString)(),
    (0, class_transformer_1.Transform)(validation_1.toSanitized),
    __metadata("design:type", Object)
], UserAdminUpdateDto.prototype, "storageLabel", void 0);
__decorate([
    (0, validation_1.ValidateBoolean)({ optional: true, description: 'Require password change on next login' }),
    __metadata("design:type", Boolean)
], UserAdminUpdateDto.prototype, "shouldChangePassword", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ type: 'integer', format: 'int64', description: 'Storage quota in bytes' }),
    (0, validation_1.Optional)({ nullable: true }),
    (0, class_validator_1.IsInt)(),
    (0, class_validator_1.Min)(0),
    __metadata("design:type", Object)
], UserAdminUpdateDto.prototype, "quotaSizeInBytes", void 0);
__decorate([
    (0, validation_1.ValidateBoolean)({ optional: true, description: 'Grant admin privileges' }),
    __metadata("design:type", Boolean)
], UserAdminUpdateDto.prototype, "isAdmin", void 0);
class UserAdminDeleteDto {
    force;
    static _OPENAPI_METADATA_FACTORY() {
        return { force: { required: false, type: () => Boolean } };
    }
}
exports.UserAdminDeleteDto = UserAdminDeleteDto;
__decorate([
    (0, validation_1.ValidateBoolean)({ optional: true, description: 'Force delete even if user has assets' }),
    __metadata("design:type", Boolean)
], UserAdminDeleteDto.prototype, "force", void 0);
class UserAdminResponseDto extends UserResponseDto {
    storageLabel;
    shouldChangePassword;
    isAdmin;
    createdAt;
    deletedAt;
    updatedAt;
    oauthId;
    quotaSizeInBytes;
    quotaUsageInBytes;
    status;
    license;
    static _OPENAPI_METADATA_FACTORY() {
        return { storageLabel: { required: true, type: () => String, nullable: true }, shouldChangePassword: { required: true, type: () => Boolean }, isAdmin: { required: true, type: () => Boolean }, createdAt: { required: true, type: () => Date }, deletedAt: { required: true, type: () => Date, nullable: true }, updatedAt: { required: true, type: () => Date }, oauthId: { required: true, type: () => String }, quotaSizeInBytes: { required: true, type: () => Number, nullable: true }, quotaUsageInBytes: { required: true, type: () => Number, nullable: true }, status: { required: true, type: () => String }, license: { required: true, type: () => require("./user.dto").UserLicense, nullable: true } };
    }
}
exports.UserAdminResponseDto = UserAdminResponseDto;
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Storage label' }),
    __metadata("design:type", Object)
], UserAdminResponseDto.prototype, "storageLabel", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Require password change on next login' }),
    __metadata("design:type", Boolean)
], UserAdminResponseDto.prototype, "shouldChangePassword", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Is admin user' }),
    __metadata("design:type", Boolean)
], UserAdminResponseDto.prototype, "isAdmin", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Creation date' }),
    __metadata("design:type", Date)
], UserAdminResponseDto.prototype, "createdAt", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Deletion date' }),
    __metadata("design:type", Object)
], UserAdminResponseDto.prototype, "deletedAt", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Last update date' }),
    __metadata("design:type", Date)
], UserAdminResponseDto.prototype, "updatedAt", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'OAuth ID' }),
    __metadata("design:type", String)
], UserAdminResponseDto.prototype, "oauthId", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer', format: 'int64', description: 'Storage quota in bytes' }),
    __metadata("design:type", Object)
], UserAdminResponseDto.prototype, "quotaSizeInBytes", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer', format: 'int64', description: 'Storage usage in bytes' }),
    __metadata("design:type", Object)
], UserAdminResponseDto.prototype, "quotaUsageInBytes", void 0);
__decorate([
    (0, validation_1.ValidateEnum)({ enum: enum_1.UserStatus, name: 'UserStatus', description: 'User status' }),
    __metadata("design:type", String)
], UserAdminResponseDto.prototype, "status", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'User license' }),
    __metadata("design:type", Object)
], UserAdminResponseDto.prototype, "license", void 0);
function mapUserAdmin(entity) {
    const metadata = entity.metadata || [];
    const license = metadata.find((item) => item.key === enum_1.UserMetadataKey.License)?.value;
    return {
        ...(0, exports.mapUser)(entity),
        storageLabel: entity.storageLabel,
        shouldChangePassword: entity.shouldChangePassword,
        isAdmin: entity.isAdmin,
        createdAt: entity.createdAt,
        deletedAt: entity.deletedAt,
        updatedAt: entity.updatedAt,
        oauthId: entity.oauthId,
        quotaSizeInBytes: entity.quotaSizeInBytes,
        quotaUsageInBytes: entity.quotaUsageInBytes,
        status: entity.status,
        license: license ? { ...license, activatedAt: new Date(license?.activatedAt) } : null,
    };
}
//# sourceMappingURL=user.dto.js.map