import { NextFunction, Request, Response } from 'express';
import { IncomingHttpHeaders } from 'node:http';
import { MaintenanceAuthDto, MaintenanceDetectInstallResponseDto, MaintenanceStatusResponseDto, SetMaintenanceModeDto } from 'src/dtos/maintenance.dto';
import { ServerConfigDto } from 'src/dtos/server.dto';
import { MaintenanceHealthRepository } from 'src/maintenance/maintenance-health.repository';
import { MaintenanceWebsocketRepository } from 'src/maintenance/maintenance-websocket.repository';
import { AppRepository } from 'src/repositories/app.repository';
import { ConfigRepository } from 'src/repositories/config.repository';
import { DatabaseRepository } from 'src/repositories/database.repository';
import { LoggingRepository } from 'src/repositories/logging.repository';
import { ProcessRepository } from 'src/repositories/process.repository';
import { StorageRepository } from 'src/repositories/storage.repository';
import { SystemMetadataRepository } from 'src/repositories/system-metadata.repository';
import { ImmichFileResponse } from 'src/utils/file';
export declare class MaintenanceWorkerService {
    #private;
    protected logger: LoggingRepository;
    private appRepository;
    private configRepository;
    private systemMetadataRepository;
    private maintenanceWebsocketRepository;
    private maintenanceHealthRepository;
    private storageRepository;
    private processRepository;
    private databaseRepository;
    constructor(logger: LoggingRepository, appRepository: AppRepository, configRepository: ConfigRepository, systemMetadataRepository: SystemMetadataRepository, maintenanceWebsocketRepository: MaintenanceWebsocketRepository, maintenanceHealthRepository: MaintenanceHealthRepository, storageRepository: StorageRepository, processRepository: ProcessRepository, databaseRepository: DatabaseRepository);
    mock(status: MaintenanceStatusResponseDto): void;
    init(): Promise<void>;
    private get configRepos();
    private getConfig;
    getSystemConfig(): ServerConfigDto;
    getVersion(): {
        major: number;
        minor: number;
        patch: number;
    };
    ssr(excludePaths: string[]): (request: Request, res: Response, next: NextFunction) => void;
    detectMediaLocation(): string;
    listBackups(): Promise<{
        backups: {
            filename: string;
            filesize: number;
        }[];
    }>;
    deleteBackup(files: string[]): Promise<void>;
    uploadBackup(file: Express.Multer.File): Promise<void>;
    downloadBackup(fileName: string): ImmichFileResponse;
    private get secret();
    private get backupRepos();
    private getStatus;
    private getPublicStatus;
    setStatus(status: MaintenanceStatusResponseDto): void;
    logSecret(): Promise<void>;
    authenticate(headers: IncomingHttpHeaders): Promise<MaintenanceAuthDto>;
    status(potentiallyJwt?: string): Promise<MaintenanceStatusResponseDto>;
    detectPriorInstall(): Promise<MaintenanceDetectInstallResponseDto>;
    login(jwt?: string): Promise<MaintenanceAuthDto>;
    setAction(action: SetMaintenanceModeDto): Promise<void>;
    runAction(action: SetMaintenanceModeDto): Promise<void>;
    private restoreBackup;
    private endMaintenance;
}
