import { Kysely } from 'kysely';
import { Asset } from 'src/database';
import { AssetFileType, AssetType, AssetVisibility } from 'src/enum';
import { DB } from 'src/schema';
export declare class AssetJobRepository {
    private db;
    constructor(db: Kysely<DB>);
    getForSearchDuplicatesJob(id: string): Promise<{
        id: string;
        type: import("node_modules/kysely/dist/cjs/util/type-utils").ExtractColumnType<{
            library: import("../schema/tables/library.table").LibraryTable;
            api_key: import("../schema/tables/api-key.table").ApiKeyTable;
            workflow: import("../schema/tables/workflow.table").WorkflowTable;
            asset: import("../schema/tables/asset.table").AssetTable;
            album: import("../schema/tables/album.table").AlbumTable;
            person: import("../schema/tables/person.table").PersonTable;
            smart_search: import("kysely").Nullable<import("../schema/tables/smart-search.table").SmartSearchTable>;
            face_search: import("../schema/tables/face-search.table").FaceSearchTable;
            user: import("../schema/tables/user.table").UserTable;
            session: import("../schema/tables/session.table").SessionTable;
            user_metadata_audit: import("../schema/tables/user-metadata-audit.table").UserMetadataAuditTable;
            asset_metadata_audit: import("../schema/tables/asset-metadata-audit.table").AssetMetadataAuditTable;
            asset_face_audit: import("../schema/tables/asset-face-audit.table").AssetFaceAuditTable;
            stack: import("../schema/tables/stack.table").StackTable;
            activity: import("../schema/tables/activity.table").ActivityTable;
            album_audit: import("../schema/tables/album-audit.table").AlbumAuditTable;
            album_asset: import("../schema/tables/album-asset.table").AlbumAssetTable;
            album_asset_audit: import("../schema/tables/album-asset-audit.table").AlbumAssetAuditTable;
            album_user: import("../schema/tables/album-user.table").AlbumUserTable;
            album_user_audit: import("../schema/tables/album-user-audit.table").AlbumUserAuditTable;
            asset_audit: import("../schema/tables/asset-audit.table").AssetAuditTable;
            asset_edit: import("../schema/tables/asset-edit.table").AssetEditTable<import("../dtos/editing.dto").AssetEditAction>;
            asset_exif: import("../schema/tables/asset-exif.table").AssetExifTable;
            asset_face: import("../schema/tables/asset-face.table").AssetFaceTable;
            asset_file: import("../schema/tables/asset-file.table").AssetFileTable;
            asset_metadata: import("../schema/tables/asset-metadata.table").AssetMetadataTable;
            asset_job_status: import("../schema/tables/asset-job-status.table").AssetJobStatusTable;
            asset_ocr: import("../schema/tables/asset-ocr.table").AssetOcrTable;
            ocr_search: import("../schema/tables/ocr-search.table").OcrSearchTable;
            audit: import("../schema/tables/audit.table").AuditTable;
            geodata_places: import("../schema/tables/geodata-places.table").GeodataPlacesTable;
            memory: import("../schema/tables/memory.table").MemoryTable;
            memory_audit: import("../schema/tables/memory-audit.table").MemoryAuditTable;
            memory_asset: import("../schema/tables/memory-asset.table").MemoryAssetTable;
            memory_asset_audit: import("../schema/tables/memory-asset-audit.table").MemoryAssetAuditTable;
            migrations: import("src/schema").Migrations;
            notification: import("../schema/tables/notification.table").NotificationTable;
            move_history: import("../schema/tables/move.table").MoveTable;
            naturalearth_countries: import("../schema/tables/natural-earth-countries.table").NaturalEarthCountriesTable;
            partner: import("../schema/tables/partner.table").PartnerTable;
            partner_audit: import("../schema/tables/partner-audit.table").PartnerAuditTable;
            person_audit: import("../schema/tables/person-audit.table").PersonAuditTable;
            session_sync_checkpoint: import("../schema/tables/sync-checkpoint.table").SessionSyncCheckpointTable;
            shared_link: import("../schema/tables/shared-link.table").SharedLinkTable;
            shared_link_asset: import("../schema/tables/shared-link-asset.table").SharedLinkAssetTable;
            stack_audit: import("../schema/tables/stack-audit.table").StackAuditTable;
            system_metadata: import("../schema/tables/system-metadata.table").SystemMetadataTable<import("src/enum").SystemMetadataKey>;
            tag: import("../schema/tables/tag.table").TagTable;
            tag_asset: import("../schema/tables/tag-asset.table").TagAssetTable;
            tag_closure: import("../schema/tables/tag-closure.table").TagClosureTable;
            user_audit: import("../schema/tables/user-audit.table").UserAuditTable;
            user_metadata: import("../schema/tables/user-metadata.table").UserMetadataTable<import("src/enum").UserMetadataKey>;
            version_history: import("../schema/tables/version-history.table").VersionHistoryTable;
            plugin: import("../schema/tables/plugin.table").PluginTable;
            plugin_filter: import("../schema/tables/plugin.table").PluginFilterTable;
            plugin_action: import("../schema/tables/plugin.table").PluginActionTable;
            workflow_filter: import("../schema/tables/workflow.table").WorkflowFilterTable;
            workflow_action: import("../schema/tables/workflow.table").WorkflowActionTable;
        }, "asset" | "smart_search", "type">;
        ownerId: string;
        stackId: import("node_modules/kysely/dist/cjs/util/type-utils").ExtractColumnType<{
            library: import("../schema/tables/library.table").LibraryTable;
            api_key: import("../schema/tables/api-key.table").ApiKeyTable;
            workflow: import("../schema/tables/workflow.table").WorkflowTable;
            asset: import("../schema/tables/asset.table").AssetTable;
            album: import("../schema/tables/album.table").AlbumTable;
            person: import("../schema/tables/person.table").PersonTable;
            smart_search: import("kysely").Nullable<import("../schema/tables/smart-search.table").SmartSearchTable>;
            face_search: import("../schema/tables/face-search.table").FaceSearchTable;
            user: import("../schema/tables/user.table").UserTable;
            session: import("../schema/tables/session.table").SessionTable;
            user_metadata_audit: import("../schema/tables/user-metadata-audit.table").UserMetadataAuditTable;
            asset_metadata_audit: import("../schema/tables/asset-metadata-audit.table").AssetMetadataAuditTable;
            asset_face_audit: import("../schema/tables/asset-face-audit.table").AssetFaceAuditTable;
            stack: import("../schema/tables/stack.table").StackTable;
            activity: import("../schema/tables/activity.table").ActivityTable;
            album_audit: import("../schema/tables/album-audit.table").AlbumAuditTable;
            album_asset: import("../schema/tables/album-asset.table").AlbumAssetTable;
            album_asset_audit: import("../schema/tables/album-asset-audit.table").AlbumAssetAuditTable;
            album_user: import("../schema/tables/album-user.table").AlbumUserTable;
            album_user_audit: import("../schema/tables/album-user-audit.table").AlbumUserAuditTable;
            asset_audit: import("../schema/tables/asset-audit.table").AssetAuditTable;
            asset_edit: import("../schema/tables/asset-edit.table").AssetEditTable<import("../dtos/editing.dto").AssetEditAction>;
            asset_exif: import("../schema/tables/asset-exif.table").AssetExifTable;
            asset_face: import("../schema/tables/asset-face.table").AssetFaceTable;
            asset_file: import("../schema/tables/asset-file.table").AssetFileTable;
            asset_metadata: import("../schema/tables/asset-metadata.table").AssetMetadataTable;
            asset_job_status: import("../schema/tables/asset-job-status.table").AssetJobStatusTable;
            asset_ocr: import("../schema/tables/asset-ocr.table").AssetOcrTable;
            ocr_search: import("../schema/tables/ocr-search.table").OcrSearchTable;
            audit: import("../schema/tables/audit.table").AuditTable;
            geodata_places: import("../schema/tables/geodata-places.table").GeodataPlacesTable;
            memory: import("../schema/tables/memory.table").MemoryTable;
            memory_audit: import("../schema/tables/memory-audit.table").MemoryAuditTable;
            memory_asset: import("../schema/tables/memory-asset.table").MemoryAssetTable;
            memory_asset_audit: import("../schema/tables/memory-asset-audit.table").MemoryAssetAuditTable;
            migrations: import("src/schema").Migrations;
            notification: import("../schema/tables/notification.table").NotificationTable;
            move_history: import("../schema/tables/move.table").MoveTable;
            naturalearth_countries: import("../schema/tables/natural-earth-countries.table").NaturalEarthCountriesTable;
            partner: import("../schema/tables/partner.table").PartnerTable;
            partner_audit: import("../schema/tables/partner-audit.table").PartnerAuditTable;
            person_audit: import("../schema/tables/person-audit.table").PersonAuditTable;
            session_sync_checkpoint: import("../schema/tables/sync-checkpoint.table").SessionSyncCheckpointTable;
            shared_link: import("../schema/tables/shared-link.table").SharedLinkTable;
            shared_link_asset: import("../schema/tables/shared-link-asset.table").SharedLinkAssetTable;
            stack_audit: import("../schema/tables/stack-audit.table").StackAuditTable;
            system_metadata: import("../schema/tables/system-metadata.table").SystemMetadataTable<import("src/enum").SystemMetadataKey>;
            tag: import("../schema/tables/tag.table").TagTable;
            tag_asset: import("../schema/tables/tag-asset.table").TagAssetTable;
            tag_closure: import("../schema/tables/tag-closure.table").TagClosureTable;
            user_audit: import("../schema/tables/user-audit.table").UserAuditTable;
            user_metadata: import("../schema/tables/user-metadata.table").UserMetadataTable<import("src/enum").UserMetadataKey>;
            version_history: import("../schema/tables/version-history.table").VersionHistoryTable;
            plugin: import("../schema/tables/plugin.table").PluginTable;
            plugin_filter: import("../schema/tables/plugin.table").PluginFilterTable;
            plugin_action: import("../schema/tables/plugin.table").PluginActionTable;
            workflow_filter: import("../schema/tables/workflow.table").WorkflowFilterTable;
            workflow_action: import("../schema/tables/workflow.table").WorkflowActionTable;
        }, "asset" | "smart_search", "stackId">;
        duplicateId: import("node_modules/kysely/dist/cjs/util/type-utils").ExtractColumnType<{
            library: import("../schema/tables/library.table").LibraryTable;
            api_key: import("../schema/tables/api-key.table").ApiKeyTable;
            workflow: import("../schema/tables/workflow.table").WorkflowTable;
            asset: import("../schema/tables/asset.table").AssetTable;
            album: import("../schema/tables/album.table").AlbumTable;
            person: import("../schema/tables/person.table").PersonTable;
            smart_search: import("kysely").Nullable<import("../schema/tables/smart-search.table").SmartSearchTable>;
            face_search: import("../schema/tables/face-search.table").FaceSearchTable;
            user: import("../schema/tables/user.table").UserTable;
            session: import("../schema/tables/session.table").SessionTable;
            user_metadata_audit: import("../schema/tables/user-metadata-audit.table").UserMetadataAuditTable;
            asset_metadata_audit: import("../schema/tables/asset-metadata-audit.table").AssetMetadataAuditTable;
            asset_face_audit: import("../schema/tables/asset-face-audit.table").AssetFaceAuditTable;
            stack: import("../schema/tables/stack.table").StackTable;
            activity: import("../schema/tables/activity.table").ActivityTable;
            album_audit: import("../schema/tables/album-audit.table").AlbumAuditTable;
            album_asset: import("../schema/tables/album-asset.table").AlbumAssetTable;
            album_asset_audit: import("../schema/tables/album-asset-audit.table").AlbumAssetAuditTable;
            album_user: import("../schema/tables/album-user.table").AlbumUserTable;
            album_user_audit: import("../schema/tables/album-user-audit.table").AlbumUserAuditTable;
            asset_audit: import("../schema/tables/asset-audit.table").AssetAuditTable;
            asset_edit: import("../schema/tables/asset-edit.table").AssetEditTable<import("../dtos/editing.dto").AssetEditAction>;
            asset_exif: import("../schema/tables/asset-exif.table").AssetExifTable;
            asset_face: import("../schema/tables/asset-face.table").AssetFaceTable;
            asset_file: import("../schema/tables/asset-file.table").AssetFileTable;
            asset_metadata: import("../schema/tables/asset-metadata.table").AssetMetadataTable;
            asset_job_status: import("../schema/tables/asset-job-status.table").AssetJobStatusTable;
            asset_ocr: import("../schema/tables/asset-ocr.table").AssetOcrTable;
            ocr_search: import("../schema/tables/ocr-search.table").OcrSearchTable;
            audit: import("../schema/tables/audit.table").AuditTable;
            geodata_places: import("../schema/tables/geodata-places.table").GeodataPlacesTable;
            memory: import("../schema/tables/memory.table").MemoryTable;
            memory_audit: import("../schema/tables/memory-audit.table").MemoryAuditTable;
            memory_asset: import("../schema/tables/memory-asset.table").MemoryAssetTable;
            memory_asset_audit: import("../schema/tables/memory-asset-audit.table").MemoryAssetAuditTable;
            migrations: import("src/schema").Migrations;
            notification: import("../schema/tables/notification.table").NotificationTable;
            move_history: import("../schema/tables/move.table").MoveTable;
            naturalearth_countries: import("../schema/tables/natural-earth-countries.table").NaturalEarthCountriesTable;
            partner: import("../schema/tables/partner.table").PartnerTable;
            partner_audit: import("../schema/tables/partner-audit.table").PartnerAuditTable;
            person_audit: import("../schema/tables/person-audit.table").PersonAuditTable;
            session_sync_checkpoint: import("../schema/tables/sync-checkpoint.table").SessionSyncCheckpointTable;
            shared_link: import("../schema/tables/shared-link.table").SharedLinkTable;
            shared_link_asset: import("../schema/tables/shared-link-asset.table").SharedLinkAssetTable;
            stack_audit: import("../schema/tables/stack-audit.table").StackAuditTable;
            system_metadata: import("../schema/tables/system-metadata.table").SystemMetadataTable<import("src/enum").SystemMetadataKey>;
            tag: import("../schema/tables/tag.table").TagTable;
            tag_asset: import("../schema/tables/tag-asset.table").TagAssetTable;
            tag_closure: import("../schema/tables/tag-closure.table").TagClosureTable;
            user_audit: import("../schema/tables/user-audit.table").UserAuditTable;
            user_metadata: import("../schema/tables/user-metadata.table").UserMetadataTable<import("src/enum").UserMetadataKey>;
            version_history: import("../schema/tables/version-history.table").VersionHistoryTable;
            plugin: import("../schema/tables/plugin.table").PluginTable;
            plugin_filter: import("../schema/tables/plugin.table").PluginFilterTable;
            plugin_action: import("../schema/tables/plugin.table").PluginActionTable;
            workflow_filter: import("../schema/tables/workflow.table").WorkflowFilterTable;
            workflow_action: import("../schema/tables/workflow.table").WorkflowActionTable;
        }, "asset" | "smart_search", "duplicateId">;
        visibility: AssetVisibility;
        embedding: string | null;
    } | undefined>;
    getForSidecarWriteJob(id: string): Promise<{
        id: string;
        originalPath: string;
        files: {
            id: string;
            type: AssetFileType;
            path: string;
            isEdited: boolean;
        }[];
        exifInfo: import("src/database").Exif;
    } | undefined>;
    getForSidecarCheckJob(id: string): Promise<{
        id: string;
        originalPath: string;
        files: {
            id: string;
            type: AssetFileType;
            path: string;
            isEdited: boolean;
        }[];
    } | undefined>;
    streamForThumbnailJob(force: boolean): AsyncIterableIterator<{
        id: string;
        thumbhash: Buffer<ArrayBufferLike> | null;
    } & {
        files: {
            id: string;
            type: AssetFileType;
            path: string;
            isEdited: boolean;
        }[];
    } & {
        edits: import("../dtos/editing.dto").AssetEditActionItem[];
    } & Partial<Omit<unknown, "id" | "edits" | "thumbhash" | "files">>>;
    getForMigrationJob(id: string): Promise<{
        id: string;
        ownerId: string;
        encodedVideoPath: string | null;
        files: {
            id: string;
            type: AssetFileType;
            path: string;
            isEdited: boolean;
        }[];
    } | undefined>;
    getForGenerateThumbnailJob(id: string): Promise<{
        id: string;
        type: AssetType;
        ownerId: string;
        originalPath: string;
        originalFileName: string;
        thumbhash: Buffer<ArrayBufferLike> | null;
        visibility: AssetVisibility;
        files: {
            id: string;
            type: AssetFileType;
            path: string;
            isEdited: boolean;
            isProgressive: boolean;
        }[];
        edits: import("../dtos/editing.dto").AssetEditActionItem[];
        exifInfo: import("src/database").Exif;
    } | undefined>;
    getForMetadataExtraction(id: string): Promise<{
        id: string;
        type: AssetType;
        ownerId: string;
        width: number | null;
        height: number | null;
        deviceAssetId: string;
        deviceId: string;
        originalPath: string;
        fileCreatedAt: Date;
        fileModifiedAt: Date;
        checksum: Buffer<ArrayBufferLike>;
        livePhotoVideoId: string | null;
        originalFileName: string;
        libraryId: string | null;
        isExternal: boolean;
        localDateTime: Date;
        visibility: AssetVisibility;
        faces: {
            id: string;
            assetId: string;
            updatedAt: Date;
            deletedAt: Date | null;
            updateId: string;
            personId: string | null;
            imageWidth: number;
            imageHeight: number;
            boundingBoxX1: number;
            boundingBoxY1: number;
            boundingBoxX2: number;
            boundingBoxY2: number;
            sourceType: import("src/enum").SourceType;
            isVisible: boolean;
        }[];
        files: {
            id: string;
            type: AssetFileType;
            path: string;
            isEdited: boolean;
        }[];
    } | undefined>;
    getLockedPropertiesForMetadataExtraction(assetId: string): Promise<("description" | "dateTimeOriginal" | "latitude" | "longitude" | "timeZone" | "rating" | "tags")[]>;
    getAlbumThumbnailFiles(id: string, fileType?: AssetFileType): Promise<{
        id: string;
        type: AssetFileType;
        path: string;
        isEdited: boolean;
    }[]>;
    private assetsWithPreviews;
    streamForSearchDuplicates(force?: boolean): AsyncIterableIterator<{
        id: string;
    } & Partial<Omit<unknown, "id">>>;
    streamForEncodeClip(force?: boolean): AsyncIterableIterator<{
        id: string;
    } & Partial<Omit<unknown, "id">>>;
    getForClipEncoding(id: string): Promise<{
        id: string;
        visibility: AssetVisibility;
        files: {
            id: string;
            type: AssetFileType;
            path: string;
            isEdited: boolean;
        }[];
    } | undefined>;
    getForDetectFacesJob(id: string): Promise<{
        id: string;
        visibility: AssetVisibility;
        exifInfo: import("src/database").Exif;
        faces: {
            id: string;
            assetId: string;
            updatedAt: Date;
            deletedAt: Date | null;
            updateId: string;
            personId: string | null;
            imageWidth: number;
            imageHeight: number;
            boundingBoxX1: number;
            boundingBoxY1: number;
            boundingBoxX2: number;
            boundingBoxY2: number;
            sourceType: import("src/enum").SourceType;
            isVisible: boolean;
        }[];
        files: {
            id: string;
            type: AssetFileType;
            path: string;
            isEdited: boolean;
        }[];
    } | undefined>;
    getForOcr(id: string): Promise<{
        visibility: AssetVisibility;
        previewFile: string | null;
    } | undefined>;
    getForSyncAssets(ids: string[]): Promise<{
        id: string;
        status: import("src/enum").AssetStatus;
        originalPath: string;
        fileModifiedAt: Date;
        isOffline: boolean;
        libraryId: string | null;
    }[]>;
    getForAssetDeletion(id: string): Promise<{
        id: string;
        ownerId: string;
        originalPath: string;
        encodedVideoPath: string | null;
        livePhotoVideoId: string | null;
        isOffline: boolean;
        libraryId: string | null;
        visibility: AssetVisibility;
        exifInfo: import("src/database").Exif | null;
        faces: {
            id: string;
            assetId: string;
            updatedAt: Date;
            deletedAt: Date | null;
            updateId: string;
            personId: string | null;
            imageWidth: number;
            imageHeight: number;
            boundingBoxX1: number;
            boundingBoxY1: number;
            boundingBoxX2: number;
            boundingBoxY2: number;
            sourceType: import("src/enum").SourceType;
            isVisible: boolean;
            person: import("src/database").Person;
        }[];
        files: {
            id: string;
            type: AssetFileType;
            path: string;
            isEdited: boolean;
        }[];
        stack: {
            assets: Asset[];
            id: string;
            primaryAssetId: string;
        } | null;
    } | undefined>;
    streamForVideoConversion(force?: boolean): AsyncIterableIterator<{
        id: string;
    } & Partial<Omit<unknown, "id">>>;
    getForVideoConversion(id: string): Promise<{
        id: string;
        ownerId: string;
        originalPath: string;
        encodedVideoPath: string | null;
    } | undefined>;
    streamForMetadataExtraction(force?: boolean): AsyncIterableIterator<{
        id: string;
    } & Partial<Omit<unknown, "id">>>;
    private storageTemplateAssetQuery;
    getForStorageTemplateJob(id: string): Promise<{
        id: string;
        type: AssetType;
        ownerId: string;
        originalPath: string;
        fileCreatedAt: Date;
        checksum: Buffer<ArrayBufferLike>;
        livePhotoVideoId: string | null;
        originalFileName: string;
        isExternal: boolean;
        make: string | null;
        model: string | null;
        fileSizeInByte: number | null;
        lensModel: string | null;
        timeZone: string | null;
        files: {
            id: string;
            type: AssetFileType;
            path: string;
            isEdited: boolean;
        }[];
    } | undefined>;
    streamForStorageTemplateJob(): AsyncIterableIterator<{
        id: string;
        type: AssetType;
        ownerId: string;
        originalPath: string;
        fileCreatedAt: Date;
        checksum: Buffer<ArrayBufferLike>;
        livePhotoVideoId: string | null;
        originalFileName: string;
        isExternal: boolean;
        make: string | null;
        model: string | null;
        fileSizeInByte: number | null;
        lensModel: string | null;
        timeZone: string | null;
    } & {
        files: {
            id: string;
            type: AssetFileType;
            path: string;
            isEdited: boolean;
        }[];
    }>;
    streamForDeletedJob(trashedBefore: Date): AsyncIterableIterator<{
        id: string;
        isOffline: boolean;
    }>;
    streamForSidecar(force?: boolean): AsyncIterableIterator<{
        id: string;
    } & Partial<Omit<unknown, "id">>>;
    streamForDetectFacesJob(force?: boolean): AsyncIterableIterator<Partial<Omit<unknown, never>> & {
        id: string;
    }>;
    streamForOcrJob(force?: boolean): AsyncIterableIterator<{
        id: string;
    } & Partial<Omit<unknown, "id">>>;
    streamForMigrationJob(): AsyncIterableIterator<{
        id: string;
    }>;
}
