"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.up = up;
exports.down = down;
const kysely_1 = require("kysely");
async function up(db) {
    await (0, kysely_1.sql) `ALTER TABLE "albums_assets_assets" ADD "updatedAt" timestamp with time zone NOT NULL DEFAULT now();`.execute(db);
    await (0, kysely_1.sql) `ALTER TABLE "albums_assets_assets" ADD "updateId" uuid NOT NULL DEFAULT immich_uuid_v7();`.execute(db);
    await (0, kysely_1.sql) `CREATE INDEX "IDX_album_assets_update_id" ON "albums_assets_assets" ("updateId")`.execute(db);
    await (0, kysely_1.sql) `CREATE OR REPLACE TRIGGER "album_assets_updated_at"
  BEFORE UPDATE ON "albums_assets_assets"
  FOR EACH ROW
  EXECUTE FUNCTION updated_at();`.execute(db);
}
async function down(db) {
    await (0, kysely_1.sql) `DROP INDEX "IDX_album_assets_update_id";`.execute(db);
    await (0, kysely_1.sql) `ALTER TABLE "albums_assets_assets" DROP COLUMN "updatedAt";`.execute(db);
    await (0, kysely_1.sql) `ALTER TABLE "albums_assets_assets" DROP COLUMN "updateId";`.execute(db);
    await (0, kysely_1.sql) `DROP TRIGGER "album_assets_updated_at" ON "albums_assets_assets";`.execute(db);
}
//# sourceMappingURL=1750676477029-AlbumAssetUpdateId.js.map