"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.up = up;
exports.down = down;
const kysely_1 = require("kysely");
async function up(db) {
    await (0, kysely_1.sql) `
    CREATE TABLE "asset_edit" (
      "id" uuid NOT NULL DEFAULT uuid_generate_v4(),
      "assetId" uuid NOT NULL,
      "action" varchar NOT NULL,
      "parameters" jsonb NOT NULL
    );
  `.execute(db);
    await (0, kysely_1.sql) `ALTER TABLE "asset_edit" ADD CONSTRAINT "asset_edit_pkey" PRIMARY KEY ("id");`.execute(db);
    await (0, kysely_1.sql) `ALTER TABLE "asset_edit" ADD CONSTRAINT "asset_edit_assetId_fkey" FOREIGN KEY ("assetId") REFERENCES "asset" ("id") ON UPDATE CASCADE ON DELETE CASCADE;`.execute(db);
    await (0, kysely_1.sql) `CREATE INDEX "asset_edit_assetId_idx" ON "asset_edit" ("assetId")`.execute(db);
}
async function down(db) {
    await (0, kysely_1.sql) `DROP TABLE IF EXISTS "asset_edit";`.execute(db);
}
//# sourceMappingURL=1768336671610-CreateAssetEditTable.js.map