import { AuthDto } from 'src/dtos/auth.dto';
import { WorkflowCreateDto, WorkflowResponseDto, WorkflowUpdateDto } from 'src/dtos/workflow.dto';
import { BaseService } from 'src/services/base.service';
export declare class WorkflowService extends BaseService {
    create(auth: AuthDto, dto: WorkflowCreateDto): Promise<WorkflowResponseDto>;
    getAll(auth: AuthDto): Promise<WorkflowResponseDto[]>;
    get(auth: AuthDto, id: string): Promise<WorkflowResponseDto>;
    update(auth: AuthDto, id: string, dto: WorkflowUpdateDto): Promise<WorkflowResponseDto>;
    delete(auth: AuthDto, id: string): Promise<void>;
    private validateAndMapFilters;
    private validateAndMapActions;
    private getContextForTrigger;
    private findOrFail;
    private mapWorkflow;
}
