"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.processUniqueConstraints = void 0;
const types_1 = require("../types");
const processUniqueConstraints = (ctx, items) => {
    for (const { item: { object, options }, } of items.filter((item) => item.type === 'uniqueConstraint')) {
        const table = ctx.getTableByObject(object);
        if (!table) {
            ctx.warnMissingTable('@Unique', object);
            continue;
        }
        const tableName = table.name;
        const columnNames = options.columns;
        table.constraints.push({
            type: types_1.ConstraintType.UNIQUE,
            name: options.name || ctx.getNameFor({ type: 'unique', tableName, columnNames }),
            tableName,
            columnNames,
            synchronize: options.synchronize ?? true,
        });
    }
    for (const { type, item: { object, propertyName, options }, } of items.filter((item) => item.type === 'column' || item.type === 'foreignKeyColumn')) {
        const { table, column } = ctx.getColumnByObjectAndPropertyName(object, propertyName);
        if (!table) {
            ctx.warnMissingTable('@Column', object);
            continue;
        }
        if (!column) {
            ctx.warnMissingColumn('@Column', object, propertyName);
            continue;
        }
        if (type === 'column' && !options.primary && (options.unique || options.uniqueConstraintName)) {
            const uniqueConstraintName = options.uniqueConstraintName ||
                ctx.getNameFor({
                    type: 'unique',
                    tableName: table.name,
                    columnNames: [column.name],
                });
            table.constraints.push({
                type: types_1.ConstraintType.UNIQUE,
                name: uniqueConstraintName,
                tableName: table.name,
                columnNames: [column.name],
                synchronize: options.synchronize ?? true,
            });
        }
    }
};
exports.processUniqueConstraints = processUniqueConstraints;
//# sourceMappingURL=unique-constraint.processor.js.map