/*
 * Copyright The OpenTelemetry Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
'use strict';
Object.defineProperty(exports, "__esModule", { value: true });
exports.initializeDefaultConfiguration = void 0;
const api_1 = require("@opentelemetry/api");
function initializeDefaultConfiguration() {
    const config = {
        disabled: false,
        log_level: api_1.DiagLogLevel.INFO,
        resource: {},
        attribute_limits: {
            attribute_count_limit: 128,
        },
        propagator: {
            composite: [{ tracecontext: null }, { baggage: null }],
            composite_list: 'tracecontext,baggage',
        },
    };
    return config;
}
exports.initializeDefaultConfiguration = initializeDefaultConfiguration;
//# sourceMappingURL=configModel.js.map