import child_process from "node:child_process";
import { BatchClusterEmitter } from "./BatchClusterEmitter";
import { Logger } from "./Logger";
import { Task } from "./Task";
/**
 * Configuration for stream handling behavior
 */
export interface StreamHandlerOptions {
    readonly logger: () => Logger;
}
/**
 * Interface for objects that can provide stream context
 */
export interface StreamContext {
    readonly name: string;
    isEnding(): boolean;
    getCurrentTask(): Task<unknown> | undefined;
    onError: (reason: string, error: Error) => void;
    end: (gracefully: boolean, reason: string) => void;
}
/**
 * Handles stdout/stderr stream processing for child processes.
 * Manages stream event listeners, data routing, and error handling.
 */
export declare class StreamHandler {
    #private;
    private readonly emitter;
    constructor(options: StreamHandlerOptions, emitter: BatchClusterEmitter);
    /**
     * Set up stream event listeners for a child process
     */
    setupStreamListeners(proc: child_process.ChildProcess, context: StreamContext): void;
    /**
     * Process stdout data directly (for testing or manual processing)
     */
    processStdout(data: string | Buffer, context: StreamContext): void;
    /**
     * Process stderr data directly (for testing or manual processing)
     */
    processStderr(data: string | Buffer, context: StreamContext): void;
    /**
     * Check if data is considered blank/empty
     */
    isBlankData(data: string | Buffer | null | undefined): boolean;
    /**
     * Get stream handler statistics
     */
    getStats(): {
        handlerActive: boolean;
        emitterConnected: boolean;
    };
}
