"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.ReadRawTask = exports.DefaultReadRawTaskOptions = exports.ReadRawTaskOptionFields = void 0;
const batch_cluster_1 = require("batch-cluster");
const _path = __importStar(require("node:path"));
const DefaultExifToolOptions_1 = require("./DefaultExifToolOptions");
const ErrorsAndWarnings_1 = require("./ErrorsAndWarnings");
const ExifToolTask_1 = require("./ExifToolTask");
const FilenameCharsetArgs_1 = require("./FilenameCharsetArgs");
const Pick_1 = require("./Pick");
exports.ReadRawTaskOptionFields = [
    "readArgs",
    "ignoreMinorErrors",
    "useMWG",
];
exports.DefaultReadRawTaskOptions = {
    ...(0, Pick_1.pick)(DefaultExifToolOptions_1.DefaultExifToolOptions, ...exports.ReadRawTaskOptionFields),
};
class ReadRawTask extends ExifToolTask_1.ExifToolTask {
    sourceFile;
    args;
    static for(filename, options) {
        const args = [
            ...FilenameCharsetArgs_1.Utf8FilenameCharsetArgs,
            ...(options?.readArgs ?? []),
        ];
        const opts = { ...exports.DefaultReadRawTaskOptions, ...options };
        if (!args.includes("-json"))
            args.push("-json");
        if (opts.useMWG) {
            args.push("-use", "MWG");
        }
        const sourceFile = _path.resolve(filename);
        args.push(sourceFile);
        return new ReadRawTask(sourceFile, args, opts);
    }
    constructor(sourceFile, args, options) {
        super(args, options);
        this.sourceFile = sourceFile;
        this.args = args;
    }
    toString() {
        return "ReadRawTask(" + this.sourceFile + ")";
    }
    parse(data, err) {
        try {
            const tags = JSON.parse(data)[0];
            const { errors, warnings } = (0, ErrorsAndWarnings_1.errorsAndWarnings)(this, tags);
            tags.errors = errors;
            tags.warnings = warnings;
            return tags;
        }
        catch (jsonError) {
            (0, batch_cluster_1.logger)().error("ExifTool.ReadRawTask(): Invalid JSON", { data });
            throw err ?? jsonError;
        }
    }
}
exports.ReadRawTask = ReadRawTask;
//# sourceMappingURL=ReadRawTask.js.map